/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PersonSearchContext {
    private String code;
    private String registrationIdKz;
    private String externalCode;
    private Gender gender;
    private Date birthday;
    private final List<String> lastNames = new ArrayList<String>();
    private final List<String> firstNames = new ArrayList<String>();
    private final List<String> patronymic = new ArrayList<String>();
    private final List<PassportData> passportDatas = new ArrayList<PassportData>();
    private final List<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRegistrationIdKz() {
        return this.registrationIdKz;
    }

    public void setRegistrationIdKz(String registrationIdKz) {
        this.registrationIdKz = registrationIdKz;
    }

    public String getExternalCode() {
        return this.externalCode;
    }

    public void setExternalCode(String externalCode) {
        this.externalCode = externalCode;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public List<String> getLastNames() {
        return this.lastNames;
    }

    public List<String> getFirstNames() {
        return this.firstNames;
    }

    public List<String> getPatronymic() {
        return this.patronymic;
    }

    public List<PassportData> getPassportDatas() {
        return this.passportDatas;
    }

    public List<EntityReference<Organization>> getOrganizations() {
        return this.organizations;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("code -> " + this.code);
        stringBuilder.append("\n");
        stringBuilder.append("externalCode -> " + this.externalCode);
        stringBuilder.append("\n");
        stringBuilder.append("gender -> " + this.gender);
        stringBuilder.append("\n");
        stringBuilder.append("birthday -> " + this.birthday);
        stringBuilder.append("\n");
        stringBuilder.append("lastNames -> ");
        stringBuilder.append("\n");
        for (String string : this.lastNames) {
            stringBuilder.append("\n\t");
            stringBuilder.append("lastName -> " + string);
            stringBuilder.append("\n");
        }
        if (this.lastNames.size() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("firstNames -> ");
        stringBuilder.append("\n");
        for (String string : this.firstNames) {
            stringBuilder.append("\n\t");
            stringBuilder.append("firstName -> " + string);
            stringBuilder.append("\n");
        }
        if (this.firstNames.size() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("passportDatas -> ");
        stringBuilder.append("\n");
        for (PassportData passportData : this.passportDatas) {
            stringBuilder.append("\n\t");
            stringBuilder.append("lastName -> " + passportData.getLastName());
            stringBuilder.append("\n\t");
            stringBuilder.append("firstName -> " + passportData.getFirstName());
            stringBuilder.append("\n\t");
            stringBuilder.append("middleName -> " + passportData.getMiddleName());
            stringBuilder.append("\n\t");
            stringBuilder.append("gender -> " + passportData.getGender());
            stringBuilder.append("\n\t");
            stringBuilder.append("birthday -> " + passportData.getBirthday());
            stringBuilder.append("\n\t");
            stringBuilder.append("citizenship -> " + passportData.getCitizenship());
            stringBuilder.append("\n");
        }
        if (this.passportDatas.size() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("organizations -> ");
        stringBuilder.append("\n");
        for (EntityReference entityReference : this.organizations) {
            stringBuilder.append("\n\t");
            stringBuilder.append("organization -> " + entityReference);
            stringBuilder.append("\n");
        }
        if (this.organizations.size() > 0) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static class PassportData {
        private PassportType type;
        private String number;
        private String lastName;
        private String firstName;
        private String middleName;
        private Gender gender;
        private Date birthday;
        private DictionaryReference<Country> citizenship;

        public static PassportData create(Passport passport) {
            PassportData passportData = new PassportData();
            passportData.setType(passport.getType());
            passportData.setNumber(passport.getNumber());
            passportData.setLastName(passport.getLastName());
            passportData.setFirstName(passport.getFirstName());
            passportData.setMiddleName(passport.getMiddleName());
            passportData.setGender(passport.getGender());
            passportData.setBirthday(passport.getBirthday());
            passportData.setCitizenship((DictionaryReference<Country>)passport.getCitizenship());
            return passportData;
        }

        public PassportType getType() {
            return this.type;
        }

        public void setType(PassportType type) {
            this.type = type;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender gender) {
            this.gender = gender;
        }

        public Date getBirthday() {
            return this.birthday;
        }

        public void setBirthday(Date birthday) {
            this.birthday = birthday;
        }

        public DictionaryReference<Country> getCitizenship() {
            return this.citizenship;
        }

        public void setCitizenship(DictionaryReference<Country> citizenship) {
            this.citizenship = citizenship;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("type -> " + this.type);
            stringBuilder.append("\n");
            stringBuilder.append("number -> " + this.number);
            stringBuilder.append("\n");
            stringBuilder.append("lastName -> " + this.lastName);
            stringBuilder.append("\n");
            stringBuilder.append("firstName -> " + this.firstName);
            stringBuilder.append("\n");
            stringBuilder.append("middleName -> " + this.middleName);
            stringBuilder.append("\n");
            stringBuilder.append("gender -> " + this.gender);
            stringBuilder.append("\n");
            stringBuilder.append("birthday -> " + this.birthday);
            stringBuilder.append("\n");
            stringBuilder.append("citizenship -> " + this.citizenship);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

