/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ProductParserHelper {
    public static <T extends BaseProduct> ProductSearchResult searchProductSell(ProductSearchContext context, ProductParserHandler<T> handler) throws Exception {
        List<Object> criterions;
        EntityContainer bookingFileContainer = null;
        Object product = null;
        boolean exists = false;
        List productIndexes = Collections.emptyList();
        if (!TextUtil.isBlank((String)context.getSystemNumber())) {
            ArrayList<String> systemNumbers = new ArrayList<String>();
            systemNumbers.add(context.getSystemNumber());
            if (context.getConjunction() > 0) {
                long number = Long.parseLong(context.getSystemNumber());
                for (int i = 0; i < context.getConjunction(); ++i) {
                    systemNumbers.add(String.valueOf(number + (long)i + 1L));
                }
            }
            for (String systemNumber : systemNumbers) {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)systemNumber));
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.VOID), SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), null)}));
                if (context.getCategory() == ProductCategory.AIR) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                } else if (context.getCategory() == ProductCategory.MCO) {
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.travelSubject.name(), (Object)TravelSubject.AIR));
                } else if (context.getCategory() == ProductCategory.EXCESS_BAGAGE) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                }
                if (context.getBlankOwner() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), context.getBlankOwner()), SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), null)}));
                }
                if (context.getSupplier() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), context.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), null)}));
                }
                if (context.getAgency() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), null)}));
                }
                if (context.getSubagency() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), context.getSubagency()), SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), null)}));
                }
                if (context.getClient() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), context.getClient()), SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), null)}));
                }
                if ((criterions = context.getPayers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.payers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.payers.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                if ((criterions = context.getTravellerNames().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersNames.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersNames.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                if ((criterions = context.getTravellerPassportNumbers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersPassportsNumbers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersPassportsNumbers.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                if (productIndexes.size() <= 0) continue;
                break;
            }
        }
        if (productIndexes.size() == 0) {
            ProductSearchContext.ProductCreateResult productCreateResult;
            BookingFile bookingFile;
            Reservation reservation = null;
            BaseProduct relatedProduct = null;
            if (context.getRelatedProductType() != null && context.getRelatedProductStatus() != null && !TextUtil.isBlank((String)context.getRelatedSystemNumber())) {
                ArrayList<String> relatedSystemNumbers = new ArrayList<String>();
                relatedSystemNumbers.add(context.getRelatedSystemNumber());
                if (context.getRelatedConjunction() > 0) {
                    long number = Long.parseLong(context.getRelatedSystemNumber());
                    for (int i = 0; i < context.getRelatedConjunction(); ++i) {
                        relatedSystemNumbers.add(String.valueOf(number + (long)i + 1L));
                    }
                }
                for (String relatedSystemNumber : relatedSystemNumbers) {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)context.getRelatedProductType()));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)context.getRelatedProductStatus()));
                    query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)relatedSystemNumber));
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                    productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                    if (productIndexes.size() <= 0) continue;
                    break;
                }
            }
            if (productIndexes.size() == 0) {
                List bookingFileContainers = Collections.emptyList();
                if (!TextUtil.isBlank((String)context.getPnr())) {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)context.getPnr()));
                    if (context.getIssueDate() != null) {
                        Date issueDateStart = MiscUtil.addDaysToDate((Date)context.getIssueDate(), (int)(-handler.getThreshold()));
                        Date issueDateEnd = MiscUtil.addDaysToDate((Date)context.getIssueDate(), (int)handler.getThreshold());
                        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateStart));
                        query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateEnd));
                    }
                    if (context.getAgency() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), null)}));
                    }
                    criterions = new ArrayList<SearchCriterion>();
                    if (context.getClient() != null) {
                        criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), context.getClient()));
                        criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), null));
                    }
                    criterions.addAll(context.getPayers().stream().map(item -> SearchCriterion.contains((String)BookingFileIndex.Property.client.name(), (Object)item)).collect(Collectors.toList()));
                    if (criterions.size() > 0) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    bookingFileContainers = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(bf -> {
                        Reservation res = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)context.getPnr());
                        return res != null && (res.getProducts().isEmpty() || res.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION));
                    }).collect(Collectors.toList());
                }
                if (bookingFileContainers.size() == 0) {
                    bookingFile = new BookingFile();
                    bookingFile.setCustomerProfile(context.getClient());
                    reservation = new Reservation();
                    ProductParserHelper.setRecordLocator(reservation, context.getGdsName(), context.getPnr());
                    reservation.setResDate(context.getIssueDate());
                    reservation.setBookingFile(bookingFile);
                    bookingFile.getReservations().add(reservation);
                    bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
                } else {
                    bookingFileContainer = (EntityContainer)bookingFileContainers.get(0);
                    bookingFile = (BookingFile)bookingFileContainer.getEntity();
                    reservation = BookingHelper.findReservation((BookingFile)bookingFile, (String)context.getPnr());
                }
            } else {
                CommonProductIndex index2 = (CommonProductIndex)productIndexes.get(0);
                bookingFileContainer = EntityStorage.get().resolve(index2.getSource());
                bookingFile = (BookingFile)bookingFileContainer.getEntity();
                relatedProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)index2.getNavigationKey());
                reservation = relatedProduct.getReservation();
            }
            product = handler.createProduct();
            handler.setSystemNumber((BaseProduct)product, context.getSystemNumber());
            handler.setIssueDate((BaseProduct)product, context.getIssueDate());
            handler.setBlankOwner((BaseProduct)product, context.getBlankOwner());
            handler.setSupplier((BaseProduct)product, context.getSupplier());
            handler.setAgency((BaseProduct)product, context.getAgency());
            handler.setSubagency((BaseProduct)product, context.getSubagency());
            handler.setStatus((BaseProduct)product, ProductStatus.SELL);
            handler.setProductCategory((BaseProduct)product, context.getCategory());
            product.setReservation(reservation);
            reservation.getProducts().add(product);
            if (relatedProduct == null && context.getRelatedProductFactory() != null && (productCreateResult = context.getRelatedProductFactory().create(context.getRelatedProductStatus(), context.getRelatedSystemNumber())) != null) {
                relatedProduct = productCreateResult.getProduct();
                for (BaseProduct baseProduct : productCreateResult.getProducts()) {
                    baseProduct.setReservation(reservation);
                    reservation.getProducts().add(baseProduct);
                }
            }
            if (relatedProduct != null) {
                handler.addRelatedProduct((BaseProduct)product, relatedProduct);
            }
        } else {
            CommonProductIndex index3 = (CommonProductIndex)productIndexes.get(0);
            bookingFileContainer = EntityStorage.get().resolve(index3.getSource());
            BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
            product = BookingHelper.findProduct((BookingFile)bookingFile, (String)index3.getNavigationKey());
            if (GeneralProductHelper.getHandler((BaseProduct)product).getTicketType(product) != TicketType.FAKE) {
                exists = true;
            }
        }
        ProductSearchResult productSearchResult = new ProductSearchResult();
        productSearchResult.setBookingFile((EntityContainer<BookingFile>)bookingFileContainer);
        productSearchResult.setProduct((BaseProduct)product);
        productSearchResult.setExists(exists);
        return productSearchResult;
    }

    public static <T extends BaseProduct> ProductSearchResult searchProductRefund(ProductSearchContext context, ProductParserHandler<T> handler) throws Exception {
        EntityContainer bookingFileContainer = null;
        Object product = null;
        boolean exists = false;
        List productIndexes = Collections.emptyList();
        if (!TextUtil.isBlank((String)context.getSystemNumber())) {
            ArrayList<String> systemNumbers = new ArrayList<String>();
            systemNumbers.add(context.getSystemNumber());
            if (context.getConjunction() > 0) {
                long number = Long.parseLong(context.getSystemNumber());
                for (int i = 0; i < context.getConjunction(); ++i) {
                    systemNumbers.add(String.valueOf(number + (long)i + 1L));
                }
            }
            for (String systemNumber : systemNumbers) {
                List<SearchCriterion> criterions;
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)systemNumber));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.REFUND));
                if (context.getCategory() == ProductCategory.AIR) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                } else if (context.getCategory() == ProductCategory.MCO) {
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.travelSubject.name(), (Object)TravelSubject.AIR));
                } else if (context.getCategory() == ProductCategory.EXCESS_BAGAGE) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                }
                if (context.getBlankOwner() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), context.getBlankOwner()), SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), null)}));
                }
                if (context.getSupplier() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), context.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), null)}));
                }
                if (context.getAgency() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), null)}));
                }
                if (context.getSubagency() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), context.getSubagency()), SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), null)}));
                }
                if (context.getClient() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), context.getClient()), SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), null)}));
                }
                if ((criterions = context.getPayers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.payers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.payers.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                if ((criterions = context.getTravellerNames().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersNames.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersNames.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                if ((criterions = context.getTravellerPassportNumbers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersPassportsNumbers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersPassportsNumbers.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                if (productIndexes.size() <= 0) continue;
                break;
            }
        }
        if (productIndexes.size() == 0) {
            ProductSearchContext.ProductCreateResult productCreateResult;
            CommonProductIndex index2;
            BookingFile bookingFile;
            int i;
            Reservation reservation = null;
            Object previousSellProduct = null;
            BaseProduct relatedProduct = null;
            if (!TextUtil.isBlank((String)context.getSystemNumber())) {
                ArrayList<String> systemNumbers = new ArrayList<String>();
                systemNumbers.add(context.getSystemNumber());
                if (context.getConjunction() > 0) {
                    long number = Long.parseLong(context.getSystemNumber());
                    for (i = 0; i < context.getConjunction(); ++i) {
                        systemNumbers.add(String.valueOf(number + (long)i + 1L));
                    }
                }
                for (String systemNumber : systemNumbers) {
                    List<SearchCriterion> criterions;
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)systemNumber));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
                    if (context.getCategory() == ProductCategory.AIR) {
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                    } else if (context.getCategory() == ProductCategory.MCO) {
                        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.travelSubject.name(), (Object)TravelSubject.AIR));
                    } else if (context.getCategory() == ProductCategory.EXCESS_BAGAGE) {
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                    }
                    if (context.getBlankOwner() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), context.getBlankOwner()), SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), null)}));
                    }
                    if (context.getSupplier() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), context.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), null)}));
                    }
                    if (context.getAgency() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), null)}));
                    }
                    if (context.getSubagency() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), context.getSubagency()), SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), null)}));
                    }
                    if (context.getClient() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), context.getClient()), SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), null)}));
                    }
                    if ((criterions = context.getPayers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.payers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                        criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.payers.name()));
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    if ((criterions = context.getTravellerNames().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersNames.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                        criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersNames.name()));
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    if ((criterions = context.getTravellerPassportNumbers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersPassportsNumbers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                        criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersPassportsNumbers.name()));
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                    productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                    if (productIndexes.size() <= 0) continue;
                    break;
                }
            }
            if (productIndexes.size() == 0) {
                if (context.getRelatedProductType() != null && context.getRelatedProductStatus() != null && !TextUtil.isBlank((String)context.getRelatedSystemNumber())) {
                    ArrayList<String> relatedSystemNumbers = new ArrayList<String>();
                    relatedSystemNumbers.add(context.getRelatedSystemNumber());
                    if (context.getRelatedConjunction() > 0) {
                        long number = Long.parseLong(context.getRelatedSystemNumber());
                        for (i = 0; i < context.getRelatedConjunction(); ++i) {
                            relatedSystemNumbers.add(String.valueOf(number + (long)i + 1L));
                        }
                    }
                    for (String relatedSystemNumber : relatedSystemNumbers) {
                        SearchQuery query = new SearchQuery();
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)context.getRelatedProductType()));
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)context.getRelatedProductStatus()));
                        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)relatedSystemNumber));
                        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                        productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                        if (productIndexes.size() <= 0) continue;
                        break;
                    }
                }
                if (productIndexes.size() == 0) {
                    List bookingFileContainers = Collections.emptyList();
                    if (!TextUtil.isBlank((String)context.getPnr())) {
                        SearchQuery query = new SearchQuery();
                        query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)context.getPnr()));
                        if (context.getIssueDate() != null) {
                            Date issueDateStart = MiscUtil.addDaysToDate((Date)context.getIssueDate(), (int)(-handler.getThreshold()));
                            Date issueDateEnd = MiscUtil.addDaysToDate((Date)context.getIssueDate(), (int)handler.getThreshold());
                            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateStart));
                            query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateEnd));
                        }
                        if (context.getAgency() != null) {
                            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), null)}));
                        }
                        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
                        if (context.getClient() != null) {
                            criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), context.getClient()));
                            criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), null));
                        }
                        criterions.addAll(context.getPayers().stream().map(item -> SearchCriterion.contains((String)BookingFileIndex.Property.client.name(), (Object)item)).collect(Collectors.toList()));
                        if (criterions.size() > 0) {
                            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                        }
                        bookingFileContainers = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(bf -> {
                            Reservation res = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)context.getPnr());
                            return res != null && (res.getProducts().isEmpty() || res.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION));
                        }).collect(Collectors.toList());
                    }
                    if (bookingFileContainers.size() == 0) {
                        bookingFile = new BookingFile();
                        bookingFile.setCustomerProfile(context.getClient());
                        reservation = new Reservation();
                        ProductParserHelper.setRecordLocator(reservation, context.getGdsName(), context.getPnr());
                        reservation.setResDate(context.getIssueDate());
                        reservation.setBookingFile(bookingFile);
                        bookingFile.getReservations().add(reservation);
                        bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
                    } else {
                        bookingFileContainer = (EntityContainer)bookingFileContainers.get(0);
                        bookingFile = (BookingFile)bookingFileContainer.getEntity();
                        reservation = BookingHelper.findReservation((BookingFile)bookingFile, (String)context.getPnr());
                    }
                } else {
                    index2 = (CommonProductIndex)productIndexes.get(0);
                    bookingFileContainer = EntityStorage.get().resolve(index2.getSource());
                    bookingFile = (BookingFile)bookingFileContainer.getEntity();
                    relatedProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)index2.getNavigationKey());
                    reservation = relatedProduct.getReservation();
                }
                previousSellProduct = handler.createProduct();
                handler.setSystemNumber((BaseProduct)previousSellProduct, context.getSystemNumber());
                handler.setBlankOwner((BaseProduct)previousSellProduct, context.getBlankOwner());
                handler.setSupplier((BaseProduct)previousSellProduct, context.getSupplier());
                handler.setAgency((BaseProduct)previousSellProduct, context.getAgency());
                handler.setSubagency((BaseProduct)previousSellProduct, context.getSubagency());
                handler.setStatus((BaseProduct)previousSellProduct, ProductStatus.SELL);
                handler.setProductCategory((BaseProduct)previousSellProduct, context.getCategory());
                handler.setTicketType((BaseProduct)previousSellProduct, TicketType.FAKE);
                previousSellProduct.setReservation(reservation);
                reservation.getProducts().add(previousSellProduct);
            } else {
                index2 = (CommonProductIndex)productIndexes.get(0);
                bookingFileContainer = EntityStorage.get().resolve(index2.getSource());
                bookingFile = (BookingFile)bookingFileContainer.getEntity();
                previousSellProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)index2.getNavigationKey());
                reservation = previousSellProduct.getReservation();
            }
            product = handler.createProduct();
            handler.setSystemNumber((BaseProduct)product, context.getSystemNumber());
            handler.setIssueDate((BaseProduct)product, context.getIssueDate());
            handler.setBlankOwner((BaseProduct)product, context.getBlankOwner());
            handler.setSupplier((BaseProduct)product, context.getSupplier());
            handler.setAgency((BaseProduct)product, context.getAgency());
            handler.setSubagency((BaseProduct)product, context.getSubagency());
            handler.setStatus((BaseProduct)product, ProductStatus.REFUND);
            handler.setProductCategory((BaseProduct)product, context.getCategory());
            handler.setNextProduct((BaseProduct)previousSellProduct, (BaseProduct)product);
            handler.setPreviousProduct((BaseProduct)product, (BaseProduct)previousSellProduct);
            product.setReservation(reservation);
            reservation.getProducts().add(product);
            if (relatedProduct == null && context.getRelatedProductType() != null && context.getRelatedProductStatus() != null && context.getRelatedSystemNumber() != null) {
                relatedProduct = BookingHelper.findProduct((Reservation)reservation, (ProductType)context.getRelatedProductType(), (ProductStatus)context.getRelatedProductStatus(), (String)context.getRelatedSystemNumber());
            }
            if (relatedProduct == null && context.getRelatedProductFactory() != null && (productCreateResult = context.getRelatedProductFactory().create(context.getRelatedProductStatus(), context.getRelatedSystemNumber())) != null) {
                relatedProduct = productCreateResult.getProduct();
                for (BaseProduct baseProduct : productCreateResult.getProducts()) {
                    baseProduct.setReservation(reservation);
                    reservation.getProducts().add(baseProduct);
                }
            }
            if (relatedProduct != null) {
                handler.addRelatedProduct((BaseProduct)product, relatedProduct);
            }
        } else {
            CommonProductIndex index3 = (CommonProductIndex)productIndexes.get(0);
            bookingFileContainer = EntityStorage.get().resolve(index3.getSource());
            BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
            product = BookingHelper.findProduct((BookingFile)bookingFile, (String)index3.getNavigationKey());
            if (GeneralProductHelper.getHandler((BaseProduct)product).getTicketType(product) != TicketType.FAKE) {
                exists = true;
            }
        }
        ProductSearchResult productSearchResult = new ProductSearchResult();
        productSearchResult.setBookingFile((EntityContainer<BookingFile>)bookingFileContainer);
        productSearchResult.setProduct((BaseProduct)product);
        productSearchResult.setExists(exists);
        return productSearchResult;
    }

    public static <T extends BaseProduct> ProductSearchResult searchProductExchange(ProductSearchContext context, ProductParserHandler<T> handler) throws Exception {
        EntityContainer bookingFileContainer = null;
        Object product = null;
        boolean exists = false;
        List productIndexes = Collections.emptyList();
        if (!TextUtil.isBlank((String)context.getSystemNumber())) {
            ArrayList<String> systemNumbers = new ArrayList<String>();
            systemNumbers.add(context.getSystemNumber());
            if (context.getConjunction() > 0) {
                long number = Long.parseLong(context.getSystemNumber());
                for (int i = 0; i < context.getConjunction(); ++i) {
                    systemNumbers.add(String.valueOf(number + (long)i + 1L));
                }
            }
            for (String systemNumber : systemNumbers) {
                List<SearchCriterion> criterions;
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)systemNumber));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
                if (context.getCategory() == ProductCategory.AIR) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                } else if (context.getCategory() == ProductCategory.MCO) {
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.travelSubject.name(), (Object)TravelSubject.AIR));
                } else if (context.getCategory() == ProductCategory.EXCESS_BAGAGE) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                }
                if (context.getBlankOwner() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), context.getBlankOwner()), SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), null)}));
                }
                if (context.getSupplier() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), context.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), null)}));
                }
                if (context.getAgency() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), null)}));
                }
                if (context.getSubagency() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), context.getSubagency()), SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), null)}));
                }
                if (context.getClient() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), context.getClient()), SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), null)}));
                }
                if ((criterions = context.getPayers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.payers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.payers.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                if ((criterions = context.getTravellerNames().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersNames.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersNames.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                if ((criterions = context.getTravellerPassportNumbers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersPassportsNumbers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersPassportsNumbers.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                if (productIndexes.size() <= 0) continue;
                break;
            }
        }
        if (productIndexes.size() == 0) {
            BookingFile bookingFile;
            Reservation reservation = null;
            Object previousSellProduct = null;
            Object previousExchangeProduct = null;
            if (!TextUtil.isBlank((String)context.getPreviousSystemNumber())) {
                ArrayList<String> previousSystemNumbers = new ArrayList<String>();
                previousSystemNumbers.add(context.getPreviousSystemNumber());
                if (context.getPreviousConjunction() > 0) {
                    long number = Long.parseLong(context.getPreviousSystemNumber());
                    for (int i = 0; i < context.getPreviousConjunction(); ++i) {
                        previousSystemNumbers.add(String.valueOf(number + (long)i + 1L));
                    }
                }
                for (String previousSystemNumber : previousSystemNumbers) {
                    List<SearchCriterion> criterions;
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)previousSystemNumber));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
                    if (context.getCategory() == ProductCategory.AIR) {
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                    } else if (context.getCategory() == ProductCategory.MCO) {
                        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.travelSubject.name(), (Object)TravelSubject.AIR));
                    } else if (context.getCategory() == ProductCategory.EXCESS_BAGAGE) {
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                    }
                    if (context.getBlankOwner() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), context.getBlankOwner()), SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), null)}));
                    }
                    if (context.getSupplier() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), context.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), null)}));
                    }
                    if (context.getAgency() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), null)}));
                    }
                    if (context.getSubagency() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), context.getSubagency()), SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), null)}));
                    }
                    if (context.getClient() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), context.getClient()), SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), null)}));
                    }
                    if ((criterions = context.getPayers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.payers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                        criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.payers.name()));
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    if ((criterions = context.getPreviousTravellerNames().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersNames.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                        criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersNames.name()));
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    if ((criterions = context.getPreviousTravellerPassportNumbers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersPassportsNumbers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                        criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersPassportsNumbers.name()));
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                    productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                    if (productIndexes.size() <= 0) continue;
                    break;
                }
            }
            if (productIndexes.size() == 0) {
                List bookingFileContainers = Collections.emptyList();
                if (!TextUtil.isBlank((String)context.getPnr())) {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)context.getPnr()));
                    if (context.getIssueDate() != null) {
                        Date issueDateStart = MiscUtil.addDaysToDate((Date)context.getIssueDate(), (int)(-handler.getThreshold()));
                        Date issueDateEnd = MiscUtil.addDaysToDate((Date)context.getIssueDate(), (int)handler.getThreshold());
                        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateStart));
                        query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateEnd));
                    }
                    if (context.getAgency() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), null)}));
                    }
                    ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
                    if (context.getClient() != null) {
                        criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), context.getClient()));
                        criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), null));
                    }
                    criterions.addAll(context.getPayers().stream().map(item -> SearchCriterion.contains((String)BookingFileIndex.Property.client.name(), (Object)item)).collect(Collectors.toList()));
                    if (criterions.size() > 0) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    bookingFileContainers = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(bf -> {
                        Reservation res = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)context.getPnr());
                        return res != null && (res.getProducts().isEmpty() || res.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION));
                    }).collect(Collectors.toList());
                }
                if (bookingFileContainers.size() == 0) {
                    bookingFile = new BookingFile();
                    bookingFile.setCustomerProfile(context.getClient());
                    reservation = new Reservation();
                    ProductParserHelper.setRecordLocator(reservation, context.getGdsName(), context.getPnr());
                    reservation.setResDate(context.getIssueDate());
                    reservation.setBookingFile(bookingFile);
                    bookingFile.getReservations().add(reservation);
                    bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
                } else {
                    bookingFileContainer = (EntityContainer)bookingFileContainers.get(0);
                    bookingFile = (BookingFile)bookingFileContainer.getEntity();
                    reservation = BookingHelper.findReservation((BookingFile)bookingFile, (String)context.getPnr());
                }
                previousSellProduct = handler.createProduct();
                handler.setSystemNumber((BaseProduct)previousSellProduct, context.getPreviousSystemNumber());
                handler.setBlankOwner((BaseProduct)previousSellProduct, context.getBlankOwner());
                handler.setSupplier((BaseProduct)previousSellProduct, context.getSupplier());
                handler.setAgency((BaseProduct)previousSellProduct, context.getAgency());
                handler.setSubagency((BaseProduct)previousSellProduct, context.getSubagency());
                handler.setStatus((BaseProduct)previousSellProduct, ProductStatus.SELL);
                handler.setProductCategory((BaseProduct)previousSellProduct, context.getCategory());
                handler.setTicketType((BaseProduct)previousSellProduct, TicketType.FAKE);
                previousSellProduct.setReservation(reservation);
                reservation.getProducts().add(previousSellProduct);
            } else {
                CommonProductIndex index2 = (CommonProductIndex)productIndexes.get(0);
                bookingFileContainer = EntityStorage.get().resolve(index2.getSource());
                bookingFile = (BookingFile)bookingFileContainer.getEntity();
                previousSellProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)index2.getNavigationKey());
                reservation = previousSellProduct.getReservation();
            }
            previousExchangeProduct = handler.createProduct();
            handler.setSystemNumber((BaseProduct)previousExchangeProduct, context.getPreviousSystemNumber());
            handler.setIssueDate((BaseProduct)previousExchangeProduct, context.getIssueDate());
            handler.setBlankOwner((BaseProduct)previousExchangeProduct, context.getBlankOwner());
            handler.setSupplier((BaseProduct)previousExchangeProduct, context.getSupplier());
            handler.setAgency((BaseProduct)previousExchangeProduct, context.getAgency());
            handler.setSubagency((BaseProduct)previousExchangeProduct, context.getSubagency());
            handler.setStatus((BaseProduct)previousExchangeProduct, ProductStatus.EXCHANGE);
            handler.setProductCategory((BaseProduct)previousExchangeProduct, context.getCategory());
            if (GeneralProductHelper.getHandler((BaseProduct)previousSellProduct).getTicketType(previousSellProduct) == TicketType.FAKE) {
                handler.setTicketType((BaseProduct)previousExchangeProduct, TicketType.FAKE);
            }
            handler.setNextProduct((BaseProduct)previousSellProduct, (BaseProduct)previousExchangeProduct);
            handler.setPreviousProduct((BaseProduct)previousExchangeProduct, (BaseProduct)previousSellProduct);
            previousExchangeProduct.setReservation(reservation);
            reservation.getProducts().add(previousExchangeProduct);
            product = handler.createProduct();
            handler.setSystemNumber((BaseProduct)product, context.getSystemNumber());
            handler.setIssueDate((BaseProduct)product, context.getIssueDate());
            handler.setBlankOwner((BaseProduct)product, context.getBlankOwner());
            handler.setSupplier((BaseProduct)product, context.getSupplier());
            handler.setAgency((BaseProduct)product, context.getAgency());
            handler.setSubagency((BaseProduct)product, context.getSubagency());
            handler.setStatus((BaseProduct)product, ProductStatus.SELL);
            handler.setProductCategory((BaseProduct)product, context.getCategory());
            handler.setNextProduct((BaseProduct)previousExchangeProduct, (BaseProduct)product);
            handler.setPreviousProduct((BaseProduct)product, (BaseProduct)previousExchangeProduct);
            product.setReservation(reservation);
            reservation.getProducts().add(product);
        } else {
            CommonProductIndex index3 = (CommonProductIndex)productIndexes.get(0);
            bookingFileContainer = EntityStorage.get().resolve(index3.getSource());
            BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
            product = BookingHelper.findProduct((BookingFile)bookingFile, (String)index3.getNavigationKey());
            if (GeneralProductHelper.getHandler((BaseProduct)product).getTicketType(product) == TicketType.FAKE && GeneralProductHelper.getHandler((BaseProduct)product).getPreviousProduct(product) == null) {
                Reservation reservation = product.getReservation();
                T previousSellProduct = handler.createProduct();
                handler.setSystemNumber((BaseProduct)previousSellProduct, context.getPreviousSystemNumber());
                handler.setBlankOwner((BaseProduct)previousSellProduct, context.getBlankOwner());
                handler.setSupplier((BaseProduct)previousSellProduct, context.getSupplier());
                handler.setAgency((BaseProduct)previousSellProduct, context.getAgency());
                handler.setSubagency((BaseProduct)previousSellProduct, context.getSubagency());
                handler.setStatus((BaseProduct)previousSellProduct, ProductStatus.SELL);
                handler.setProductCategory((BaseProduct)previousSellProduct, context.getCategory());
                handler.setTicketType((BaseProduct)previousSellProduct, TicketType.FAKE);
                previousSellProduct.setReservation(reservation);
                reservation.getProducts().add(previousSellProduct);
                T previousExchangeProduct = handler.createProduct();
                handler.setSystemNumber((BaseProduct)previousExchangeProduct, context.getPreviousSystemNumber());
                handler.setIssueDate((BaseProduct)previousExchangeProduct, context.getIssueDate());
                handler.setBlankOwner((BaseProduct)previousExchangeProduct, context.getBlankOwner());
                handler.setSupplier((BaseProduct)previousExchangeProduct, context.getSupplier());
                handler.setAgency((BaseProduct)previousExchangeProduct, context.getAgency());
                handler.setSubagency((BaseProduct)previousExchangeProduct, context.getSubagency());
                handler.setStatus((BaseProduct)previousExchangeProduct, ProductStatus.EXCHANGE);
                handler.setProductCategory((BaseProduct)previousExchangeProduct, context.getCategory());
                handler.setTicketType((BaseProduct)previousExchangeProduct, TicketType.FAKE);
                handler.setNextProduct((BaseProduct)previousSellProduct, (BaseProduct)previousExchangeProduct);
                handler.setPreviousProduct((BaseProduct)previousExchangeProduct, (BaseProduct)previousSellProduct);
                previousExchangeProduct.setReservation(reservation);
                reservation.getProducts().add(previousExchangeProduct);
                handler.setNextProduct((BaseProduct)previousExchangeProduct, (BaseProduct)product);
                handler.setPreviousProduct((BaseProduct)product, (BaseProduct)previousExchangeProduct);
            }
            if (GeneralProductHelper.getHandler((BaseProduct)product).getTicketType(product) != TicketType.FAKE) {
                exists = true;
            }
        }
        ProductSearchResult productSearchResult = new ProductSearchResult();
        productSearchResult.setBookingFile((EntityContainer<BookingFile>)bookingFileContainer);
        productSearchResult.setProduct((BaseProduct)product);
        productSearchResult.setExists(exists);
        return productSearchResult;
    }

    public static <T extends BaseProduct> ProductSearchResult searchProductVoid(ProductSearchContext context, ProductParserHandler<T> handler) throws Exception {
        List<Object> criterions;
        EntityContainer bookingFileContainer = null;
        Object product = null;
        boolean exists = false;
        List productIndexes = Collections.emptyList();
        if (!TextUtil.isBlank((String)context.getSystemNumber())) {
            ArrayList<String> systemNumbers = new ArrayList<String>();
            systemNumbers.add(context.getSystemNumber());
            if (context.getConjunction() > 0) {
                long number = Long.parseLong(context.getSystemNumber());
                for (int i = 0; i < context.getConjunction(); ++i) {
                    systemNumbers.add(String.valueOf(number + (long)i + 1L));
                }
            }
            for (String systemNumber : systemNumbers) {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)systemNumber));
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.VOID), SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), null)}));
                if (context.getCategory() == ProductCategory.AIR) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                } else if (context.getCategory() == ProductCategory.MCO) {
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.AIR_TICKET));
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.travelSubject.name(), (Object)TravelSubject.AIR));
                } else if (context.getCategory() == ProductCategory.EXCESS_BAGAGE) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)ProductType.EXCESS_BAGAGE));
                }
                if (context.getBlankOwner() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), context.getBlankOwner()), SearchCriterion.eq((String)CommonProductIndex.Property.blankOwner.name(), null)}));
                }
                if (context.getSupplier() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), context.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), null)}));
                }
                if (context.getAgency() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), null)}));
                }
                if (context.getSubagency() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), context.getSubagency()), SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), null)}));
                }
                if (context.getClient() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), context.getClient()), SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), null)}));
                }
                if ((criterions = context.getPayers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.payers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.payers.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                if ((criterions = context.getTravellerNames().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersNames.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersNames.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                if ((criterions = context.getTravellerPassportNumbers().stream().map(item -> SearchCriterion.contains((String)CommonProductIndex.Property.travellersPassportsNumbers.name(), (Object)item)).collect(Collectors.toList())).size() > 0) {
                    criterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.travellersPassportsNumbers.name()));
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                }
                query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                if (productIndexes.size() <= 0) continue;
                break;
            }
        }
        if (productIndexes.size() == 0) {
            ProductSearchContext.ProductCreateResult productCreateResult;
            Object bookingFile;
            Reservation reservation = null;
            BaseProduct relatedProduct = null;
            if (context.getRelatedProductType() != null && context.getRelatedProductStatus() != null && !TextUtil.isBlank((String)context.getRelatedSystemNumber())) {
                ArrayList<String> relatedSystemNumbers = new ArrayList<String>();
                relatedSystemNumbers.add(context.getRelatedSystemNumber());
                if (context.getRelatedConjunction() > 0) {
                    long number = Long.parseLong(context.getRelatedSystemNumber());
                    for (int i = 0; i < context.getRelatedConjunction(); ++i) {
                        relatedSystemNumbers.add(String.valueOf(number + (long)i + 1L));
                    }
                }
                for (String relatedSystemNumber : relatedSystemNumbers) {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)context.getRelatedProductType()));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)context.getRelatedProductStatus()));
                    query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)relatedSystemNumber));
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                    productIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                    if (productIndexes.size() <= 0) continue;
                    break;
                }
            }
            if (productIndexes.size() == 0) {
                List bookingFileContainers = Collections.emptyList();
                if (!TextUtil.isBlank((String)context.getPnr())) {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)context.getPnr()));
                    if (context.getIssueDate() != null) {
                        Date issueDateStart = MiscUtil.addDaysToDate((Date)context.getIssueDate(), (int)(-handler.getThreshold()));
                        Date issueDateEnd = MiscUtil.addDaysToDate((Date)context.getIssueDate(), (int)handler.getThreshold());
                        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateStart));
                        query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateEnd));
                    }
                    if (context.getAgency() != null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), context.getAgency()), SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), null)}));
                    }
                    criterions = new ArrayList<SearchCriterion>();
                    if (context.getClient() != null) {
                        criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), context.getClient()));
                        criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), null));
                    }
                    criterions.addAll(context.getPayers().stream().map(item -> SearchCriterion.contains((String)BookingFileIndex.Property.client.name(), (Object)item)).collect(Collectors.toList()));
                    if (criterions.size() > 0) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
                    }
                    bookingFileContainers = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(bf -> {
                        Reservation res = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)context.getPnr());
                        return res != null && (res.getProducts().isEmpty() || res.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION));
                    }).collect(Collectors.toList());
                }
                if (bookingFileContainers.size() == 0) {
                    bookingFile = new BookingFile();
                    bookingFile.setCustomerProfile(context.getClient());
                    reservation = new Reservation();
                    ProductParserHelper.setRecordLocator(reservation, context.getGdsName(), context.getPnr());
                    reservation.setResDate(context.getIssueDate());
                    reservation.setBookingFile((BookingFile)bookingFile);
                    bookingFile.getReservations().add(reservation);
                    bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
                } else {
                    bookingFileContainer = (EntityContainer)bookingFileContainers.get(0);
                    bookingFile = (BookingFile)bookingFileContainer.getEntity();
                    reservation = BookingHelper.findReservation((BookingFile)bookingFile, (String)context.getPnr());
                }
            } else {
                CommonProductIndex index2 = (CommonProductIndex)productIndexes.get(0);
                bookingFileContainer = EntityStorage.get().resolve(index2.getSource());
                bookingFile = (BookingFile)bookingFileContainer.getEntity();
                relatedProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)index2.getNavigationKey());
                reservation = relatedProduct.getReservation();
            }
            product = handler.createProduct();
            handler.setSystemNumber((BaseProduct)product, context.getSystemNumber());
            handler.setIssueDate((BaseProduct)product, context.getIssueDate());
            handler.setBlankOwner((BaseProduct)product, context.getBlankOwner());
            handler.setSupplier((BaseProduct)product, context.getSupplier());
            handler.setAgency((BaseProduct)product, context.getAgency());
            handler.setSubagency((BaseProduct)product, context.getSubagency());
            handler.setStatus((BaseProduct)product, ProductStatus.VOID);
            handler.setProductCategory((BaseProduct)product, context.getCategory());
            product.setReservation(reservation);
            reservation.getProducts().add(product);
            if (relatedProduct == null && context.getRelatedProductFactory() != null && (productCreateResult = context.getRelatedProductFactory().create(context.getRelatedProductStatus(), context.getRelatedSystemNumber())) != null) {
                relatedProduct = productCreateResult.getProduct();
                for (BaseProduct baseProduct : productCreateResult.getProducts()) {
                    baseProduct.setReservation(reservation);
                    reservation.getProducts().add(baseProduct);
                }
            }
            if (relatedProduct != null) {
                handler.addRelatedProduct((BaseProduct)product, relatedProduct);
            }
        } else {
            CommonProductIndex index3 = (CommonProductIndex)productIndexes.get(0);
            bookingFileContainer = EntityStorage.get().resolve(index3.getSource());
            BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
            product = BookingHelper.findProduct((BookingFile)bookingFile, (String)index3.getNavigationKey());
            if (GeneralProductHelper.getHandler((BaseProduct)product).getTicketType(product) != TicketType.FAKE) {
                exists = true;
            }
            if (GeneralProductHelper.getHandler((BaseProduct)product).getStatus(product) == ProductStatus.SELL) {
                BaseProduct exchangeProduct = GeneralProductHelper.getHandler((BaseProduct)product).getPreviousProduct(product);
                if (exchangeProduct != null && GeneralProductHelper.getHandler((BaseProduct)exchangeProduct).getStatus(exchangeProduct) == ProductStatus.EXCHANGE) {
                    BaseProduct sellProduct = GeneralProductHelper.getHandler((BaseProduct)exchangeProduct).getPreviousProduct(exchangeProduct);
                    if (sellProduct != null && GeneralProductHelper.getHandler((BaseProduct)sellProduct).getStatus(sellProduct) == ProductStatus.SELL) {
                        handler.setNextProduct(sellProduct, null);
                    }
                    product.getReservation().getProducts().remove(exchangeProduct);
                }
                handler.setPreviousProduct((BaseProduct)product, (BaseProduct)null);
            }
        }
        ProductSearchResult productSearchResult = new ProductSearchResult();
        productSearchResult.setBookingFile((EntityContainer<BookingFile>)bookingFileContainer);
        productSearchResult.setProduct((BaseProduct)product);
        productSearchResult.setExists(exists);
        return productSearchResult;
    }

    public static <T extends BaseProduct> ProductSearchContext.ProductCreateResult createProduct(ProductStatus status, String systemNumber, ProductCategory category, ProductParserHandler<T> handler) {
        if (status == ProductStatus.SELL) {
            T sellProduct = handler.createProduct();
            handler.setProductCategory(sellProduct, category);
            handler.setStatus(sellProduct, ProductStatus.SELL);
            handler.setSystemNumber(sellProduct, systemNumber);
            handler.setTicketType(sellProduct, TicketType.FAKE);
            ProductSearchContext.ProductCreateResult productCreateResult = new ProductSearchContext.ProductCreateResult();
            productCreateResult.setProduct((BaseProduct)sellProduct);
            productCreateResult.getProducts().clear();
            productCreateResult.getProducts().add((BaseProduct)sellProduct);
            return productCreateResult;
        }
        if (status == ProductStatus.REFUND) {
            T sellProduct = handler.createProduct();
            handler.setProductCategory(sellProduct, category);
            handler.setStatus(sellProduct, ProductStatus.SELL);
            handler.setSystemNumber(sellProduct, systemNumber);
            handler.setTicketType(sellProduct, TicketType.FAKE);
            T refundProduct = handler.createProduct();
            handler.setProductCategory(refundProduct, category);
            handler.setStatus(refundProduct, ProductStatus.REFUND);
            handler.setSystemNumber(refundProduct, systemNumber);
            handler.setTicketType(refundProduct, TicketType.FAKE);
            handler.setNextProduct(sellProduct, refundProduct);
            handler.setPreviousProduct(refundProduct, sellProduct);
            ProductSearchContext.ProductCreateResult productCreateResult = new ProductSearchContext.ProductCreateResult();
            productCreateResult.setProduct((BaseProduct)refundProduct);
            productCreateResult.getProducts().clear();
            productCreateResult.getProducts().add((BaseProduct)sellProduct);
            productCreateResult.getProducts().add((BaseProduct)refundProduct);
            return productCreateResult;
        }
        if (status == ProductStatus.EXCHANGE) {
            T previousSellProduct = handler.createProduct();
            handler.setProductCategory(previousSellProduct, category);
            handler.setStatus(previousSellProduct, ProductStatus.SELL);
            handler.setSystemNumber(previousSellProduct, null);
            handler.setTicketType(previousSellProduct, TicketType.FAKE);
            T exchangeProduct = handler.createProduct();
            handler.setProductCategory(exchangeProduct, category);
            handler.setStatus(exchangeProduct, ProductStatus.EXCHANGE);
            handler.setSystemNumber(exchangeProduct, null);
            handler.setTicketType(exchangeProduct, TicketType.FAKE);
            T sellProduct = handler.createProduct();
            handler.setProductCategory(sellProduct, category);
            handler.setStatus(sellProduct, ProductStatus.EXCHANGE);
            handler.setSystemNumber(sellProduct, systemNumber);
            handler.setTicketType(sellProduct, TicketType.FAKE);
            handler.setNextProduct(previousSellProduct, exchangeProduct);
            handler.setPreviousProduct(exchangeProduct, previousSellProduct);
            handler.setNextProduct(exchangeProduct, sellProduct);
            handler.setPreviousProduct(sellProduct, exchangeProduct);
            ProductSearchContext.ProductCreateResult productCreateResult = new ProductSearchContext.ProductCreateResult();
            productCreateResult.setProduct((BaseProduct)sellProduct);
            productCreateResult.getProducts().clear();
            productCreateResult.getProducts().add((BaseProduct)previousSellProduct);
            productCreateResult.getProducts().add((BaseProduct)exchangeProduct);
            productCreateResult.getProducts().add((BaseProduct)sellProduct);
            return productCreateResult;
        }
        if (status == ProductStatus.VOID) {
            T voidProduct = handler.createProduct();
            handler.setProductCategory(voidProduct, category);
            handler.setStatus(voidProduct, ProductStatus.VOID);
            handler.setSystemNumber(voidProduct, systemNumber);
            handler.setTicketType(voidProduct, TicketType.FAKE);
            ProductSearchContext.ProductCreateResult productCreateResult = new ProductSearchContext.ProductCreateResult();
            productCreateResult.setProduct((BaseProduct)voidProduct);
            productCreateResult.getProducts().clear();
            productCreateResult.getProducts().add((BaseProduct)voidProduct);
            return productCreateResult;
        }
        return null;
    }

    public static void setRecordLocator(Reservation reservation, GdsName gdsName, String recordLocator) {
        if (TextUtil.isBlank((String)recordLocator) || gdsName == null) {
            return;
        }
        if (GdsName.SIRENA == gdsName) {
            RecordLocatorType recordLocatorType = TextUtil.containsCyrillicLetter((String)recordLocator) ? RecordLocatorType.SIRENA_CYRILLIC : RecordLocatorType.SIRENA_LATIN;
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SIRENA, (RecordLocatorType)recordLocatorType, (String)recordLocator);
            return;
        }
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)gdsName, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)recordLocator);
    }

    public static interface ProductParserHandler<T extends BaseProduct> {
        public T createProduct();

        public int getThreshold();

        public void setSystemNumber(T var1, String var2);

        public void setIssueDate(T var1, Date var2);

        public void setStatus(T var1, ProductStatus var2);

        public void setTicketType(T var1, TicketType var2);

        public void setProductCategory(T var1, ProductCategory var2);

        public void setBlankOwner(T var1, EntityReference<Organization> var2);

        public void setSupplier(T var1, EntityReference<Organization> var2);

        public void setAgency(T var1, EntityReference<Organization> var2);

        public void setSubagency(T var1, EntityReference<Organization> var2);

        public void setPreviousProduct(T var1, T var2);

        public void setNextProduct(T var1, T var2);

        public void addRelatedProduct(T var1, BaseProduct var2);
    }
}

