/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettings;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.RulesMigrationExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.RulesMigrationExchangeDocumentIndex;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.Date;

public final class RulesMigrationExchangeDocumentHelper {
    public static boolean isUnprocessedExchangeDocumentExists(EntityReference<RulesMigrationSettings> settignsRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RulesMigrationExchangeDocumentIndex.Property.status.name(), (Object)ProcessingStatus.UNPROCESSED));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RulesMigrationExchangeDocumentIndex.Property.migrationSettings.name(), settignsRef));
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(RulesMigrationExchangeDocumentIndex.class, query).getTotalCount() > 0;
    }

    public static RulesMigrationExchangeDocument createUnprocessedExchangeDocument(EntityReference<RulesMigrationSettings> settignsRef) {
        RulesMigrationExchangeDocument doc = new RulesMigrationExchangeDocument();
        doc.setStatus(ProcessingStatus.UNPROCESSED);
        doc.setContent(new byte[0]);
        doc.setContentType(ContentType.TEXT);
        doc.setCreated(new Date());
        doc.setDescription(String.format("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 %s", settignsRef));
        doc.setLocation(settignsRef.getCaption());
        doc.setName(doc.getDescription());
        doc.setTitle(doc.getDescription());
        doc.setMigrationSettings(settignsRef);
        doc.setType(RulesMigrationExchangeDocument.class.getName());
        return doc;
    }

    public static void createAndSaveUnprocessedExchangeDocument(EntityReference<RulesMigrationSettings> settignsRef) {
        EntityStorage.get().save(EntityContainer.create((BaseEntity)RulesMigrationExchangeDocumentHelper.createUnprocessedExchangeDocument(settignsRef)), true);
    }

    private RulesMigrationExchangeDocumentHelper() {
    }
}

