/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.ukraine.model.rules.standard;

import com.gridnine.xtrip.common.ibecorp.ukraine.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.BasicAirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Arrays;
import java.util.List;

public enum Properties implements RuleProperty
{
    TRANSPORTATION_TYPE_RESTRICTION{
        private final String ukraine = "UA";
        private final String cis = "CIS";
        private final String euro = "EURO";

        public String getDisplayName() {
            return "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435";
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.TRANSPORTATION_UKRAINE.getId(), Conditions.TRANSPORTATION_CIS.getId(), Conditions.TRANSPORTATION_EUROPE.getId(), Conditions.TRANSPORTATION_INTERCONTINANTAL.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder stringBuilder, RuleCondition condition, Object value) {
            if (condition.hasRightSide()) {
                stringBuilder.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRANSPORTATION_TYPE_info1, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString((Object)value)}));
            } else {
                stringBuilder.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRANSPORTATION_TYPE_info2, (Object[])new Object[]{condition.getDisplayName()}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicAirTicketPropertiesProvider propertiesProvider = (BasicAirTicketPropertiesProvider)propertySet;
            if (Conditions.TRANSPORTATION_UKRAINE.equals(condition)) {
                return RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("UA"));
            }
            if (Conditions.TRANSPORTATION_CIS.equals(condition)) {
                return !RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("UA")) && RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("CIS"));
            }
            if (Conditions.TRANSPORTATION_EUROPE.equals(condition)) {
                return !RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("CIS")) && RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("CIS", "EURO"));
            }
            if (Conditions.TRANSPORTATION_INTERCONTINANTAL.equals(condition)) {
                return !RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("CIS", "EURO"));
            }
            return true;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();
}

