/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;

public class AgentReportHelper {
    public static final Comparator<PaymentType> paymentTypesComparator = new Comparator<PaymentType>(){

        @Override
        public int compare(PaymentType o1, PaymentType o2) {
            return this.getIndex(o1) - this.getIndex(o2);
        }

        private int getIndex(PaymentType paymentType) {
            if (paymentType == null) {
                return -1;
            }
            switch (paymentType) {
                case CASH: {
                    return 0;
                }
                case INVOICE: {
                    return 1;
                }
                case PTA: {
                    return 2;
                }
                case CREDIT_CARD: {
                    return 3;
                }
                case CREDIT: {
                    return 4;
                }
            }
            return 5;
        }
    };

    public static Collection<GeneralProductFop> filterFops(Collection<GeneralProductFop> fops, ProductStatus status, Date issueDate, EntityReference<Person> issueAgent, Date startDate, Date endDate, EntityReference<Person> agent, Set<FopPeriod> fopPeriods, Set<PaymentType> paymentTypes, Set<FopType> fopTypes, Set<FopStatus> fopStatuses, Set<FopCategory> fopCategories) {
        if (fops == null || issueDate == null || issueAgent == null || agent == null) {
            return Collections.emptyList();
        }
        FopPeriod fopPeriod = AgentReportHelper.getFopPeriod(issueDate, issueAgent, startDate, endDate, agent);
        if (fopPeriods != null && !fopPeriods.contains((Object)fopPeriod)) {
            return Collections.emptyList();
        }
        return GeneralProductHelper.filterFops(AgentReportHelper.filterFopsByFopStatuses(AgentReportHelper.filterFopsByFopCategories(fops, status, fopCategories), issueDate, issueAgent, startDate, endDate, agent, fopStatuses), fopTypes, paymentTypes, null);
    }

    private static Collection<GeneralProductFop> filterFopsByFopStatuses(Collection<GeneralProductFop> fops, Date issueDate, EntityReference<Person> issueAgent, Date startDate, Date endDate, EntityReference<Person> agent, Set<FopStatus> fopStatuses) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (fopStatuses == null) {
            return new ArrayList<GeneralProductFop>(fops);
        }
        ArrayList<GeneralProductFop> filteredFops = new ArrayList<GeneralProductFop>();
        for (GeneralProductFop fop : fops) {
            FopStatus fopStatus = AgentReportHelper.getFopStatus(fop, issueDate, issueAgent, startDate, endDate, agent);
            if (!fopStatuses.contains((Object)fopStatus)) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<GeneralProductFop> filterFopsByFopCategories(Collection<GeneralProductFop> fops, ProductStatus status, Set<FopCategory> fopCategories) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (fopCategories == null) {
            return new ArrayList<GeneralProductFop>(fops);
        }
        ArrayList<GeneralProductFop> filteredFops = new ArrayList<GeneralProductFop>();
        for (GeneralProductFop fop : fops) {
            FopCategory fopCategory = AgentReportHelper.getFopCategory(fop, status);
            if (!fopCategories.contains((Object)fopCategory)) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    public static FopPeriod getFopPeriod(Date issueDate, EntityReference<Person> issueAgent, Date startDate, Date endDate, EntityReference<Person> agent) {
        if (issueDate == null || issueAgent == null) {
            return null;
        }
        if (MiscUtil.isBefore((Date)startDate, (Date)endDate, (Date)issueDate) || agent != null && !issueAgent.equals(agent)) {
            return FopPeriod.BEFORE;
        }
        if (MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)issueDate)) {
            return FopPeriod.WITHIN;
        }
        if (MiscUtil.isAfter((Date)startDate, (Date)endDate, (Date)issueDate)) {
            return FopPeriod.AFTER;
        }
        return null;
    }

    public static FopStatus getFopStatus(GeneralProductFop fop, Date issueDate, EntityReference<Person> issueAgent, Date startDate, Date endDate, EntityReference<Person> agent) {
        if (fop == null || issueDate == null || issueAgent == null) {
            return null;
        }
        if (AgentReportHelper.isPaid(fop, issueDate, issueAgent, startDate, endDate, agent)) {
            return FopStatus.PAID;
        }
        if (AgentReportHelper.isRefused(fop, issueDate, issueAgent, startDate, endDate, agent)) {
            return FopStatus.REFUSED;
        }
        if (AgentReportHelper.isUnpaid(fop, issueDate, issueAgent, startDate, endDate, agent)) {
            return FopStatus.UNPAID;
        }
        return null;
    }

    public static FopCategory getFopCategory(GeneralProductFop fop, ProductStatus status) {
        if (fop == null) {
            return null;
        }
        if (fop.getEquivalentAmount() != null) {
            FopType fopType = GeneralProductHelper.getFopType((GeneralProductFop)fop);
            if (status == ProductStatus.REFUND) {
                if (fop.getEquivalentAmount().compareTo(BigDecimal.ZERO) >= 0 || fopType == FopType.DISCOUNT) {
                    return FopCategory.CREDIT;
                }
                return FopCategory.DEBIT;
            }
            if (fop.getEquivalentAmount().compareTo(BigDecimal.ZERO) >= 0 || fopType == FopType.DISCOUNT) {
                return FopCategory.DEBIT;
            }
            return FopCategory.CREDIT;
        }
        return null;
    }

    private static boolean isPaid(GeneralProductFop fop, Date issueDate, EntityReference<Person> issueAgent, Date startDate, Date endDate, EntityReference<Person> agent) {
        return !fop.isRefused() && fop.getOperationDate() != null && MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)fop.getOperationDate()) && fop.getAgent() != null && (agent == null || fop.getAgent().equals(agent));
    }

    private static boolean isRefused(GeneralProductFop fop, Date issueDate, EntityReference<Person> issueAgent, Date startDate, Date endDate, EntityReference<Person> agent) {
        return fop.isRefused() && fop.getOperationDate() != null && MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)fop.getOperationDate()) && fop.getAgent() != null && (agent == null || fop.getAgent().equals(agent));
    }

    private static boolean isUnpaid(GeneralProductFop fop, Date issueDate, EntityReference<Person> issueAgent, Date startDate, Date endDate, EntityReference<Person> agent) {
        return issueDate != null && MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)issueDate) && (fop.getOperationDate() == null || fop.getAgent() == null || agent != null && !fop.getAgent().equals(agent) || !MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)fop.getOperationDate()) && agent != null && fop.getAgent().equals(agent));
    }

    public static enum FopCategory {
        DEBIT,
        CREDIT;

    }

    public static enum FopStatus {
        PAID,
        REFUSED,
        UNPAID;

    }

    public static enum FopPeriod {
        BEFORE,
        WITHIN,
        AFTER;

    }
}

