/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport.samara;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SamaraAgentReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SellWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SamaraAgentReportRenderHandler
extends BasePoiReportRenderHandler<SamaraAgentReportTicket> {
    public static final String SELL_BATCH_ID = "SELL";

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(AgentReportDocument.class);
        ((AgentReportDocument)result.getEntity()).getFiles().add(file);
        List messages = (List)data.get("key-messages");
        ((AgentReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((AgentReportDocument)result.getEntity()).setReportType(ReportType.AGENT);
        AgentReportParameters reportParameters = (AgentReportParameters)data.get("key-report-params");
        reportParameters.getVendors().clear();
        reportParameters.getVendors().addAll((Set)data.get("ACTUAL_VENDORS"));
        ((AgentReportDocument)result.getEntity()).setParameters(reportParameters);
        return result;
    }

    @Override
    protected List<PoiWorksheetData<SamaraAgentReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<SamaraAgentReportTicket>> result = new ArrayList<PoiWorksheetData<SamaraAgentReportTicket>>();
        result.add(new BaseWorksheetData<SamaraAgentReportTicket>(){

            @Override
            public String getBatchId() {
                return SamaraAgentReportRenderHandler.SELL_BATCH_ID;
            }

            @Override
            public PoiWorksheetDefinition<SamaraAgentReportTicket> getDefinition() {
                return Definitions.SELL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        byte[] template = (byte[])data.get("REPORT_TEMPLATE");
        if (template == null) {
            File result = IoUtil.url2file((URL)BasePoiReportRenderHandler.class.getResource("/agentreports/SamaraAgentReportTmpl.xls"));
            if (!result.exists() || !result.canRead()) {
                throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportRenderHandler_unableToLoadTemplate, (Object[])new Object[]{result.getCanonicalPath()}).toString());
            }
            return IoUtil.getResourceInputStream((File)result);
        }
        return new ByteArrayInputStream(template);
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportRenderHandler_reportTitle, (Object[])new Object[]{data.get("AGENT_NAME"), data.get("AGENCY_NAME"), data.get("REPORT_PERIOD")}).toString();
    }

    @Override
    public String getId() {
        return "agent-report-samara";
    }

    public static enum Definitions implements PoiWorksheetDefinition<SamaraAgentReportTicket>
    {
        SELL{

            @Override
            public PoiWorksheetHandler<SamaraAgentReportTicket> getHandler() {
                return new SellWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportRenderHandler_sheetName, (Object[])new Object[0]).toString();
            }
        };

    }
}

