/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport.samara;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SamaraReportHelper;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamaraAgentReportTicket
extends BaseReportTicket {
    private static final long serialVersionUID = -8948086193218382189L;
    static final List<PaymentType> paymentTypes = new ArrayList<PaymentType>();
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private String sortingTicketNumber;
    private boolean conjunction;
    protected boolean hasCreditCardFop;
    private boolean issuedBefore;
    private boolean exchangePenaltyMCO = false;
    private boolean refundPenaltyMCO = false;
    private boolean refundReceiptMCO = false;
    private boolean exchangeReceiptMCO = false;
    protected String contractor;
    protected String lines;
    protected String clientProfile;
    protected String passangerLastName;
    protected String routeLine;
    protected int armCount;
    protected String carrierNumber;
    protected BigDecimal ruTaxAmount;
    protected BigDecimal otherTaxesAmount;
    protected BigDecimal tchTaxAmount;
    protected BigDecimal clientEquivalentFee;
    protected BigDecimal refundFee;
    private BigDecimal penaltyAmount;
    protected BigDecimal clientEquivalentDiscount;
    private Double vendorCommissionRate;
    protected BigDecimal vendorEquivalentCommission;
    protected BigDecimal creditCardAmount;
    private BigDecimal ticketSumPaymentAmount;
    private BigDecimal feeSumPaymentAmount;
    private BigDecimal cashAmount;
    protected BigDecimal reclamation;
    protected BigDecimal invoiceAmount;
    protected String invoiceNumber;
    protected Date flightDate;
    protected String scn;
    private BigDecimal ticketSumDebtAmount = null;
    private BigDecimal feeSumDebtAmount = null;
    private final HashMap<PaymentType, BigDecimal> totals = new HashMap();
    private PaymentType creditCardType = null;

    public SamaraAgentReportTicket(Product ticket, int conj, AgentReportParameters params, List<Message> messages) {
        super(ticket, messages);
        if (this.status == null) {
            SystemHelper.addMessage(messages, (String)Messages.SamaraAgentreportTicket_statusNotSet, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
            return;
        }
        if (ticket.getBlankOwnerRef() == null) {
            SystemHelper.addMessage(messages, (String)Messages.SamaraAgentreportTicket_blankOwnerNotSet, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
            return;
        }
        this.hasCreditCardFop = this.hasCreditCardFop(ticket);
        if (this.hasCreditCardFop) {
            this.setCreditCardType(ticket);
            this.resetFinanceFields(true);
        } else {
            this.resetFinanceFields(false);
        }
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        this.carrierNumber = ticket.getCarrierNumber();
        this.sortingTicketNumber = this.carrierNumber + this.ticketNumber;
        if (conj > 0) {
            this.initConjunction(ticket, conj, messages);
        } else if (!ticket.getScns().isEmpty()) {
            this.scn = (String)ticket.getScns().get(0);
        }
        if (this.ticketNumber != null && this.ticketNumber.equals(this.scn)) {
            this.scn = null;
        }
        if (startDate != null && (ticket.getIssueDate() == null || ticket.getIssueDate().before(startDate))) {
            this.issuedBefore = true;
        }
        if (this.status == ProductStatus.VOID) {
            this.routeLine = L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportTicket_reportName, (Object[])new Object[0]).toString();
            return;
        }
        List<ProductFop> allFops = SamaraAgentReportTicket.collectFops(ticket, true, messages);
        if (allFops == null) {
            return;
        }
        if (allFops.isEmpty() && !MCOCategory.INFORMATION.equals((Object)ticket.getMcoCategory())) {
            SystemHelper.addMessage(messages, (String)Messages.SamaraAgentReportTicket_noFopInfo, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
            return;
        }
        if (!this.hasCreditCardFop) {
            this.calculateCommissions(ticket, messages);
        }
        for (PaymentType ptype : paymentTypes) {
            this.totals.put(ptype, this.getTotalFop(allFops, ptype));
        }
        this.ticketSumDebtAmount = this.calculateDebtAmount(allFops, messages, params.getPeriodEnd(), SamaraReportHelper.PayoffType.TICKET);
        this.feeSumDebtAmount = this.calculateDebtAmount(allFops, messages, params.getPeriodEnd(), SamaraReportHelper.PayoffType.FEE);
        this.ticketSumPaymentAmount = this.calculatePaymentAmount(allFops, startDate, endDate, messages, SamaraReportHelper.PayoffType.TICKET);
        this.feeSumPaymentAmount = this.calculatePaymentAmount(allFops, startDate, endDate, messages, SamaraReportHelper.PayoffType.FEE);
        switch (this.productCategory) {
            case MCO: {
                this.initMCO(ticket, this.status, messages);
                return;
            }
        }
        this.initAirticket(params, ticket, this.status, messages);
    }

    private int calcArmCount(String routeLine) {
        if (TextUtil.isBlank((String)routeLine)) {
            return 0;
        }
        return this.charEntryFrequency(routeLine, '-');
    }

    private int charEntryFrequency(String text, char ch) {
        int frequency = 0;
        for (char c : text.toCharArray()) {
            if (c != ch) continue;
            ++frequency;
        }
        return frequency;
    }

    public String getContractor() {
        return this.contractor;
    }

    public String getLines() {
        return this.lines;
    }

    public String getClientProfile() {
        return this.clientProfile;
    }

    public int getArmCount() {
        return this.armCount;
    }

    public String getCarrierNumber() {
        return this.carrierNumber;
    }

    public String getPassangerLastName() {
        return this.passangerLastName;
    }

    public Date getFlightDate() {
        return this.flightDate;
    }

    public String getScn() {
        return this.scn;
    }

    public void setContractor(String contractor) {
        this.contractor = contractor;
    }

    public void setLines(String lines) {
        this.lines = lines;
    }

    public void setClientProfile(String clientProfile) {
        this.clientProfile = clientProfile;
    }

    public void setPassangerLastName(String passangerLastName) {
        this.passangerLastName = passangerLastName;
    }

    public void setFlightDate(Date flightDate) {
        this.flightDate = flightDate;
    }

    public void setScn(String scn) {
        this.scn = scn;
    }

    private void resetFinanceFields(boolean resetEquivalentFare) {
        for (PaymentType pType : paymentTypes) {
            this.totals.remove(pType);
        }
        this.ruTaxAmount = BigDecimal.ZERO;
        this.otherTaxesAmount = BigDecimal.ZERO;
        this.tchTaxAmount = BigDecimal.ZERO;
        this.penaltyAmount = BigDecimal.ZERO;
        this.ticketSumPaymentAmount = BigDecimal.ZERO;
        this.feeSumPaymentAmount = BigDecimal.ZERO;
        this.vendorCommissionRate = null;
        this.vendorEquivalentCommission = BigDecimal.ZERO;
        if (resetEquivalentFare) {
            this.equivalentFare = BigDecimal.ZERO;
        }
    }

    public String getRouteLine() {
        return this.routeLine;
    }

    public BigDecimal getRuTaxAmount() {
        return this.ruTaxAmount;
    }

    public BigDecimal getOtherTaxesAmount() {
        return this.otherTaxesAmount;
    }

    public String getSortingTicketNumber() {
        return this.sortingTicketNumber;
    }

    public boolean isRefundPenaltyMCO() {
        return this.refundPenaltyMCO;
    }

    public boolean isExchangePenaltyMCO() {
        return this.exchangePenaltyMCO;
    }

    public boolean isRefundReceiptMCO() {
        return this.refundReceiptMCO;
    }

    public boolean isExchangeReceiptMCO() {
        return this.exchangeReceiptMCO;
    }

    public BigDecimal getTicketSumPaymentAmount() {
        return this.ticketSumPaymentAmount;
    }

    public BigDecimal getFeeSumPaymentAmount() {
        return this.feeSumPaymentAmount;
    }

    public BigDecimal getTicketSumDebtAmount() {
        return this.ticketSumDebtAmount;
    }

    public BigDecimal getFeeSumDebtAmount() {
        return this.feeSumDebtAmount;
    }

    public boolean isConjunction() {
        return this.conjunction;
    }

    private boolean hasRelatedPenaltyMCO(Product product) {
        for (Product prod : AirProductHelper.getMcoByRelatedProduct((Product)product)) {
            if (prod.getMcoCategory() != MCOCategory.PENALTY && prod.getMcoCategory() != MCOCategory.REBOOKING) continue;
            return true;
        }
        return false;
    }

    private BigDecimal getTotalFop(List<ProductFop> fops, PaymentType type) {
        BigDecimal result = BigDecimal.ZERO;
        for (ProductFop fop : fops) {
            if (type != null && type != fop.getType() || (fop.getType() == PaymentType.CREDIT_CARD || fop.getType() == PaymentType.CREDIT_CARD_AGENCY) && AirProductHelper.isServiceFop((ProductFop)fop) || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
            result = result.add(fop.getAmount().getValue());
        }
        return result;
    }

    private BigDecimal calculateDebtAmount(List<ProductFop> fops, List<Message> messages, Date endPeriodDate, SamaraReportHelper.PayoffType payoffType) {
        BigDecimal result = BigDecimal.ZERO;
        if (fops == null || fops.isEmpty()) {
            return result;
        }
        for (ProductFop fop : fops) {
            if (payoffType == SamaraReportHelper.PayoffType.FEE && AirProductHelper.isServiceFop((ProductFop)fop) || payoffType == SamaraReportHelper.PayoffType.TICKET && !AirProductHelper.isServiceFop((ProductFop)fop) || fop.getOperationDate() != null && !fop.getOperationDate().after(endPeriodDate) || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
            result = result.add(fop.getAmount().getValue());
        }
        return result;
    }

    private BigDecimal calculatePaymentAmount(List<ProductFop> fops, Date startDate, Date endDate, List<Message> messages, SamaraReportHelper.PayoffType payoffType) {
        BigDecimal result = BigDecimal.ZERO;
        if (fops == null || fops.isEmpty() || startDate == null || endDate == null) {
            return result;
        }
        for (ProductFop fop : fops) {
            if (fop.getType() != PaymentType.CASH && fop.getType() != PaymentType.CREDIT_CARD && fop.getType() != PaymentType.CREDIT_CARD_AGENCY || payoffType == SamaraReportHelper.PayoffType.FEE && AirProductHelper.isServiceFop((ProductFop)fop) || payoffType == SamaraReportHelper.PayoffType.TICKET && !AirProductHelper.isServiceFop((ProductFop)fop) || fop.getOperationDate() == null || !fop.getOperationDate().equals(startDate) && !fop.getOperationDate().after(startDate) || !fop.getOperationDate().before(endDate) && !fop.getOperationDate().equals(endDate) || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
            result = result.add(fop.getAmount().getValue());
        }
        return result;
    }

    public Map<PaymentType, BigDecimal> getTotals() {
        return this.totals;
    }

    public boolean isIssuedBefore() {
        return this.issuedBefore;
    }

    public BigDecimal getPenaltyAmount() {
        return this.penaltyAmount;
    }

    public BigDecimal getVendorEquivalentCommission() {
        return this.vendorEquivalentCommission;
    }

    public Double getVendorCommissionRate() {
        return this.vendorCommissionRate;
    }

    public BigDecimal getRefundFee() {
        return this.refundFee;
    }

    public BigDecimal getReclamation() {
        return this.reclamation;
    }

    public BigDecimal getClientEquivalentFee() {
        return this.clientEquivalentFee;
    }

    public BigDecimal getClientEquivalentDiscount() {
        return this.clientEquivalentDiscount;
    }

    private Double updateCommissionRate(Double currentRate, Double commissionRate) {
        if (commissionRate == null || Math.abs(commissionRate) < 0.001) {
            return currentRate;
        }
        if (currentRate == null) {
            return commissionRate;
        }
        return Math.abs(currentRate) > Math.abs(commissionRate) ? currentRate : commissionRate;
    }

    private BigDecimal updateCommissionValue(BigDecimal currentValue, BigDecimal commissionValue) {
        if (commissionValue == null || BigDecimal.ZERO.compareTo(commissionValue) == 0) {
            return currentValue;
        }
        if (currentValue == null) {
            return commissionValue;
        }
        return currentValue.add(commissionValue);
    }

    private final boolean hasCreditCardFop(Product product) {
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)product).getFops()) {
            if (PaymentType.CREDIT_CARD != fop.getType() && fop.getType() != PaymentType.CREDIT_CARD_AGENCY) continue;
            return true;
        }
        return false;
    }

    private final void setCreditCardType(Product product) {
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)product).getFops()) {
            if (PaymentType.CREDIT_CARD == fop.getType()) {
                this.creditCardType = PaymentType.CREDIT_CARD;
                continue;
            }
            if (fop.getType() != PaymentType.CREDIT_CARD_AGENCY) continue;
            this.creditCardType = PaymentType.CREDIT_CARD_AGENCY;
        }
    }

    private void calculateCommissions(Product ticket, List<Message> messages) {
        block13: for (Commission commission : AirProductHelper.getUnmodifiableCommissions((Product)ticket, null)) {
            boolean discount;
            EntityReference propRef;
            if (commission.getContractType() == null) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                EntityContainer ctr;
                EntityReference comPropRef = commission.getCommissionProperties();
                try {
                    ctr = EntityStorage.get().resolve(comPropRef);
                }
                catch (Exception e) {
                    SystemHelper.addExceptionMessage(messages, (String)Messages.SamaraAgentReportTicket_failedToLoadCommission, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber(), comPropRef});
                    continue;
                }
                if (ctr != null && ((CommissionProperties)ctr.getEntity()).isBspCommission()) continue;
            }
            boolean fee = (propRef = commission.getCommissionProperties()) != null && (FeeProperties.class.equals((Object)propRef.getType()) || PaymentFeeProperties.class.equals((Object)propRef.getType()));
            boolean bl = discount = propRef != null && DiscountProperties.class.getName().equals(propRef.getType().getName());
            if (fee) {
                switch (commission.getContractType()) {
                    case CLIENT: {
                        FeeProperties feeProp;
                        EntityContainer ctr;
                        if (commission.getEquivalentAmount() == null) continue block13;
                        try {
                            ctr = EntityStorage.get().resolve(propRef);
                        }
                        catch (Exception e) {
                            SystemHelper.addExceptionMessage(messages, (String)Messages.SamaraAgentReportTicket_failedToLoadCommission, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber(), propRef});
                            continue block13;
                        }
                        if (ctr == null) continue block13;
                        BaseCommissionProperties ett = (BaseCommissionProperties)ctr.getEntity();
                        if (ett instanceof FeeProperties) {
                            feeProp = (FeeProperties)ett;
                            if (feeProp.getOperation() == Operation.REFUND) {
                                this.refundFee = this.updateCommissionValue(this.refundFee, commission.getEquivalentAmount().abs());
                                continue block13;
                            }
                            this.clientEquivalentFee = this.updateCommissionValue(this.clientEquivalentFee, commission.getEquivalentAmount().abs());
                        }
                        if (!(ett instanceof PaymentFeeProperties)) continue block13;
                        feeProp = (PaymentFeeProperties)ett;
                        if (ticket.getStatus() == ProductStatus.REFUND && feeProp.isChargeOnRefund() && commission.getEquivalentAmount().doubleValue() < 0.0) {
                            this.refundFee = this.updateCommissionValue(this.refundFee, commission.getEquivalentAmount().abs());
                            continue block13;
                        }
                        this.clientEquivalentFee = this.updateCommissionValue(this.clientEquivalentFee, commission.getEquivalentAmount().abs());
                        continue block13;
                    }
                }
                continue;
            }
            if (discount) {
                switch (commission.getContractType()) {
                    case CLIENT: {
                        this.clientEquivalentDiscount = this.updateCommissionValue(this.clientEquivalentDiscount, commission.getEquivalentAmount());
                        this.clientEquivalentDiscount = this.clientEquivalentDiscount.negate();
                        continue block13;
                    }
                }
                continue;
            }
            switch (commission.getContractType()) {
                case VENDOR: {
                    this.vendorEquivalentCommission = this.updateCommissionValue(this.vendorEquivalentCommission, commission.getEquivalentAmount());
                    this.vendorCommissionRate = this.updateCommissionRate(this.vendorCommissionRate, commission.getRate());
                    break;
                }
            }
        }
        if (AirProductHelper.isBSPTicket((Product)ticket) && MiscUtil.equals((Object)ticket.getBlankOwnerRef(), (Object)AirProductHelper.getSupplier((Product)ticket))) {
            this.vendorEquivalentCommission = this.updateCommissionValue(this.vendorEquivalentCommission, ticket.getBspCommissionValue() != null ? ticket.getBspCommissionValue().getValue() : null);
            this.vendorCommissionRate = this.updateCommissionRate(this.vendorCommissionRate, ticket.getBspCommissionRate());
        }
    }

    private void initMCO(Product ticket, ProductStatus s, List<Message> messages) {
        Product prod = AirProductHelper.findRelatedAirProduct((Product)ticket, null, (boolean)false);
        if (prod == null && ticket.getMcoCategory() != MCOCategory.GROUP_PREPAYMENT && ticket.getMcoCategory() != MCOCategory.PTA) {
            SystemHelper.addMessage(messages, (String)Messages.SamaraAgentReportTicket_noConnectedTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
        }
        switch (s) {
            case SELL: {
                switch (this.mcoCategory) {
                    case PENALTY: 
                    case REBOOKING: {
                        this.penaltyAmount = this.mcoCategory == MCOCategory.PENALTY || this.mcoCategory == MCOCategory.REBOOKING ? AirProductHelper.getEquivalentFare((Product)ticket) : ticket.getPenalty();
                        this.equivalentFare = null;
                        this.refundPenaltyMCO = prod != null && prod.getStatus() == ProductStatus.REFUND;
                        boolean bl = this.exchangePenaltyMCO = prod != null && prod.getStatus() == ProductStatus.EXCHANGE;
                        if (this.hasCreditCardFop) break;
                        this.setupTaxes(ticket);
                        break;
                    }
                    case INFORMATION: {
                        this.resetFinanceFields(true);
                        this.refundReceiptMCO = prod != null && prod.getStatus() == ProductStatus.REFUND;
                        this.exchangeReceiptMCO = prod != null && prod.getStatus() == ProductStatus.EXCHANGE;
                        break;
                    }
                }
                if (prod == null) {
                    return;
                }
                this.setupRouteInformation(prod);
                Product sortProd = prod;
                if (prod.getStatus() == ProductStatus.EXCHANGE && prod.getNextProduct() != null) {
                    sortProd = prod.getNextProduct();
                }
                this.sortingTicketNumber = sortProd.getCarrierNumber() + sortProd.getSystemNumber();
                break;
            }
            case REFUND: {
                break;
            }
        }
    }

    private void initAirticket(AgentReportParameters params, Product ticket, ProductStatus s, List<Message> messages) {
        if (!this.hasCreditCardFop) {
            this.setupTaxes(ticket);
        }
        switch (this.status) {
            case SELL: {
                boolean hasExchange;
                this.setupFlightDate(ticket);
                boolean bl = hasExchange = ticket.getPreviousProduct() != null && ticket.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
                if (hasExchange && !this.hasRelatedPenaltyMCO(ticket.getPreviousProduct())) {
                    BigDecimal bigDecimal = this.penaltyAmount = ticket.getPenalty() != null && Math.abs(ticket.getPenalty().doubleValue()) > 0.0 ? ticket.getPenalty() : null;
                }
                if (hasExchange) {
                    Product exchProd = ticket.getPreviousProduct();
                    ProductStatus exchSatus = exchProd.getStatus();
                    exchProd.setStatus(ProductStatus.SELL);
                    SamaraAgentReportTicket exchange = new SamaraAgentReportTicket(exchProd, 0, params, messages);
                    exchProd.setStatus(exchSatus);
                    if (!TextUtil.isBlank((String)ticket.getSystemNumber())) {
                        this.ticketNumber = ticket.getSystemNumber() + L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportRenderHandler_o, (Object[])new Object[0]).toString();
                    }
                    this.equivalentFare = this.equivalentFare.subtract(exchange.getEquivalentFare() != null ? exchange.getEquivalentFare() : BigDecimal.ZERO);
                    this.otherTaxesAmount = this.otherTaxesAmount.subtract(exchange.getOtherTaxesAmount() != null ? exchange.getOtherTaxesAmount() : BigDecimal.ZERO);
                    BigDecimal bigDecimal = this.ruTaxAmount != null ? this.ruTaxAmount.subtract(exchange.getRuTaxAmount() != null ? exchange.getRuTaxAmount() : BigDecimal.ZERO) : (this.ruTaxAmount = null);
                    BigDecimal bigDecimal2 = this.tchTaxAmount != null ? this.tchTaxAmount.subtract(exchange.getTchTaxAmount() != null ? exchange.getTchTaxAmount() : BigDecimal.ZERO) : (this.tchTaxAmount = null);
                    if (this.ticketSumPaymentAmount != null) {
                        this.ticketSumPaymentAmount = this.ticketSumPaymentAmount.subtract(exchange.getTicketSumPaymentAmount() != null ? exchange.getTicketSumPaymentAmount() : BigDecimal.ZERO);
                    }
                    if (this.feeSumPaymentAmount != null) {
                        this.feeSumPaymentAmount = this.feeSumPaymentAmount.subtract(exchange.getFeeSumPaymentAmount() != null ? exchange.getFeeSumPaymentAmount() : BigDecimal.ZERO);
                    }
                    if (this.vendorEquivalentCommission != null) {
                        this.vendorEquivalentCommission = this.vendorEquivalentCommission.subtract(exchange.getVendorEquivalentCommission() != null ? exchange.getVendorEquivalentCommission() : BigDecimal.ZERO);
                    }
                    for (PaymentType ptype : paymentTypes) {
                        BigDecimal t;
                        BigDecimal total = this.totals.get(ptype);
                        if (total == null || (t = exchange.getTotals().get(ptype)) == null) continue;
                        this.totals.put(ptype, total.subtract(t));
                    }
                }
                if (this.creditCardType == PaymentType.CREDIT_CARD) {
                    this.creditCardAmount = this.totals.get(PaymentType.CREDIT_CARD);
                } else if (this.creditCardType == PaymentType.CREDIT_CARD_AGENCY) {
                    this.creditCardAmount = this.totals.get(PaymentType.CREDIT_CARD_AGENCY);
                }
                this.cashAmount = this.totals.get(PaymentType.CASH);
                this.invoiceAmount = this.totals.get(PaymentType.INVOICE);
                if (this.clientEquivalentDiscount != null && !BigDecimal.ZERO.equals(this.clientEquivalentDiscount)) {
                    if (this.cashAmount != null && this.cashAmount != BigDecimal.ZERO) {
                        this.cashAmount = this.cashAmount.add(this.clientEquivalentDiscount);
                    }
                    if (this.invoiceAmount != null && this.invoiceAmount != BigDecimal.ZERO) {
                        this.invoiceAmount = this.invoiceAmount.add(this.clientEquivalentDiscount);
                    }
                }
                this.setInvoiceNumber(ticket);
                break;
            }
            case REFUND: {
                if (!this.hasRelatedPenaltyMCO(ticket)) {
                    BigDecimal bigDecimal = this.penaltyAmount = ticket.getPenalty() != null && Math.abs(ticket.getPenalty().doubleValue()) > 0.0 ? ticket.getPenalty() : null;
                }
                if (!TextUtil.isBlank((String)ticket.getSystemNumber())) {
                    this.ticketNumber = ticket.getSystemNumber() + L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportRenderHandler_v, (Object[])new Object[0]).toString();
                }
                BigDecimal sum = BigDecimal.ZERO;
                for (PaymentType ptype : paymentTypes) {
                    BigDecimal value = this.totals.get(ptype);
                    if (value == null) continue;
                    if (ptype == PaymentType.CASH) {
                        sum = sum.add(value);
                        this.totals.remove(PaymentType.CASH);
                        continue;
                    }
                    this.totals.put(ptype, value.negate());
                }
                if (sum.compareTo(BigDecimal.ZERO) != 0) {
                    this.reclamation = sum.negate();
                }
                this.otherTaxesAmount = this.otherTaxesAmount != null ? this.otherTaxesAmount.negate() : null;
                this.ruTaxAmount = this.ruTaxAmount != null ? this.ruTaxAmount.negate() : null;
                this.equivalentFare = this.equivalentFare != null ? this.equivalentFare.negate() : null;
                this.vendorEquivalentCommission = this.vendorEquivalentCommission != null ? this.vendorEquivalentCommission.negate() : null;
                this.ticketSumPaymentAmount = this.ticketSumPaymentAmount != null ? this.ticketSumPaymentAmount.negate() : null;
                this.feeSumPaymentAmount = this.feeSumPaymentAmount != null ? this.feeSumPaymentAmount.negate() : null;
                this.ticketSumDebtAmount = this.ticketSumDebtAmount != null ? this.ticketSumDebtAmount.negate() : null;
                this.feeSumDebtAmount = this.feeSumDebtAmount != null ? this.feeSumDebtAmount.negate() : null;
                BigDecimal bigDecimal = this.clientEquivalentFee = this.clientEquivalentFee != null ? this.clientEquivalentFee.negate() : null;
                if (this.creditCardType == PaymentType.CREDIT_CARD) {
                    this.creditCardAmount = this.totals.get(PaymentType.CREDIT_CARD);
                } else if (this.creditCardType == PaymentType.CREDIT_CARD_AGENCY) {
                    this.creditCardAmount = this.totals.get(PaymentType.CREDIT_CARD_AGENCY);
                }
                this.invoiceAmount = this.totals.get(PaymentType.INVOICE);
                this.setInvoiceNumber(ticket);
                break;
            }
            case EXCHANGE: {
                this.resetFinanceFields(true);
                break;
            }
        }
        this.setupRouteInformation(ticket);
    }

    private void initConjunction(Product ticket, int conj, List<Message> messages) {
        this.conjunction = true;
        if (!TextUtil.isBlank((String)this.ticketNumber)) {
            try {
                this.ticketNumber = FormattedNumberUtil.add((String)ticket.getSystemNumber(), (long)conj);
                this.sortingTicketNumber = this.carrierNumber + this.ticketNumber;
            }
            catch (Exception e) {
                SystemHelper.addExceptionMessage(messages, (String)Messages.SamaraAgentreportTicket_failedToGenerateSystemNumberConjunction, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
                this.log.error(String.format("unable to generate conjunction \"%s\" for ticket with number \"%s\"", Integer.toString(conj), this.ticketNumber), (Throwable)e);
            }
        }
        if (!ticket.getScns().isEmpty()) {
            String scnNumber = (String)ticket.getScns().get(0);
            try {
                this.scn = FormattedNumberUtil.add((String)scnNumber, (long)conj);
            }
            catch (Exception e) {
                SystemHelper.addExceptionMessage(messages, (String)Messages.SamaraAgentReportTicket_failedToGenerateScnNumberConhunction, (Exception)e, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
                this.log.error(String.format("unable to generate conjunction \"%s\" for ticket with number \"%s\"", Integer.toString(conj), this.ticketNumber), (Throwable)e);
            }
        }
    }

    private void setupRouteInformation(Product ticket) {
        TransportationType type = AirProductHelper.calculateTransportationType((Product)ticket);
        CodeSystem codeSystem = CodeSystem.IATA;
        switch (type) {
            case DOMESTIC: {
                this.lines = L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportTicket_v, (Object[])new Object[0]).toString();
                codeSystem = CodeSystem.CRT;
                break;
            }
            case INTERNATIONAL: {
                this.lines = L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportTicket_m, (Object[])new Object[0]).toString();
                break;
            }
            case COMBINED: {
                this.lines = L10nResourcesManager.createL10nMessage((String)Messages.SamaraAgentReportTicket_vm, (Object[])new Object[0]).toString();
                break;
            }
            default: {
                this.lines = "?";
            }
        }
        this.routeLine = AirProductHelper.getRouteLine((Product)ticket, null, (boolean)true, (CodeSystem)codeSystem).toLowerCase();
        this.armCount = this.calcArmCount(this.routeLine);
    }

    private final void setupFlightDate(Product ticket) {
        block0: {
            SegmentTariff st;
            Iterator iterator;
            Iterator iterator2 = ticket.getSegmentTariffs().iterator();
            if (!iterator2.hasNext() || !(iterator = (st = (SegmentTariff)iterator2.next()).getSegments().iterator()).hasNext()) break block0;
            Segment segment = (Segment)iterator.next();
            this.flightDate = segment.getStartDate();
        }
    }

    private void setupTaxes(Product ticket) {
        this.ruTaxAmount = AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)ticket);
        this.otherTaxesAmount = AirProductTaxHelper.getEquivalentTaxesAmount((Product)ticket).subtract(this.ruTaxAmount);
        String code = ProfileHelper.findOrganizationCode((EntityReference)ticket.getBlankOwnerRef());
        if ("\u04281".equals(code)) {
            this.tchTaxAmount = this.ruTaxAmount;
            this.ruTaxAmount = null;
        }
    }

    public BigDecimal getTchTaxAmount() {
        return this.tchTaxAmount;
    }

    public BigDecimal getCreditCardAmount() {
        return this.creditCardAmount;
    }

    public BigDecimal getCashAmount() {
        return this.cashAmount;
    }

    public BigDecimal getInvoiceAmount() {
        return this.invoiceAmount;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public boolean hasCreditCardFop() {
        return this.hasCreditCardFop;
    }

    public PaymentType getCreditCardType() {
        return this.creditCardType;
    }

    private void setInvoiceNumber(Product ticket) {
        boolean result = false;
        if (ticket.getReservation().getBookingFile().getPayments().isEmpty()) {
            return;
        }
        for (Payment payment : ticket.getReservation().getBookingFile().getPayments()) {
            for (BillingItem billingItem : payment.getBillingItems()) {
                if (!billingItem.getProductUids().contains(ticket.getUid())) continue;
                for (FinanceDocument financeDocument : payment.getFinanceDocuments()) {
                    if (financeDocument.getType() != FinanceDocumentType.INVOICE) continue;
                    this.invoiceNumber = financeDocument.getNumber();
                    result = true;
                    break;
                }
                if (!result) continue;
                break;
            }
            if (!result) continue;
            break;
        }
    }

    static {
        paymentTypes.add(PaymentType.CASH);
        paymentTypes.add(PaymentType.INVOICE);
        paymentTypes.add(PaymentType.PTA);
        paymentTypes.add(PaymentType.CREDIT_CARD);
        paymentTypes.add(PaymentType.CREDIT_CARD_AGENCY);
    }
}

