/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.agentreport.samara;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SamaraAgentReportTicket;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SamaraClientData;
import com.gridnine.xtrip.common.reports.render.agentreport.samara.SamaraReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SellWorksheetHandler
extends BasePoiWorksheetHandler<SamaraAgentReportTicket> {
    private final int REGISTER_STARTING_ROW = 7;
    private final int START_COLUMN = 9;
    private final int END_COLUMN = 28;
    private final int ROWS_TO_SHIFT = 23;
    private final int MAX_COLUMNS = 28;
    private final int DEBT_START_COLUMN = 10;
    private final int PAYED_START_COLUMN = 20;
    private final int DEBT_TABLE_INIT_ROWS_COUNT = 14;
    private final int PAYED_TABLE_INIT_ROWS_COUNT = 14;
    private int currentRow;
    private int registerTotalsLine;
    private int debtsTotalsLine;
    private int paymentsTotalsLine;
    private int debtsStartLine;
    private int paymentsStartLine;
    private final Comparator<SamaraClientData> listComparator = new Comparator<SamaraClientData>(){

        @Override
        public int compare(SamaraClientData o1, SamaraClientData o2) {
            if (TextUtil.isBlank((String)o1.getTitle()) && TextUtil.isBlank((String)o2.getTitle())) {
                return 0;
            }
            if (TextUtil.isBlank((String)o1.getTitle())) {
                return 1;
            }
            if (TextUtil.isBlank((String)o2.getTitle())) {
                return -1;
            }
            int res = o1.getTitle().compareTo(o2.getTitle());
            if (res != 0) {
                return res;
            }
            res = SellWorksheetHandler.compare(o1.getDate(), o2.getDate());
            if (res == 0) {
                if (o1.getType() != null && o2.getType() != null) {
                    res = SellWorksheetHandler.compare(Integer.valueOf(o1.getType().ordinal()), Integer.valueOf(o2.getType().ordinal()));
                }
            } else {
                return res;
            }
            if (res == 0) {
                return SellWorksheetHandler.compare(Integer.valueOf(SellWorksheetHandler.this.getSign(o1.getSum())), Integer.valueOf(SellWorksheetHandler.this.getSign(o2.getSum())));
            }
            return res;
        }
    };
    Comparator<SamaraAgentReportTicket> ticketComparator = new Comparator<SamaraAgentReportTicket>(){

        @Override
        public int compare(SamaraAgentReportTicket o1, SamaraAgentReportTicket o2) {
            int res = TextUtil.compare((String)o1.getSortingTicketNumber(), (String)o2.getSortingTicketNumber(), (boolean)false, (boolean)true);
            if (res != 0) {
                return res;
            }
            if (o1.isRefundPenaltyMCO() != o2.isRefundPenaltyMCO()) {
                return o1.isRefundPenaltyMCO() ? 1 : 0;
            }
            if (o1.isExchangePenaltyMCO() != o2.isExchangePenaltyMCO()) {
                return o1.isRefundPenaltyMCO() ? 1 : 0;
            }
            if (o1.isRefundReceiptMCO() != o2.isRefundReceiptMCO()) {
                return o1.isRefundReceiptMCO() ? 1 : 0;
            }
            if (o1.isExchangeReceiptMCO() != o2.isExchangeReceiptMCO()) {
                return o1.isExchangeReceiptMCO() ? 1 : 0;
            }
            res = TextUtil.compare((String)o1.getTicketNumber(), (String)o2.getTicketNumber(), (boolean)false, (boolean)true);
            if (res != 0) {
                return res;
            }
            if ((o1.getStatus() == ProductStatus.REFUND || o1.getStatus() == ProductStatus.EXCHANGE) && o2.getStatus() == ProductStatus.SELL) {
                return 1;
            }
            return -1;
        }
    };
    Comparator<EntityReference<Organization>> airlineComparator = new Comparator<EntityReference<Organization>>(){

        @Override
        public int compare(EntityReference<Organization> o1, EntityReference<Organization> o2) {
            return TextUtil.compare((String)o1.toString(), (String)o2.toString(), (boolean)false, (boolean)true);
        }
    };

    private final int getSign(BigDecimal value) {
        return value == null ? 0 : value.signum();
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SamaraAgentReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        sheet.setForceFormulaRecalculation(true);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"SALEPOINT_ADDRESS", (String)((String)globalData.get("SALEPOINT_ADDRESS")));
        this.currentRow = 7;
        this.fillRegestry(wb, sheet, data, globalData);
        this.fillDebtByDayend(wb, sheet, data, globalData);
        this.fillPayment(wb, sheet, data, globalData);
        this.fillTotalSection(wb, sheet, data, globalData);
    }

    private void fillTicketData(HSSFSheet sheet, SamaraAgentReportTicket ticket) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)1, (String)ticket.getContractor());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)2, (String)ticket.getLines());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)3, (String)ticket.getClientProfile());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)4, (String)ticket.getPassangerLastName());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)5, (String)ticket.getRouteLine());
        if (ticket.getArmCount() != 0) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)6, (int)ticket.getArmCount());
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)7, (String)ticket.getTicketNumber());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)8, (String)ticket.getCarrierNumber());
        if (!ticket.isConjunction()) {
            if (ticket.getCreditCardType() != PaymentType.CREDIT_CARD_AGENCY) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)9, (BigDecimal)ticket.getEquivalentFare());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)11, (BigDecimal)ticket.getRuTaxAmount());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)12, (BigDecimal)ticket.getOtherTaxesAmount());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)13, (BigDecimal)ticket.getTchTaxAmount());
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)15, (BigDecimal)ticket.getClientEquivalentFee());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)16, (BigDecimal)ticket.getRefundFee());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)17, (BigDecimal)ticket.getPenaltyAmount());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)18, (BigDecimal)ticket.getClientEquivalentDiscount());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)19, (Double)ticket.getVendorCommissionRate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)20, (BigDecimal)ticket.getVendorEquivalentCommission());
            if (ticket.getCreditCardType() == PaymentType.CREDIT_CARD) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)21, (BigDecimal)ticket.getCreditCardAmount());
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)22, (BigDecimal)ticket.getTicketSumPaymentAmount().add(ticket.getFeeSumPaymentAmount()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)23, (BigDecimal)ticket.getCashAmount());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)24, (BigDecimal)ticket.getReclamation());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)25, (BigDecimal)ticket.getInvoiceAmount());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)26, (String)ticket.getInvoiceNumber());
        }
        if (ticket.getFlightDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)27, (String)this.df.format(ticket.getFlightDate()));
        }
        if (ticket.getCreditCardType() == PaymentType.CREDIT_CARD_AGENCY) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)28, (BigDecimal)ticket.getCreditCardAmount());
        }
    }

    private void fillRegestry(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SamaraAgentReportTicket> data, Map<String, Object> globalData) throws Exception {
        HashMap<EntityReference<Organization>, TicketsGroupData> ticketGroups = new HashMap<EntityReference<Organization>, TicketsGroupData>();
        for (SamaraAgentReportTicket ticket : data.getTickets()) {
            EntityReference<Organization> blankOwner = ticket.getBlankOwner();
            TicketsGroupData tdata = (TicketsGroupData)ticketGroups.get(blankOwner);
            if (tdata == null) {
                tdata = new TicketsGroupData();
                tdata.blankOwner = blankOwner;
                ticketGroups.put(blankOwner, tdata);
            }
            tdata.tickets.add(ticket);
        }
        ArrayList airlines = new ArrayList(ticketGroups.keySet());
        Collections.sort(airlines, this.airlineComparator);
        for (TicketsGroupData tdata : ticketGroups.values()) {
            Collections.sort(tdata.tickets, this.ticketComparator);
            for (SamaraAgentReportTicket ticket : tdata.tickets) {
                ExcelUtils.insertRow((HSSFSheet)sheet, (int)this.currentRow, (int)28, (int)23);
                this.fillTicketData(sheet, ticket);
                ++this.currentRow;
            }
        }
        this.registerTotalsLine = this.currentRow + 1;
        this.paymentsStartLine = this.debtsStartLine = this.registerTotalsLine + 4;
        this.paymentsTotalsLine = this.paymentsStartLine + 1;
        this.debtsTotalsLine = this.debtsStartLine + 1;
        this.setColumnTotalFormula(sheet, this.registerTotalsLine);
    }

    private void fillTotalSection(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SamaraAgentReportTicket> data, Map<String, Object> globalData) throws Exception {
        String formula = String.format("=%c%d", 87, this.registerTotalsLine);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(this.registerTotalsLine + 4), (int)1, (int)1, (int)4, (String)formula);
        formula = String.format("=%c%d", 85, this.registerTotalsLine);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(this.registerTotalsLine + 6), (int)1, (int)1, (int)4, (String)formula);
        formula = String.format("=%c%d", 88, this.registerTotalsLine);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(this.registerTotalsLine + 8), (int)1, (int)1, (int)4, (String)formula);
        int checkKKM = this.registerTotalsLine + 14;
        String checkKKMFormula = String.format("%c%d+%c%d", Character.valueOf('V'), this.registerTotalsLine, Character.valueOf('Z'), this.paymentsTotalsLine);
        int creditCard = this.registerTotalsLine + 6;
        int payCashier = this.registerTotalsLine + 7;
        int collection = this.registerTotalsLine + 11;
        String collectionFormula = String.format("(%c%d+%c%d+%c%d)", Character.valueOf('D'), creditCard, Character.valueOf('D'), payCashier, Character.valueOf('D'), collection);
        int restForStartDayLine = this.registerTotalsLine + 3;
        int restForEndDayLine = this.registerTotalsLine + 13;
        formula = String.format("%c%d", Character.valueOf('D'), restForStartDayLine) + "+" + checkKKMFormula + "-" + collectionFormula;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)restForEndDayLine, (int)1, (int)1, (int)4, (String)formula);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)checkKKM, (int)1, (int)1, (int)4, (String)checkKKMFormula);
        int startSaldo = this.registerTotalsLine + 2;
        int cash = this.registerTotalsLine + 4;
        int refund = this.registerTotalsLine + 8;
        formula = String.format("%c%d+%c%d+%c%d+%c%d-%c%d-%c%d", Character.valueOf('D'), startSaldo, Character.valueOf('D'), cash, Character.valueOf('D'), creditCard, Character.valueOf('D'), refund, Character.valueOf('V'), this.registerTotalsLine, Character.valueOf('Z'), this.paymentsTotalsLine);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(this.registerTotalsLine + 17), (int)1, (int)1, (int)4, (String)formula);
    }

    private void fillDebtByDayend(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SamaraAgentReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.currentRow = this.debtsStartLine;
        Map clientData = (Map)globalData.get(SamaraReportHelper.PayoffStatus.DEBT.name());
        if (clientData == null) {
            return;
        }
        ArrayList list = new ArrayList(clientData.values());
        list.sort(this.listComparator);
        globalData.remove(SamaraReportHelper.PayoffStatus.DEBT.name());
        int extraRowsCount = list.size() > 14 ? list.size() - 14 : 0;
        int totalRowsCount = 14 + extraRowsCount;
        if (extraRowsCount > 0) {
            int rowNum;
            for (int i = 0; i < extraRowsCount; ++i) {
                rowNum = this.debtsStartLine + i + 14 - 3;
                ExcelUtils.insertCells((HSSFSheet)sheet, (int)rowNum, (int)rowNum, (int)10, (int)17, (int)1, (boolean)false);
                ExcelUtils.mergeCells((HSSFSheet)sheet, (int)(rowNum + 3), (int)(rowNum + 3), (int)10, (int)15);
            }
            rowNum = this.debtsStartLine + totalRowsCount;
            ExcelUtils.mergeCells((HSSFSheet)sheet, (int)rowNum, (int)rowNum, (int)10, (int)15);
        }
        this.debtsTotalsLine = this.debtsStartLine + totalRowsCount;
        this.fixLastRowCellsBorder(wb, sheet, this.debtsTotalsLine, 10, 17);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy");
        for (SamaraClientData client : list) {
            String type = client.getType().toString();
            String title = TextUtil.isBlank((String)type) ? client.getTitle() : type + " " + client.getTitle();
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)10, (String)title);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)16, (BigDecimal)client.getSum());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)17, (String)sdf.format(client.getDate()));
            ++this.currentRow;
        }
        String formula = SalesReportHelper.getColumnSumFormula(String.valueOf('P'), this.debtsStartLine, this.debtsTotalsLine - 1);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)this.debtsTotalsLine, (int)1, (int)1, (int)16, (String)formula);
    }

    private void fillPayment(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SamaraAgentReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.currentRow = this.paymentsStartLine;
        Map clientData = (Map)globalData.get(SamaraReportHelper.PayoffStatus.PAYED.name());
        if (clientData == null) {
            return;
        }
        ArrayList list = new ArrayList(clientData.values());
        globalData.remove(SamaraReportHelper.PayoffStatus.PAYED.name());
        list.sort(this.listComparator);
        int extraRowsCount = list.size() > 14 ? list.size() - 14 : 0;
        int totalRowsCount = 14 + extraRowsCount;
        if (extraRowsCount > 0) {
            int rowNum;
            for (int i = 0; i < extraRowsCount; ++i) {
                rowNum = this.debtsStartLine + i + 14 - 3;
                ExcelUtils.insertCells((HSSFSheet)sheet, (int)rowNum, (int)rowNum, (int)20, (int)26, (int)1, (boolean)false);
                ExcelUtils.mergeCells((HSSFSheet)sheet, (int)(rowNum + 3), (int)(rowNum + 3), (int)20, (int)25);
            }
            rowNum = this.paymentsStartLine + totalRowsCount;
            ExcelUtils.mergeCells((HSSFSheet)sheet, (int)rowNum, (int)rowNum, (int)20, (int)25);
        }
        this.paymentsTotalsLine = this.currentRow + totalRowsCount;
        this.fixLastRowCellsBorder(wb, sheet, this.paymentsTotalsLine, 20, 26);
        for (SamaraClientData client : list) {
            String type = client.getType().toString();
            String title = TextUtil.isBlank((String)type) ? client.getTitle() : type + " " + client.getTitle();
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)20, (String)title);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.currentRow, (int)1, (int)1, (int)26, (BigDecimal)client.getSum());
            ++this.currentRow;
        }
        String formula = SalesReportHelper.getColumnSumFormula(String.valueOf('Z'), this.paymentsStartLine, this.paymentsTotalsLine - 1);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)this.paymentsTotalsLine, (int)1, (int)1, (int)26, (String)formula);
    }

    private void setColumnTotalFormula(HSSFSheet sheet, int row) throws Exception {
        String columnLetter = "";
        int j = 1;
        int k = j + 1;
        int len = 28;
        for (int i = 9; i <= len; ++i) {
            if (i > 25 && i < 28) continue;
            if (i < 27) {
                columnLetter = String.valueOf((char)(64 + i));
            } else {
                columnLetter = String.format("%s%s", String.valueOf((char)(64 + j)), String.valueOf((char)(64 + k)));
                ++k;
            }
            String formula = SalesReportHelper.getColumnSumFormula(columnLetter, 7, this.currentRow);
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)i, (String)formula);
        }
    }

    private void fixLastRowCellsBorder(HSSFWorkbook wb, HSSFSheet sheet, int rowIndex, int col1, int col2) throws Exception {
        for (int i = col1; i <= col2; ++i) {
            HSSFCellStyle style = ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)rowIndex, (int)i);
            HSSFCellStyle clone = wb.createCellStyle();
            if (style != null) {
                clone.cloneStyleFrom(style);
            }
            clone.setBorderBottom((short)2);
            clone.setBorderTop((short)2);
            ExcelUtils.setCellStyle((HSSFSheet)sheet, (int)rowIndex, (int)i, (HSSFCellStyle)clone);
        }
    }

    private static <T extends Comparable<T>> int compare(T arg1, T arg2) {
        if (arg1 == null && arg2 == null) {
            return 0;
        }
        if (arg1 == null) {
            return 1;
        }
        if (arg2 == null) {
            return -1;
        }
        return arg1.compareTo(arg2);
    }

    final class TicketsGroupData {
        EntityReference<Organization> blankOwner;
        List<SamaraAgentReportTicket> tickets = new ArrayList<SamaraAgentReportTicket>();

        TicketsGroupData() {
        }
    }
}

