/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.aviacentr;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AviacentrConsolidatedReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.aviacentr.AviacentrConsolidatedReportTicket;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MoneyUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;

public class AviacentrConsolidatedReportWorksheetHandler
implements PoiWorksheetHandler<AviacentrConsolidatedReportTicket> {
    private static final String SHEET_TITLE = L10nResourcesManager.createL10nMessage((String)Messages.AviacentrConsolidatedReportRenderHandler_reportName, (Object[])new Object[0]).toString();
    private static final String SECTION_DATA = "START_DATA";
    private static final Integer ROW_DATA_START = 23;
    private static final Integer COLUMN_DATA_START = 2;
    private static final Integer COLUMN_DATA_END = 11;
    private static final Integer DIRECTOR_SIGNATURE_START_ROW = 31;
    private static final Integer DIRECTOR_SIGNATURE_COLUMN = 5;
    private static final Integer CHIEF_ACCOUNTANT_SIGNATURE_START_ROW = 33;
    private static final Integer CHIEF_ACCOUNTANT_SIGNATURE_COLUMN = 5;
    private static final Integer STAMP_START_ROW = 31;
    private static final Integer STAMP_COLUMN = 3;
    private static final String EMPTY = "";
    protected DateFormat df = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
    private final DecimalFormat decimalFormat = new DecimalFormat("#.##");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<AviacentrConsolidatedReportTicket> data, Map<String, Object> globalData) throws Exception {
        AviacentrConsolidatedReportParameters params = (AviacentrConsolidatedReportParameters)globalData.get("key-report-params");
        this.putHeaderData(sheet, globalData, params);
        BigDecimal totalSum = BigDecimal.ZERO;
        BigDecimal totalVat = BigDecimal.ZERO;
        BigDecimal totalSumInclVat = BigDecimal.ZERO;
        Integer num = 0;
        for (AviacentrConsolidatedReportTicket ticket : data.getTickets()) {
            totalSum = totalSum.add(ticket.getTotalPrice() != null ? ticket.getTotalPrice() : BigDecimal.ZERO);
            totalVat = totalVat.add(ticket.getVatAmount() != null ? ticket.getVatAmount() : BigDecimal.ZERO);
            totalSumInclVat = totalSumInclVat.add(ticket.getTotalWithVat() != null ? ticket.getTotalWithVat() : BigDecimal.ZERO);
            Integer n = num;
            num = num + 1;
            Integer n2 = num;
        }
        totalSum = totalSum.setScale(2, RoundingMode.HALF_UP);
        totalVat = totalVat.setScale(2, RoundingMode.HALF_UP);
        totalSumInclVat = totalSumInclVat.setScale(2, RoundingMode.HALF_UP);
        int startRow = ROW_DATA_START;
        int startColumn = COLUMN_DATA_START;
        for (int n = 1; n < data.getTickets().size(); ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)(startRow - 1), (int)(startRow - 1));
        }
        int row = 1;
        for (AviacentrConsolidatedReportTicket ticket : data.getTickets()) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)startRow, (int)startColumn, (int)row, (int)1, (String)(ticket.getProductName() != null ? ticket.getProductName() : EMPTY));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)startRow, (int)startColumn, (int)row, (int)4, (String)(ticket.getUnitOfMeasure() != null ? ticket.getUnitOfMeasure() : EMPTY));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)startRow, (int)startColumn, (int)row, (int)5, (String)(ticket.getAmountStr() != null ? ticket.getAmountStr() : EMPTY));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)startRow, (int)startColumn, (int)row, (int)6, (String)(ticket.getPriceStr() != null ? ticket.getPriceStr() : EMPTY));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)startRow, (int)startColumn, (int)row, (int)7, (String)(ticket.getTotalPriceStr() != null ? ticket.getTotalPriceStr() : EMPTY));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)startRow, (int)startColumn, (int)row, (int)8, (String)(ticket.getVatRateStr() != null ? ticket.getVatRateStr() : EMPTY));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)startRow, (int)startColumn, (int)row, (int)9, (String)(ticket.getVatAmountStr() != null ? ticket.getVatAmountStr() : EMPTY));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)startRow, (int)startColumn, (int)row, (int)10, (String)(ticket.getTotalWithVatStr() != null ? ticket.getTotalWithVatStr() : EMPTY));
            ++row;
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"PRICETOTAL", (String)totalSum.toString());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"VATTOTAL", (String)totalVat.toString());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"PRICEANDVAT", (String)totalSumInclVat.toString());
        this.putBottomData(sheet, globalData, (BaseReportParameters)params, num, totalSumInclVat, totalVat);
        if (params.isNeedImageSignatures()) {
            this.putSignaturesAndStamp(wb, sheet, globalData, row);
        }
    }

    private void putSignaturesAndStamp(HSSFWorkbook wb, HSSFSheet sheet, Map<String, Object> globalData, int row) {
        HSSFPatriarch drawing = sheet.createDrawingPatriarch();
        this.putImage(wb, sheet, drawing, globalData.get("DIRECTOR_SIGNATURE"), (short)(DIRECTOR_SIGNATURE_COLUMN.shortValue() - 1), DIRECTOR_SIGNATURE_START_ROW + row - 4);
        this.putImage(wb, sheet, drawing, globalData.get("CHIEF_ACCOUNTANT_SIGNATURE"), (short)(CHIEF_ACCOUNTANT_SIGNATURE_COLUMN.shortValue() - 1), CHIEF_ACCOUNTANT_SIGNATURE_START_ROW + row - 3);
        this.putImage(wb, sheet, drawing, globalData.get("AGENCY_STAMP"), (short)(STAMP_COLUMN.shortValue() - 2), STAMP_START_ROW + row - 3);
    }

    private void putImage(HSSFWorkbook wb, HSSFSheet sheet, HSSFPatriarch drawing, Object data, short col1, int row1) {
        if (data == null || !(data instanceof byte[])) {
            return;
        }
        byte[] imageBytes = (byte[])data;
        if (imageBytes.length > 0) {
            HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, col1, row1, (short)(col1 + 3), row1 + 3);
            int index = wb.addPicture(imageBytes, 6);
            HSSFPicture picture = drawing.createPicture(anchor, index);
            anchor.setAnchorType(ClientAnchor.AnchorType.byId((int)2));
            picture.resize();
        }
    }

    private void putHeaderData(HSSFSheet sheet, Map<String, Object> globalData, AviacentrConsolidatedReportParameters params) {
        Date reportDate = params.getReportDate();
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCYNAME", (String)((String)globalData.get("AGENCYNAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORTDATE", reportDate != null ? this.df.format(reportDate) : null);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCYADDRESS", (String)((String)globalData.get("AGENCYADDRESS")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCYINN", (String)((String)globalData.get("AGENCYINN")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCYKPP", (String)((String)globalData.get("AGENCYKPP")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"ACCEPTOR", (String)((String)globalData.get("ACCEPTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"BANK", (String)((String)globalData.get("BANK")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"ACCOUNTNUMBER", (String)((String)globalData.get("ACCOUNTNUMBER")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"BIKNUMBER", (String)((String)globalData.get("BIKNUMBER")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CORRACCOUNT", (String)((String)globalData.get("CORRACCOUNT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORTNUMBER", (String)((String)globalData.get("REPORTNUMBER")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CLIENTNAME", (String)((String)globalData.get("CLIENTNAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"PAYERNAME", (String)((String)globalData.get("PAYERNAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"PAYMENTCURRENCY", (String)((String)globalData.get("PAYMENTCURRENCY")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACTNUMBERDATE", (String)((String)globalData.get("CONTRACTNUMBERDATE")));
    }

    private void putBottomData(HSSFSheet sheet, Map<String, Object> globalData, BaseReportParameters params, Integer num, BigDecimal totalSumInclVat, BigDecimal totalVat) {
        ExcelUtils.replace((HSSFSheet)sheet, (String)"ITEMSCOUNT", (String)num.toString());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"OVERALLSUM", (String)totalSumInclVat.toString());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DIGITSTOTALSUM", (String)totalSumInclVat.toString());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"WRITTENTOTALSUM", (String)TextUtil.capitalize((String)MoneyUtil.money2str((Locale)LocaleUtil.LOCALE_RU, (String)((String)globalData.get("PAYMENTCURRENCY")), (double)totalSumInclVat.doubleValue(), (boolean)true)));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"VATWRITTEN", (String)TextUtil.capitalize((String)MoneyUtil.money2str((Locale)LocaleUtil.LOCALE_RU, (String)((String)globalData.get("PAYMENTCURRENCY")), (double)totalVat.doubleValue(), (boolean)true)));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DIRECTOR", (String)((String)globalData.get("DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CHIEFACCOUNTANT", (String)((String)globalData.get("CHIEFACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORTMAKER", (String)((String)globalData.get("REPORTMAKER")));
    }

    protected int getDataStartRowIndex(String section, HSSFSheet sheet) throws Exception {
        HSSFCell cell1 = ExcelUtils.findCell((HSSFSheet)sheet, (String)section);
        if (cell1 == null) {
            throw new Exception(L10nResourcesManager.createL10nMessage((String)Messages.AviacentrConsolidatedReportWorksheetHandler_cellNotFound, (Object[])new Object[]{section, SHEET_TITLE}).toString());
        }
        return cell1.getRowIndex() + 1;
    }
}

