/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;

public abstract class BasePoiSalesReportRenderHandler<T extends BaseReportTicket>
extends BasePoiReportRenderHandler<T> {
    protected File getTemplateFile() throws IOException {
        File result = IoUtil.url2file((URL)BasePoiSalesReportRenderHandler.class.getResource("/salesreports/" + this.getTemplateFileName()));
        if (result == null || !result.exists()) {
            throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.BasePoiSalesReportRenderHandler_templateNotFound, (Object[])new Object[0]).toString());
        }
        return result;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return "" + (String)data.get("AIRLINE_IATA_CODE") + "_" + (String)data.get("AGENCY_IATA_CODE") + (String)data.get("KEY_REPORT_FILENAME");
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(ReportDocument.class);
        ((ReportDocument)result.getEntity()).getFiles().add(file);
        ((ReportDocument)result.getEntity()).setReportType(ReportType.VENDOR);
        List messages = (List)data.get("key-messages");
        ((ReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((ReportDocument)result.getEntity()).setParameters((ReportParameters)data.get("key-report-params"));
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        return IoUtil.getResourceInputStream((File)this.getTemplateFile());
    }

    protected abstract String getTemplateFileName();
}

