/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public abstract class BasePoiWorksheetHandler<T>
implements PoiWorksheetHandler<T> {
    protected final String dateFormatPattern = "dd.MM.yyyy";
    protected final String dateTimeFormatPattern = "dd.MM.yyyy HH:mm";
    @Deprecated
    protected DateFormat df = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));

    protected void updateGlobalData(HSSFSheet sheet, Map<String, Object> data) {
        BaseReportParameters params = (BaseReportParameters)data.get("key-report-params");
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CURRENT_DATE", (String)this.df.format(new Date()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AIRLINE_IATA_CODE", (String)((String)data.get("AIRLINE_IATA_CODE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENT_NAME", (String)((String)data.get("AGENT_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)data.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_CODE_", (String)((String)data.get("AGENCY_CODE_")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_START", startDate != null ? this.df.format(startDate) : null);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_END", endDate != null ? this.df.format(endDate) : null);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"COUNTRY_NAME", (String)DictHelper.getDomesticCountryRussianName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)BasePoiWorksheetHandler.getAgencyCode(data));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD_NO", (String)((String)data.get("REPORT_PERIOD_NO")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)data.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)((String)data.get("AGENCY_DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)((String)data.get("REPORT_PERIOD")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_CITY", (String)((String)data.get("AGENCY_CITY")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENT_LOCATION", (String)((String)data.get("AGENT_LOCATION")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_PHONE", (String)((String)data.get("AGENCY_PHONE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_EMAIL", (String)((String)data.get("AGENCY_EMAIL")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)((String)data.get("CONTRACT_NO")));
        Date issueDate = (Date)data.get("CONTRACT_ISSUE_DATE");
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_ISSUE_DATE", issueDate != null ? this.df.format(issueDate) : null);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_INN", (String)((String)data.get("AGENCY_INN")));
        String vendorName = (String)data.get("AIRLINE_NAME");
        if (vendorName == null) {
            vendorName = (String)data.get("VENDOR_NAME");
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"VENDOR_NAME", (String)vendorName);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"VENDOR_KPP", (String)((String)data.get("VENDOR_KPP")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"VENDOR_LOCATION", (String)((String)data.get("VENDOR_LOCATION")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)((String)data.get("CONTRACT_NO")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGREEMENT_NO", (String)((String)data.get("AGREEMENT_NO")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AIRLINE_IATA_ALPHABETICAL_CODE", (String)((String)data.get("AIRLINE_IATA_ALPHABETICAL_CODE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"EQ_CUR_CODE", (String)DictHelper.getLocalCurrency());
        String decadeNumber = this.getDecadeNumber(startDate, endDate);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DECADE_NUMBER", (String)decadeNumber);
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<T> data, Map<String, Object> globalData) throws Exception {
        this.updateGlobalData(sheet, globalData);
    }

    static String getAgencyCode(Map<String, Object> data) {
        String actualAgencyCode = (String)data.get("AGENCY_IATA_CODE");
        String oldSuAgencyCode = (String)data.get("KEY_SU_2013_AGENCY_CODE");
        if (!TextUtil.isBlank((String)actualAgencyCode) && !TextUtil.isBlank((String)oldSuAgencyCode)) {
            return oldSuAgencyCode + "/" + actualAgencyCode;
        }
        return actualAgencyCode;
    }

    private String getDecadeNumber(Date startDate, Date endDate) {
        String res = "";
        if (startDate == null || endDate == null) {
            return res;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int startDay = cal.get(5);
        int startMonth = cal.get(2);
        res = String.valueOf(startMonth + 1);
        if (res.length() == 1) {
            res = "0" + res;
        }
        cal.setTime(endDate);
        int endDay = cal.get(5);
        int endMonth = cal.get(2);
        boolean valid = true;
        if (startMonth == endMonth) {
            if (startDay == 1 && endDay == 10) {
                res = res + "1";
            } else if (startDay == 11 && endDay == 20) {
                res = res + "2";
            } else if (startDay == 21 && (endDay == 28 || endDay == 29 || endDay == 30 || endDay == 31)) {
                res = res + "3";
            } else {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid ? res : "";
    }
}

