/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public abstract class BaseRegistryWorksheetHandler
extends BasePoiWorksheetHandler<BaseSalesReportTicket> {
    protected HSSFSheet currentSheet;
    protected int currentRow;
    protected int currentItemIndex;
    protected int maxColumnsAmount;
    protected int maxRowsToShift;
    private final Map<String, String> totalFormula = new HashMap<String, String>();

    @Override
    protected void updateGlobalData(HSSFSheet sheet, Map<String, Object> data) {
        super.updateGlobalData(sheet, data);
        this.currentSheet = sheet;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMMMM yyyy", new DateFormatSymbols(LocaleManager.get().getCurrentLocale()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CURRENT_DATE", (String)dateFormat.format(new Date()));
    }

    protected void addRow(BaseSalesReportTicket ticket, IColumn[] columns, boolean insRow) throws Exception {
        if (ticket == null || columns == null) {
            return;
        }
        if (insRow) {
            ExcelUtils.insertRow((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)this.maxColumnsAmount, (int)this.maxRowsToShift);
        }
        for (IColumn column : columns) {
            this.setFieldValue(ticket, this.currentItemIndex, column);
        }
        ++this.currentRow;
    }

    protected abstract void setFieldValue(BaseSalesReportTicket var1, int var2, IColumn var3) throws Exception;

    protected void init(HSSFSheet sheet, int curRow, int rowsToShift, int colAmount) {
        this.currentSheet = sheet;
        this.currentSheet.setForceFormulaRecalculation(true);
        this.currentRow = curRow;
        this.maxRowsToShift = rowsToShift;
        this.maxColumnsAmount = colAmount;
    }

    protected void setSubtotalForColumn(IColumn[] columns, int rowNum, int startRowNum, int endRowNum) throws Exception {
        for (IColumn column : columns) {
            this.updateTotalFormula(column, rowNum);
            ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)rowNum, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)SalesReportHelper.getColumnSumFormula(column.getExcelColumn().getColumnName(), startRowNum, endRowNum));
        }
    }

    protected void addSplitRow(String text, IColumn[] columns) throws Exception {
        HSSFCell cell;
        ExcelUtils.insertRow((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)this.maxColumnsAmount, (int)this.maxRowsToShift);
        int firstCol = columns[0].getExcelColumn().getColumnIndex();
        int lastCol = columns[columns.length - 1].getExcelColumn().getColumnIndex();
        ExcelUtils.mergeCells((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)this.currentRow, (int)firstCol, (int)lastCol);
        HSSFRow row = this.currentSheet.getRow(this.currentRow - 1);
        if (row != null && (cell = row.getCell(0)) != null) {
            HSSFRichTextString str = new HSSFRichTextString(text);
            cell.setCellValue((RichTextString)str);
        }
        ++this.currentRow;
    }

    public abstract IColumn[] getColumns();

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        List bags;
        super.fill(wb, sheet, data, globalData);
        ArrayList tickets = (ArrayList)data.getTickets();
        Map ticketsMap = SalesReportHelper.splitTicketsByProductCategory(tickets);
        List list = bags = ticketsMap == null ? null : ticketsMap.get(ProductCategory.EXCESS_BAGAGE.name());
        if (bags != null) {
            tickets.removeAll(bags);
        }
        if (tickets.isEmpty() && (bags == null || bags.isEmpty())) {
            return;
        }
        if (bags != null && !bags.isEmpty()) {
            this.copySection();
        }
        int count = 0;
        int startRow = this.currentRow;
        for (BaseSalesReportTicket ticket : tickets) {
            this.addRow(ticket, this.getColumns(), count < tickets.size() - 1);
            ++this.currentItemIndex;
            ++count;
        }
        this.fillSubtotal(startRow, this.currentRow - 1);
        if (bags != null && !bags.isEmpty()) {
            this.currentRow += 2;
            this.addSplitRow(L10nResourcesManager.createL10nMessage((String)Messages.SomeWorksheetHandler_baggageTitle, (Object[])new Object[0]).toString(), this.getColumns());
            this.currentItemIndex = 0;
            count = 0;
            startRow = this.currentRow;
            for (BaseSalesReportTicket bag : bags) {
                this.addRow(bag, this.getColumns(), count < bags.size() - 1);
                ++this.currentItemIndex;
                ++count;
            }
            this.fillSubtotal(startRow, this.currentRow - 1);
        }
        this.fillTotal();
    }

    protected abstract void fillSubtotal(int var1, int var2) throws Exception;

    protected abstract void fillTotal() throws Exception;

    private void copySection() throws Exception {
        ExcelUtils.copyRows((HSSFSheet)this.currentSheet, (int)(this.currentRow - 1), (int)(this.currentRow + 1));
    }

    private void updateTotalFormula(IColumn column, int rowNum) {
        String value = this.totalFormula.get(column.getExcelColumn().getColumnName());
        value = value == null ? column.getExcelColumn().getColumnName() + rowNum : value + "+" + column.getExcelColumn().getColumnName() + rowNum;
        this.totalFormula.put(column.getExcelColumn().getColumnName(), value);
    }

    protected void setTotalFormulaForColumn(IColumn[] columns, int rowNum) throws Exception {
        for (IColumn col : columns) {
            ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)rowNum, (int)1, (int)1, (int)col.getExcelColumn().getColumnIndex(), (String)this.totalFormula.get(col.getExcelColumn().getColumnName()));
        }
    }

    public static interface IColumn {
        public ExcelColumn getExcelColumn();
    }
}

