/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AgencyMemoProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public abstract class BaseSalesReportTicket
extends BaseReportTicket {
    private static final long serialVersionUID = 7558095570704375478L;
    private String[] conjunctions;
    private String[] conjunctionScns;
    protected Money baseFare;
    protected Collection<ProductFop> fops;
    protected Collection<Tax> taxes;
    private int segmentsNumber = 0;
    protected BigDecimal penalty = BigDecimal.ZERO;
    private TransportationType transportationType;
    private BlankCategory blankCategory;
    protected BigDecimal vendorEquivalentCommission;
    protected Money vendorCommissionValue;
    protected Double vendorCommissionRate;
    private BigDecimal roe;
    private BigDecimal fareRate;
    protected int couponsCount;
    private String blankOwnerCode;
    private TariffType tariffType;
    private String profileCode;
    private boolean eticket;
    protected Date relatedProductIssueDate;
    protected String relatedProductNumber;
    protected BigDecimal relatedProductEquivalentFare;
    protected Date relatedSellProductIssueDate;
    protected String relatedSellProductNumber;
    protected BigDecimal relatedSellProductEquivalentFare;
    private String creditCardNo = null;
    protected BigDecimal creditCardValue;
    private CardVendor paymentCardVendor;
    private String paymentCardSecurityCode;
    protected BigDecimal cashValue;
    protected BigDecimal vendorEquivalentFee;
    protected Money vendorFeeValue;
    protected Double vendorFeeRate;
    protected BigDecimal subagencyEquivalentCommission;
    protected Money subagencyCommissionValue;
    protected Double subagencyCommissionRate;
    protected BigDecimal subagencyEquivalentFee;
    protected Money subagencyFeeValue;
    protected Double subagencyFeeRate;
    protected BigDecimal clientEquivalentDiscount;
    protected Money clientDiscountValue;
    protected Double clientDiscountRate;
    protected BigDecimal clientEquivalentFee;
    protected Money clientFeeValue;
    protected Double clientFeeRate;
    protected BigDecimal clientEquivalentCommission;
    protected Money clientCommissionValue;
    protected Double clientCommissionRate;
    protected String validatorCode;
    protected String couponsList;
    protected ReportTicketType reportTicketType;
    protected AgencyMemoProductType agencyMemoProductType;
    protected boolean reportAssociatedAgencyMemoProduct;
    protected boolean routeContainsCrimea;
    protected boolean routeContainsKaliningrad;
    protected boolean routeContainsDVFO;
    protected boolean routeContainsCIS;
    protected final Collection<AgencyMemoProductItemGroup> agencyMemoProductItemGroups = new ArrayList<AgencyMemoProductItemGroup>();

    public BaseSalesReportTicket() {
        this.creditCardValue = BigDecimal.ZERO;
        this.cashValue = BigDecimal.ZERO;
        this.conjunctions = new String[0];
        this.conjunctionScns = new String[0];
        this.transportationType = TransportationType.NONE;
        this.fops = new ArrayList<ProductFop>();
        this.taxes = new ArrayList<Tax>();
        this.vendorEquivalentCommission = BigDecimal.ZERO;
        this.reportTicketType = ReportTicketType.PRODUCT;
    }

    public BaseSalesReportTicket(Product ticket, List<Message> messages) throws Exception {
        super(ticket, messages);
        Product relatedProduct;
        Product previousSellProduct;
        Product previousProduct;
        Product rp;
        this.creditCardValue = BigDecimal.ZERO;
        this.cashValue = BigDecimal.ZERO;
        this.conjunctions = new String[0];
        this.conjunctionScns = new String[0];
        this.transportationType = TransportationType.NONE;
        this.fops = new ArrayList<ProductFop>();
        this.taxes = new ArrayList<Tax>();
        this.vendorEquivalentCommission = BigDecimal.ZERO;
        this.reportTicketType = ReportTicketType.PRODUCT;
        this.roe = AirProductHelper.getNucRoe((Product)ticket);
        if (this.roe != null) {
            this.fareRate = AirProductHelper.calculateFareRate((Product)ticket);
        }
        for (ProductFop fop : AirProductHelper.getVendorContractRelation((Product)ticket).getFops()) {
            this.fops.add((ProductFop)XCloneHelper.clone((XCloneable)fop));
        }
        for (Tax tax : ticket.getTaxes()) {
            this.taxes.add((Tax)XCloneHelper.clone((XCloneable)tax));
        }
        this.baseFare = AirProductHelper.getBaseFare((Product)ticket);
        block15: for (Commission commission : AirProductHelper.getUnmodifiableCommissions((Product)ticket, null)) {
            BigDecimal equivalentAmount;
            Money amount;
            Double rate;
            boolean discount;
            EntityReference prop;
            if (commission.getContractType() == null) continue;
            boolean isBSPCommission = false;
            boolean isSupplierBSP = false;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                EntityReference cprop = commission.getCommissionProperties();
                EntityContainer cpropCtr = EntityStorage.get().resolve(cprop);
                EntityContainer supplierCtr = EntityStorage.get().resolve(AirProductHelper.getSupplier((Product)ticket));
                isBSPCommission = cpropCtr != null && ((CommissionProperties)cpropCtr.getEntity()).isBspCommission();
                boolean bl = isSupplierBSP = supplierCtr != null && "BSP".equals(((Organization)supplierCtr.getEntity()).getCode());
                if (isBSPCommission && (supplierCtr == null || !"BSP".equals(((Organization)supplierCtr.getEntity()).getCode())) || cpropCtr != null && ((CommissionProperties)cpropCtr.getEntity()).isBonus()) continue;
            }
            boolean fee = (prop = commission.getCommissionProperties()) != null && (FeeProperties.class.equals((Object)prop.getType()) || PaymentFeeProperties.class.equals((Object)prop.getType()));
            boolean bl = discount = prop != null && DiscountProperties.class.getName().equals(prop.getType().getName());
            if (isSupplierBSP && !isBSPCommission) continue;
            if (isSupplierBSP && isBSPCommission) {
                rate = ticket.getBspCommissionRate();
                amount = ticket.getBspCommissionValue();
                equivalentAmount = amount != null ? amount.getValue() : BigDecimal.ZERO;
            } else {
                rate = commission.getRate();
                amount = commission.getAmount();
                equivalentAmount = commission.getEquivalentAmount();
            }
            if (fee) {
                switch (commission.getContractType()) {
                    case CLIENT: {
                        this.clientEquivalentFee = this.updateCommissionValue(this.clientEquivalentFee, equivalentAmount);
                        this.clientFeeRate = this.updateCommissionRate(this.clientFeeRate, rate);
                        this.clientFeeValue = this.updateCommissionAmount(this.clientFeeValue, amount);
                        break;
                    }
                    case SUBAGENCY: {
                        this.subagencyEquivalentFee = this.updateCommissionValue(this.subagencyEquivalentFee, equivalentAmount);
                        this.subagencyFeeRate = this.updateCommissionRate(this.subagencyFeeRate, rate);
                        this.subagencyFeeValue = this.updateCommissionAmount(this.subagencyFeeValue, amount);
                        break;
                    }
                    case VENDOR: {
                        this.vendorEquivalentFee = this.updateCommissionValue(this.vendorEquivalentFee, equivalentAmount);
                        this.vendorFeeRate = this.updateCommissionRate(this.vendorFeeRate, rate);
                        this.vendorFeeValue = this.updateCommissionAmount(this.vendorFeeValue, amount);
                    }
                }
                continue;
            }
            if (discount) {
                switch (commission.getContractType()) {
                    case CLIENT: {
                        this.clientEquivalentDiscount = this.updateCommissionValue(this.clientEquivalentDiscount, equivalentAmount);
                        this.clientDiscountRate = this.updateCommissionRate(this.clientDiscountRate, rate);
                        this.clientDiscountValue = this.updateCommissionAmount(this.clientDiscountValue, amount);
                        continue block15;
                    }
                }
                continue;
            }
            switch (commission.getContractType()) {
                case CLIENT: {
                    this.clientEquivalentCommission = this.updateCommissionValue(this.clientEquivalentCommission, equivalentAmount);
                    this.clientCommissionRate = this.updateCommissionRate(this.clientCommissionRate, rate);
                    this.clientCommissionValue = this.updateCommissionAmount(this.clientCommissionValue, amount);
                    break;
                }
                case SUBAGENCY: {
                    this.subagencyEquivalentCommission = this.updateCommissionValue(this.subagencyEquivalentCommission, equivalentAmount);
                    this.subagencyCommissionRate = this.updateCommissionRate(this.subagencyCommissionRate, rate);
                    this.subagencyCommissionValue = this.updateCommissionAmount(this.subagencyCommissionValue, amount);
                    break;
                }
                case VENDOR: {
                    this.vendorEquivalentCommission = this.updateCommissionValue(this.vendorEquivalentCommission, equivalentAmount);
                    this.vendorCommissionRate = this.updateCommissionRate(this.vendorCommissionRate, rate);
                    this.vendorCommissionValue = this.updateCommissionAmount(this.vendorCommissionValue, amount);
                }
            }
            if (!isBSPCommission || !isSupplierBSP) continue;
            break;
        }
        if (this.status == ProductStatus.VOID) {
            Money fare = new Money();
            fare.setValue(BigDecimal.ZERO);
            fare.setCurrency(SalesReportHelper.getEquivCurrency(null));
            this.baseFare = fare;
            this.vendorEquivalentCommission = BigDecimal.ZERO;
            this.taxes.clear();
        }
        this.ticketSeries = ticket.getBlankOwnerNumber();
        this.blankOwnerCode = BaseSalesReportTicket.getCode((EntityReference<Organization>)ticket.getBlankOwnerRef());
        this.conjunctions = AirProductHelper.getConjunctions((Product)ticket);
        this.conjunctionScns = AirProductHelper.getConjunctionsScns((Product)ticket);
        Product prod = ticket;
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() != MCOCategory.PTA && (rp = AirProductHelper.findRelatedAirProduct((Product)ticket, null, (boolean)false)) != null) {
            prod = rp;
        }
        this.eticket = prod.isEticket();
        this.tariffType = prod.getTariffType();
        this.transportationType = AirProductHelper.getTransportationType((Product)prod);
        if ("SU".equals(this.blankOwnerCode) && TransportationType.DOMESTIC == this.transportationType && this.hasSimferopolInRoute(prod.getSegmentTariffs())) {
            this.transportationType = TransportationType.INTERNATIONAL;
        }
        if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.VOUCHER && prod.getStatus() == ProductStatus.EXCHANGE && prod.getNextProduct() != null && prod.getNextProduct().getStatus() == ProductStatus.SELL && prod.getNextProduct().getProductCategory() == ProductCategory.AIR) {
            this.transportationType = AirProductHelper.getTransportationType((Product)prod.getNextProduct());
        }
        if ((this.status == ProductStatus.REFUND || this.status == ProductStatus.EXCHANGE) && (previousProduct = ticket.getPreviousProduct()) != null) {
            this.relatedProductIssueDate = previousProduct.getIssueDate();
            this.relatedProductNumber = previousProduct.getSystemNumber();
            this.relatedProductEquivalentFare = AirProductHelper.getEquivalentFare((Product)previousProduct);
        }
        if ((previousSellProduct = (Product)BookingHelper.getPreviousProduct((BaseProduct)ticket, (ProductStatus)ProductStatus.SELL)) != null) {
            this.relatedSellProductIssueDate = previousSellProduct.getIssueDate();
            this.relatedSellProductNumber = previousSellProduct.getSystemNumber();
            this.relatedSellProductEquivalentFare = AirProductHelper.getEquivalentFare((Product)previousSellProduct);
        }
        if (this.status == ProductStatus.SELL || this.status == ProductStatus.REFUND) {
            this.penalty = ticket.getPenalty();
        }
        for (SegmentTariff st : ticket.getSegmentTariffs()) {
            this.segmentsNumber += st.getSegments().size();
        }
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(ticket.getBlankType());
        if (blankType != null) {
            this.couponsCount = blankType.getCouponsCount();
            this.blankCategory = blankType.getBlankCategory();
        }
        this.validatorCode = ticket.getValidatorCode();
        this.couponsList = AirProductHelper.getCouponsList((Product)ticket);
        this.routeContainsCrimea = AirProductHelper.isRouteContainCrimea((Product)ticket);
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() != MCOCategory.POSTAGE_FEE && (relatedProduct = AirProductHelper.findRelatedAirProduct((Product)ticket, null, (boolean)false)) != null) {
            this.routeContainsCrimea = AirProductHelper.isRouteContainCrimea((Product)relatedProduct);
        }
        this.routeContainsKaliningrad = AirProductHelper.isRouteContainsKaliningrad((Product)ticket);
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() != MCOCategory.POSTAGE_FEE && (relatedProduct = AirProductHelper.findRelatedAirProduct((Product)ticket, null, (boolean)false)) != null) {
            this.routeContainsKaliningrad = AirProductHelper.isRouteContainsKaliningrad((Product)relatedProduct);
        }
        this.routeContainsDVFO = AirProductHelper.isRouteContainsDVFO((Product)ticket);
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() != MCOCategory.POSTAGE_FEE && (relatedProduct = AirProductHelper.findRelatedAirProduct((Product)ticket, null, (boolean)false)) != null) {
            this.routeContainsDVFO = AirProductHelper.isRouteContainsDVFO((Product)relatedProduct);
        }
        this.routeContainsCIS = AirProductHelper.isRouteContainsCISWithoutDomestic((Product)ticket);
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() != MCOCategory.POSTAGE_FEE && (relatedProduct = AirProductHelper.findRelatedAirProduct((Product)ticket, null, (boolean)false)) != null) {
            this.routeContainsCIS = AirProductHelper.isRouteContainsCISWithoutDomestic((Product)relatedProduct);
        }
    }

    private boolean hasSimferopolInRoute(List<SegmentTariff> segmentTariffs) {
        for (SegmentTariff st : segmentTariffs) {
            for (Segment s : st.getSegments()) {
                GeoLocation arrLoc;
                GeoLocation depLoc;
                if (s.getDepartureLocation() != null && "SIP".equalsIgnoreCase((String)(depLoc = (GeoLocation)DictionaryCache.get().resolveReference(s.getDepartureLocation())).getCodeVariants().get(CodeSystem.IATA.name()))) {
                    return true;
                }
                if (s.getArriveLocation() == null || !"SIP".equalsIgnoreCase((String)(arrLoc = (GeoLocation)DictionaryCache.get().resolveReference(s.getArriveLocation())).getCodeVariants().get(CodeSystem.IATA.name()))) continue;
                return true;
            }
        }
        return false;
    }

    public BaseSalesReportTicket(AgencyMemoProduct agencyMemoProduct, List<Message> messages) throws Exception {
        this.creditCardValue = BigDecimal.ZERO;
        this.cashValue = BigDecimal.ZERO;
        this.conjunctions = new String[0];
        this.conjunctionScns = new String[0];
        this.transportationType = TransportationType.NONE;
        this.fops = new ArrayList<ProductFop>();
        this.taxes = new ArrayList<Tax>();
        this.vendorEquivalentCommission = BigDecimal.ZERO;
        this.reportTicketType = ReportTicketType.MEMO;
        this.ticketSeries = agencyMemoProduct.getAirlineCode();
        this.issueDate = agencyMemoProduct.getAcceptDate();
        this.ticketNumber = agencyMemoProduct.getSystemNumber();
        this.agencyMemoProductType = agencyMemoProduct.getType();
        this.baseFare = AgencyMemoProductHelper.calculateItemGroupsBaseAmount((Collection)agencyMemoProduct.getItemGroups());
        this.equivalentFare = AgencyMemoProductHelper.calculateItemGroupsEquivalentAmount((Collection)agencyMemoProduct.getItemGroups());
        this.fareRate = this.baseFare != null && this.baseFare.getValue() != null && this.equivalentFare != null ? this.equivalentFare.divide(this.baseFare.getValue(), 2, RoundingMode.HALF_UP) : BigDecimal.ONE;
        this.agencyMemoProductItemGroups.addAll(agencyMemoProduct.getItemGroups());
    }

    public String getValidatorCode() {
        return this.validatorCode;
    }

    public void setValidatorCode(String validatorCode) {
        this.validatorCode = validatorCode;
    }

    public String getCouponsList() {
        return this.couponsList;
    }

    private BigDecimal updateCommissionValue(BigDecimal currentValue, BigDecimal commissionValue) {
        if (commissionValue == null || BigDecimal.ZERO.compareTo(commissionValue) == 0) {
            return currentValue;
        }
        if (currentValue == null) {
            return commissionValue;
        }
        return currentValue.add(commissionValue);
    }

    private Money updateCommissionAmount(Money currentAmount, Money commissionAmount) {
        if (commissionAmount == null || commissionAmount.getValue() == null || commissionAmount.getCurrency() == null || BigDecimal.ZERO.compareTo(commissionAmount.getValue()) == 0) {
            return currentAmount;
        }
        if (currentAmount == null) {
            Money result = new Money();
            result.setCurrency(commissionAmount.getCurrency());
            result.setValue(commissionAmount.getValue());
            return result;
        }
        if (!currentAmount.getCurrency().equals(commissionAmount.getCurrency())) {
            return currentAmount;
        }
        currentAmount.setValue(currentAmount.getValue().add(commissionAmount.getValue()));
        return currentAmount;
    }

    protected Double updateCommissionRate(Double currentRate, Double commissionRate) {
        if (commissionRate == null || Math.abs(commissionRate) < 0.001) {
            return currentRate;
        }
        if (currentRate == null) {
            return commissionRate;
        }
        return Math.abs(currentRate) > Math.abs(commissionRate) ? currentRate : commissionRate;
    }

    private static <D extends BaseDictionary> String getCode(EntityReference<Organization> entityReference) {
        EntityContainer ctr;
        if (entityReference == null) {
            return null;
        }
        try {
            ctr = EntityStorage.get().resolve(entityReference);
        }
        catch (Exception e) {
            return null;
        }
        return ctr != null && ((Organization)ctr.getEntity()).getAirline() != null ? ((Organization)ctr.getEntity()).getAirline().getCode() : null;
    }

    public BigDecimal getVendorEquivalentCommission() {
        return this.vendorEquivalentCommission;
    }

    public void setVendorEquivalentCommission(BigDecimal value) {
        this.vendorEquivalentCommission = value;
    }

    public BigDecimal getFareRate() {
        return this.fareRate;
    }

    public String[] getConjunctions() {
        return this.conjunctions;
    }

    public String[] getConjunctionScns() {
        return this.conjunctionScns;
    }

    public String getCreditCardNo() {
        return this.creditCardNo;
    }

    public void setCreditCardNo(String value) {
        this.creditCardNo = value;
    }

    public BigDecimal getCreditCardValue() {
        return this.creditCardValue;
    }

    public void setCreditCardValue(BigDecimal value) {
        this.creditCardValue = value;
    }

    public void setPaymentCardVendor(CardVendor paymentCardVendor) {
        this.paymentCardVendor = paymentCardVendor;
    }

    public CardVendor getPaymentCardVendor() {
        return this.paymentCardVendor;
    }

    public void setPaymentCardSecurityCode(String paymentCardSecurityCode) {
        this.paymentCardSecurityCode = paymentCardSecurityCode;
    }

    public String getPaymentCardSecurityCode() {
        return this.paymentCardSecurityCode;
    }

    public BigDecimal getCashValue() {
        return this.cashValue;
    }

    public void addCashValue(BigDecimal value) {
        this.cashValue = this.cashValue.add(value);
    }

    public Collection<Tax> getTaxes() {
        return this.taxes;
    }

    public int getSegmentsNumber() {
        return this.segmentsNumber;
    }

    public void setPenalty(BigDecimal value) {
        this.penalty = value;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public TransportationType getTransportationType() {
        return this.transportationType;
    }

    public void setTransportationType(TransportationType transportationType) {
        this.transportationType = transportationType;
    }

    public Money getBaseFare() {
        return this.baseFare;
    }

    public void setBaseFare(Money value) {
        this.baseFare = value;
    }

    public BigDecimal getExchangeRate() {
        TransportationType trType = this.getTransportationType();
        if (TransportationType.DOMESTIC == trType) {
            return BigDecimal.ONE;
        }
        if (this.getBaseFare() == null || this.getEquivalentFare() == null) {
            return BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(this.getBaseFare().getValue()) == 0) {
            return BigDecimal.ZERO;
        }
        return this.getEquivalentFare().divide(this.getBaseFare().getValue(), 1);
    }

    public Collection<ProductFop> getFops() {
        return this.fops;
    }

    public Money getVendorCommissionValue() {
        return this.vendorCommissionValue;
    }

    public void setVendorCommissionValue(Money value) {
        this.vendorCommissionValue = value;
    }

    public Double getVendorCommissionRate() {
        return this.vendorCommissionRate;
    }

    public void setVendorCommissionRate(Double value) {
        this.vendorCommissionRate = value;
    }

    public BigDecimal getRoe() {
        return this.roe;
    }

    public void setRoe(BigDecimal value) {
        this.roe = value;
    }

    public void setFareRate(BigDecimal value) {
        this.fareRate = value;
    }

    @Override
    public void setTicketSeries(String value) {
        this.ticketSeries = value;
    }

    public int getCouponsCount() {
        return this.couponsCount;
    }

    public String getBlankOwnerCode() {
        return this.blankOwnerCode;
    }

    public void setBlankOwnerCode(String value) {
        this.blankOwnerCode = value;
    }

    public TariffType getTariffType() {
        return this.tariffType;
    }

    public void setTariffType(TariffType tariffType) {
        this.tariffType = tariffType;
    }

    public String getProfileCode() {
        return this.profileCode;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public void setEticketFlag(boolean value) {
        this.eticket = value;
    }

    public Date getRelatedProductIssueDate() {
        return this.relatedProductIssueDate;
    }

    public String getRelatedProductNumber() {
        return this.relatedProductNumber;
    }

    public BigDecimal getRelatedProductEquivalentFare() {
        return this.relatedProductEquivalentFare;
    }

    public Date getRelatedSellProductIssueDate() {
        return this.relatedSellProductIssueDate;
    }

    public String getRelatedSellProductNumber() {
        return this.relatedSellProductNumber;
    }

    public BigDecimal getRelatedSellProductEquivalentFare() {
        return this.relatedSellProductEquivalentFare;
    }

    public BlankCategory getBlankCategory() {
        return this.blankCategory;
    }

    public void setBlankCategory(BlankCategory value) {
        this.blankCategory = value;
    }

    public BigDecimal getVendorEquivalentFee() {
        return this.vendorEquivalentFee;
    }

    public Money getVendorFeeValue() {
        return this.vendorFeeValue;
    }

    public Double getVendorFeeRate() {
        return this.vendorFeeRate;
    }

    public BigDecimal getSubagencyEquivalentCommission() {
        return this.subagencyEquivalentCommission;
    }

    public Money getSubagencyCommissionValue() {
        return this.subagencyCommissionValue;
    }

    public Double getSubagencyCommissionRate() {
        return this.subagencyCommissionRate;
    }

    public BigDecimal getSubagencyEquivalentFee() {
        return this.subagencyEquivalentFee;
    }

    public Money getSubagencyFeeValue() {
        return this.subagencyFeeValue;
    }

    public Double getSubagencyFeeRate() {
        return this.subagencyFeeRate;
    }

    public BigDecimal getClientEquivalentDiscount() {
        return this.clientEquivalentDiscount;
    }

    public Money getClientDiscountValue() {
        return this.clientDiscountValue;
    }

    public Double getClientDiscountRate() {
        return this.clientDiscountRate;
    }

    public BigDecimal getClientEquivalentFee() {
        return this.clientEquivalentFee;
    }

    public Money getClientFeeValue() {
        return this.clientFeeValue;
    }

    public Double getClientFeeRate() {
        return this.clientFeeRate;
    }

    public BigDecimal getClientEquivalentCommission() {
        return this.clientEquivalentCommission;
    }

    public Money getClientCommissionValue() {
        return this.clientCommissionValue;
    }

    public Double getClientCommissionRate() {
        return this.clientFeeRate;
    }

    public BigDecimal getTotalEquivalentTaxFee() {
        BigDecimal result = BigDecimal.ZERO;
        for (Tax tax : this.taxes) {
            result = result.add(tax.getEquivalentAmount());
        }
        return result;
    }

    public String getFopsName() {
        StringBuilder sb = new StringBuilder();
        for (ProductFop fop : this.fops) {
            if (fop.getType() == null || fop.getType() == PaymentType.TICKET) continue;
            sb.append(fop.getType().name());
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public ReportTicketType getReportTicketType() {
        return this.reportTicketType;
    }

    public AgencyMemoProductType getAgencyMemoProductType() {
        return this.agencyMemoProductType;
    }

    public boolean isReportAssociatedAgencyMemoProduct() {
        return this.reportAssociatedAgencyMemoProduct;
    }

    public boolean isRouteContainCrimea() {
        return this.routeContainsCrimea;
    }

    public boolean isRouteContainsKaliningrad() {
        return this.routeContainsKaliningrad;
    }

    public boolean isRouteContainsCIS() {
        return this.routeContainsCIS;
    }

    public boolean isRouteContainsDVFO() {
        return this.routeContainsDVFO;
    }

    public Collection<AgencyMemoProductItemGroup> getAgencyMemoProductItemGroups() {
        return this.agencyMemoProductItemGroups;
    }

    public static enum ReportTicketType {
        PRODUCT,
        MEMO;

    }
}

