/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports;

import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesReportHelper {
    private static Logger log = LoggerFactory.getLogger(SalesReportHelper.class);

    public static boolean isHasFop(Collection<ProductFop> fops, PaymentType paymentType) {
        if (fops == null) {
            return false;
        }
        for (ProductFop fop : fops) {
            if (fop.getAmount() == null || fop.getAmount().getValue() == null || fop.getType() != paymentType) continue;
            return true;
        }
        return false;
    }

    public static String getEquivCurrency(List<Message> messages) {
        String prefEquiveCurrency = "";
        try {
            prefEquiveCurrency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
            return prefEquiveCurrency;
        }
        catch (Exception e) {
            log.error("failed getting equivalent currency, fall back to RUB", (Throwable)e);
            if (messages != null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_FailedWithEquvalentCurrency", (String)TextUtil.getExceptionStackTrace((Throwable)e), (MessageType)MessageType.WARNING, (Object[])new Object[]{prefEquiveCurrency});
            }
            return "RUB";
        }
    }

    public static String getCurrency(String currencyCode, List<Message> messages) {
        if (TextUtil.isBlank((String)currencyCode)) {
            return SalesReportHelper.getEquivCurrency(messages);
        }
        try {
            return currencyCode;
        }
        catch (Exception e) {
            log.error("failed getting currency " + currencyCode + ", fall back equivalent currency", (Throwable)e);
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_FailedWithCurrency", (String)TextUtil.getExceptionStackTrace((Throwable)e), (MessageType)MessageType.WARNING, (Object[])new Object[]{currencyCode});
            return SalesReportHelper.getEquivCurrency(messages);
        }
    }

    public static BigDecimal getCurrencyRate(String cur, BaseSalesReportTicket ticket, List<Message> messages) {
        String currencyCode;
        if (SalesReportHelper.getEquivCurrency(messages).equals(cur)) {
            return BigDecimal.ONE;
        }
        Date issueDate = ticket.getIssueDate();
        ProductStatus status = ticket.getStatus();
        String ticketNumber = ticket.getTicketNumber();
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            Date relatedProductIssueDate = ticket.getRelatedProductIssueDate();
            if (relatedProductIssueDate == null) {
                log.warn("Unable to get issue date for product related to " + ticketNumber + " with status Refund or Exchange. Issue date of product" + ticketNumber + " will be used for currency rate");
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_BadIssueDateOfRefund", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticketNumber});
            } else {
                issueDate = relatedProductIssueDate;
            }
        }
        if (issueDate == null) {
            log.warn("ticket " + ticketNumber + " does not have issue date. Current date wil be used");
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_BadIssueDate", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticketNumber});
            issueDate = new Date();
        }
        if ("XXX".equals(currencyCode = cur)) {
            BigDecimal roe = ticket.getRoe();
            if (roe != null) {
                return roe.multiply(ticket.getFareRate());
            }
            log.warn("ticket " + ticketNumber + " does not have ROE. Rate for EURO will be used");
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoROE", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticketNumber});
            currencyCode = "EUR";
        }
        try {
            CurrencyRate rate = BookingHelper.findCurrencyRate((String)currencyCode, (Date)issueDate, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)ticket.getTariffType(), ticket.getBlankOwner());
            if (rate != null) {
                return BigDecimal.valueOf(rate.getRate());
            }
        }
        catch (Exception e) {
            log.error("Error occured while getting IATA currency rate for " + currencyCode, (Throwable)e);
        }
        log.warn("Unable to find rate for currency " + currencyCode + " Rate = 1 will be used");
        SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoRate", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticketNumber, currencyCode});
        return BigDecimal.ONE;
    }

    public static BigDecimal getFopAmount(PaymentType paymentType, BaseSalesReportTicket ticket, List<Message> messages) {
        BigDecimal result = BigDecimal.ZERO;
        for (ProductFop fop : ticket.getFops()) {
            Money money;
            if (paymentType != null && fop.getType() != paymentType || (money = fop.getAmount()) == null) continue;
            BigDecimal value = money.getValue();
            String currency = money.getCurrency();
            if (value == null || currency == null) continue;
            result = result.add(value.multiply(SalesReportHelper.getCurrencyRate(currency, ticket, messages)));
        }
        return result;
    }

    public static BigDecimal getEquivalentFare(Money fare, BaseSalesReportTicket ticket, List<Message> messages) {
        String cur;
        if (fare == null || fare.getValue() == null) {
            return BigDecimal.ZERO;
        }
        if (ticket.getIssueDate() == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_BadIssueDate", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticket.getTicketNumber()});
        }
        if ((cur = fare.getCurrency()) == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoSegmentCurrency", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticket.getTicketNumber()});
            cur = SalesReportHelper.getEquivCurrency(messages);
        }
        return fare.getValue().multiply(SalesReportHelper.getCurrencyRate(cur, ticket, messages));
    }

    public static String getColumnSumFormula(String column, int startRow, int endRow) {
        return String.format("SUM(%1$s%2$d:%1$s%3$d)", column, startRow, endRow);
    }

    public static <T extends BaseReportTicket> Map<String, List<T>> splitTicketsByProductCategory(Collection<T> data) {
        if (data == null) {
            return null;
        }
        HashMap<String, List<T>> result = new HashMap<String, List<T>>();
        for (BaseReportTicket ticket : data) {
            ArrayList<BaseReportTicket> list = (ArrayList<BaseReportTicket>)result.get(ticket.getProductCategory().name());
            if (list == null) {
                list = new ArrayList<BaseReportTicket>();
                result.put(ticket.getProductCategory().name(), list);
            }
            list.add(ticket);
        }
        return result;
    }

    public static List<Tax> calculateTaxesDifference(Collection<Tax> curTaxes, Collection<Tax> prevTaxes) {
        ArrayList<Tax> taxes = new ArrayList<Tax>();
        Map<String, List<Tax>> sellTaxBatches = curTaxes.stream().collect(Collectors.groupingBy(item -> item.getCode()));
        Map<String, List<Tax>> exchangeTaxBatches = prevTaxes.stream().collect(Collectors.groupingBy(item -> item.getCode()));
        for (String code : sellTaxBatches.keySet()) {
            List sellTaxes = sellTaxBatches.get(code) != null ? sellTaxBatches.get(code) : Collections.emptyList();
            List exchangeTaxes = exchangeTaxBatches.get(code) != null ? exchangeTaxBatches.get(code) : Collections.emptyList();
            BigDecimal sellEquivalentAmount = sellTaxes.stream().reduce(null, (value, item) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{value, item.getEquivalentAmount()}), (item1, item2) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{item1, item2}));
            BigDecimal sellBaseAmount = sellTaxes.stream().reduce(null, (value, item) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{value, item.getAmount() != null ? item.getAmount().getValue() : null}), (item1, item2) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{item1, item2}));
            BigDecimal exchangeEquivalentAmount = exchangeTaxes.stream().reduce(null, (value, item) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{value, item.getEquivalentAmount()}), (item1, item2) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{item1, item2}));
            BigDecimal exchangeBaseAmount = exchangeTaxes.stream().reduce(null, (value, item) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{value, item.getAmount() != null ? item.getAmount().getValue() : null}), (item1, item2) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{item1, item2}));
            BigDecimal equivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{sellEquivalentAmount, MiscUtil.negate((BigDecimal)exchangeEquivalentAmount)});
            BigDecimal baseAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{sellBaseAmount, MiscUtil.negate((BigDecimal)exchangeBaseAmount)});
            if (equivalentAmount == null || equivalentAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            try {
                Tax tax = (Tax)XCloneHelper.clone((XCloneable)((XCloneable)sellTaxes.get(0)));
                tax.setEquivalentAmount(equivalentAmount);
                if (tax.getAmount() != null) {
                    tax.getAmount().setValue(baseAmount);
                }
                taxes.add(tax);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return taxes;
    }
}

