/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.bsp;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.LHBSPReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.bsp.LHBSPSheetHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LHBSPSalesReportRenderHandler
extends BasePoiReportRenderHandler<LHBSPReportTicket> {
    @Override
    protected List<PoiWorksheetData<LHBSPReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<LHBSPReportTicket>> result = new ArrayList<PoiWorksheetData<LHBSPReportTicket>>();
        result.add(new BaseWorksheetData<LHBSPReportTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.REPORT.getWorksheetTemplateName();
            }

            @Override
            public PoiWorksheetDefinition<LHBSPReportTicket> getDefinition() {
                return Definitions.REPORT;
            }

            @Override
            public int getProirity() {
                return 0;
            }
        });
        return result;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        StringBuilder sb = new StringBuilder();
        sb.append(params.getPeriodBegin() != null ? sdf.format(params.getPeriodBegin()) : "null");
        sb.append("-");
        sdf = new SimpleDateFormat("dd.MM.yyyy");
        sb.append(params.getPeriodEnd() != null ? sdf.format(params.getPeriodEnd()) : "null");
        return L10nResourcesManager.createL10nMessage((String)Messages.LHBSPSalesReportRenderHandler_reportTitle, (Object[])new Object[]{sb.toString()}).toString();
    }

    @Override
    public String getId() {
        return "lh-bsp-sales-report";
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(ReportDocument.class);
        ((ReportDocument)result.getEntity()).getFiles().add(file);
        ((ReportDocument)result.getEntity()).setReportType(ReportType.VENDOR);
        List messages = (List)data.get("key-messages");
        ((ReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((ReportDocument)result.getEntity()).setParameters((ReportParameters)data.get("key-report-params"));
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        byte[] template = (byte[])data.get("KEY_TEMPLATE_DATA");
        if (template == null || template.length == 0) {
            throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.LHBSPSalesReportRenderHandler_unableToLoadTemplate, (Object[])new Object[0]).toString());
        }
        return new ByteArrayInputStream(template);
    }

    public static enum Definitions implements PoiWorksheetDefinition<LHBSPReportTicket>
    {
        REPORT{

            @Override
            public PoiWorksheetHandler<LHBSPReportTicket> getHandler() {
                return new LHBSPSheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "Report";
            }
        };


        @Override
        public abstract String getWorksheetTemplateName();

        @Override
        public abstract PoiWorksheetHandler<LHBSPReportTicket> getHandler();
    }
}

