/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.DivergenceSegmentsReportTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SegmentsDivergencePoiWorksheetHandler
extends BasePoiWorksheetHandler<DivergenceSegmentsReportTicket> {
    private static final int START_ROW_INDEX = 9;
    private static final int ROW_SHIFT_AMOUNT = 7;
    private static final int COLUMN_AMOUNT = 18;
    private HSSFSheet currentSheet;
    private int currentRow;

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<DivergenceSegmentsReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"key-tch-agency-code", (String)((String)globalData.get("key-tch-agency-code")));
        this.currentSheet = sheet;
        this.currentSheet.setForceFormulaRecalculation(true);
        this.currentRow = 9;
        List<DivergenceSegmentsReportTicket> tickets = data.getTickets();
        if (!tickets.isEmpty()) {
            for (int n = 0; n < tickets.size(); ++n) {
                DivergenceSegmentsReportTicket ticket = tickets.get(n);
                this.addRow(ticket, n != 0);
            }
        }
    }

    private void addRow(DivergenceSegmentsReportTicket ticket, boolean insertRow) throws Exception {
        if (insertRow) {
            ExcelUtils.insertRow((HSSFSheet)this.currentSheet, (int)(this.currentRow - 1), (int)18, (int)7);
        }
        for (Column column : Column.values()) {
            this.setFieldValue(ticket, column);
        }
        ++this.currentRow;
    }

    private void setFieldValue(DivergenceSegmentsReportTicket ticket, Column column) throws Exception {
        switch (column) {
            case DATA_CODE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getDatacode());
                break;
            }
            case ERR_CODE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getErrcode());
                break;
            }
            case BLANC_CODE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getBlankTypeCode());
                break;
            }
            case TICKET_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketNumber());
                break;
            }
            case TRANSFER_NUM: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTransferNum());
                break;
            }
            case TRANSACTION_TYPE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTransactionType());
                break;
            }
            case PART_NUM: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getPartNum());
                break;
            }
            case PACK_NUM: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getPackNum());
                break;
            }
            case ABC_DATE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (Date)ticket.getAbcPeriod());
                break;
            }
            case TICKETING_AIRLINE_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getValidatingAirlineNumber());
                break;
            }
            case SEGMENT_AIRLINE_CODE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getSegmentAirlineCode());
                break;
            }
            case TARIFF: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getEquivalentFare());
                break;
            }
            case PENALTY: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getPenalty());
                break;
            }
            case TAX_AGS: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getAgsTax());
                break;
            }
            case TAX_TCH: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getTchTax());
                break;
            }
            case COMMISSION_RATE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), ticket.getCommissionRate() != null ? BigDecimal.valueOf(ticket.getCommissionRate()) : null);
                break;
            }
            case COMMISSION_AMOUNT: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), ticket.getCommissionAmount() != null ? BigDecimal.valueOf(ticket.getCommissionAmount().doubleValue()) : null);
                break;
            }
            case PAYMENT_TYPE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)(ticket.getPaymentType() != null ? ticket.getPaymentType().toString() : (String)null));
                break;
            }
        }
    }

    private static enum Column {
        DATA_CODE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.A;
            }
        }
        ,
        ERR_CODE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.B;
            }
        }
        ,
        BLANC_CODE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.C;
            }
        }
        ,
        TICKET_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.D;
            }
        }
        ,
        TRANSFER_NUM{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.E;
            }
        }
        ,
        TRANSACTION_TYPE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.F;
            }
        }
        ,
        PART_NUM{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.G;
            }
        }
        ,
        PACK_NUM{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.H;
            }
        }
        ,
        ABC_DATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.I;
            }
        }
        ,
        PAYMENT_TYPE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.J;
            }
        }
        ,
        TICKETING_AIRLINE_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.K;
            }
        }
        ,
        SEGMENT_AIRLINE_CODE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.L;
            }
        }
        ,
        TARIFF{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.M;
            }
        }
        ,
        PENALTY{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.N;
            }
        }
        ,
        TAX_AGS{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.O;
            }
        }
        ,
        TAX_TCH{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.P;
            }
        }
        ,
        COMMISSION_RATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.Q;
            }
        }
        ,
        COMMISSION_AMOUNT{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.R;
            }
        };


        public abstract ExcelColumn getExcelColumn();
    }
}

