/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.divergence.ret;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocument;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.common.BaseSsodDivergenceTicketWrapper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RetDivergenceTicketWrapper
extends BaseSsodDivergenceTicketWrapper<RetArchiveExchangeDocument> {
    private static final long serialVersionUID = 5827890342583091774L;

    public RetDivergenceTicketWrapper(Product ticket, boolean conj, String systemNumber, List<Message> messages) {
        super(ticket, conj, systemNumber, messages);
        if (this.getItemType() == BaseSsodDivergenceTicketWrapper.ItemType.EXCHANGE) {
            this.updateFares(ticket);
        }
        this.updatePenalty();
    }

    public RetDivergenceTicketWrapper(RetArchiveExchangeDocument document, List<Message> messages) {
        super(document, messages);
    }

    @Override
    public boolean isEqualsByEquivalentFare(BaseSsodDivergenceTicketWrapper<RetArchiveExchangeDocument> other) {
        if (super.isEqualsByEquivalentFare(other)) {
            return true;
        }
        return this.getItemType() == BaseSsodDivergenceTicketWrapper.ItemType.EXCHANGE && (this.isFromRet() && MiscUtil.isZero((BigDecimal)this.equivalentFare, (boolean)true) || other.isFromRet() && MiscUtil.isZero((BigDecimal)other.getEquivalentFare(), (boolean)true));
    }

    @Override
    public boolean isEqualsByTaxes(BaseSsodDivergenceTicketWrapper<RetArchiveExchangeDocument> other) {
        if (super.isEqualsByTaxes(other)) {
            return true;
        }
        List<Tax> taxes = this.getNotNullTaxes(this.getTaxes());
        List<Tax> otherTaxes = this.getNotNullTaxes(other.getTaxes());
        return this.isEquals(taxes, otherTaxes);
    }

    @Override
    public boolean isEqualsByTravellerName(BaseSsodDivergenceTicketWrapper<RetArchiveExchangeDocument> other) {
        boolean isVoidItemType;
        boolean bl = isVoidItemType = this.getItemType() == BaseSsodDivergenceTicketWrapper.ItemType.VOID;
        if (TextUtil.isBlank((String)other.getTravellerName()) || TextUtil.isBlank((String)this.getTravellerName())) {
            return isVoidItemType || MiscUtil.equals((Object)other.getTravellerName(), (Object)this.getTravellerName());
        }
        if (other.getTravellerName().length() > this.getTravellerName().length()) {
            return isVoidItemType || other.getTravellerName().contains(this.getTravellerName());
        }
        if (other.getTravellerName().length() < this.getTravellerName().length()) {
            return isVoidItemType || this.getTravellerName().contains(other.getTravellerName());
        }
        return isVoidItemType || MiscUtil.equals((Object)other.getTravellerName(), (Object)this.getTravellerName());
    }

    private List<Tax> getNotNullTaxes(List<Tax> taxes) {
        ArrayList<Tax> result = new ArrayList<Tax>(taxes);
        CollectionUtil.filter(result, (ObjectFilter)new ObjectFilter<Tax>(){

            public boolean accept(Tax object) {
                return object.getEquivalentAmount() != null && BigDecimal.ZERO.compareTo(object.getEquivalentAmount()) != 0;
            }
        });
        return result;
    }

    private void updateFares(Product ticket) {
        this.baseFare = this.calculateBaseFare(ticket);
        this.equivalentFare = this.calculateEquivalentFare(ticket);
    }

    private void updatePenalty() {
        List<Tax> taxes = this.getTaxes();
        Iterator<Tax> it = taxes.iterator();
        while (it.hasNext()) {
            Tax tax = it.next();
            if (!AirProductHelper.isPenaltyTax(null, (String)tax.getCode())) continue;
            it.remove();
            this.penalty = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.penalty, tax.getEquivalentAmount()});
        }
    }

    @Override
    protected String getTravellerName(String prodTravellerName) {
        String name = super.getTravellerName(prodTravellerName);
        return !TextUtil.isBlank((String)name) && TextUtil.isCyrillic((String)name, (boolean)false) ? TextUtil.translit((String)name, (boolean)false) : name;
    }
}

