/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.fv;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class FVRegistryRegisterWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    private static String[] carrierTaxes = new String[]{"YQ"};

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        ArrayList tickets = (ArrayList)data.getTickets();
        if (tickets.isEmpty()) {
            return;
        }
        int lineNumber = 2;
        sheet.shiftRows(lineNumber - 1, lineNumber + 3, tickets.size());
        for (BaseSalesReportTicket tkt : tickets) {
            SuTicket ticket = (SuTicket)tkt;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)1, (int)(lineNumber - 1));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)2, (int)ticket.getBatchNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)3, (String)ticket.getBatchType());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)4, (int)ticket.getTransactionNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)5, (String)(ticket.getTicketSeries() + " " + ticket.getTicketNumber()));
            if (ticket.getConjCount() > 0) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)6, (String)"\u0414\u0410");
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)7, (String)ticket.getTransactionCode());
            if (ticket.isVatIncluded()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)8, (String)"\u0414\u0410");
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)8, (String)"\u041d\u0415\u0422");
            }
            BigDecimal equivalentFare = BigDecimal.ZERO;
            BigDecimal commRate = BigDecimal.ZERO;
            BigDecimal comm = BigDecimal.ZERO;
            BigDecimal taxEqu = BigDecimal.ZERO;
            BigDecimal taxOther = BigDecimal.ZERO;
            equivalentFare = ticket.getEquivalentFare();
            if (ticket.getVendorCommissionRate() != null) {
                commRate = BigDecimal.valueOf(ticket.getVendorCommissionRate());
            }
            comm = ticket.getVendorEquivalentCommission();
            double equivalentTax = ticket.getTaxEquivAmountByCodes(carrierTaxes);
            double taxAmount = ticket.getTaxAmount() - equivalentTax;
            taxEqu = BigDecimal.valueOf(equivalentTax);
            taxOther = BigDecimal.valueOf(taxAmount);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)9, (BigDecimal)equivalentFare);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)10, (BigDecimal)commRate);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)11, (BigDecimal)comm);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)12, (BigDecimal)taxEqu);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)13, (BigDecimal)taxOther);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)14, (String)ticket.getFopCodes());
            if (ticket.isEticket()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)15, (String)"E");
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)15, (String)ticket.getScn());
            }
            ++lineNumber;
        }
        sheet.autoSizeColumn(4);
        sheet.autoSizeColumn(14);
    }
}

