/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.fv;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.fv.FvRegistryLetterItem;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class FvRegistryPismoWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.updateGlobalData(sheet, globalData);
        this.updateGlobalDataFv(sheet, globalData);
        sheet.setForceFormulaRecalculation(true);
        TreeMap items = (TreeMap)globalData.get("key-registry-letters-data");
        String psSell = ProductStatus.SELL.name();
        this.updateLine(sheet, 17, items, TransportationType.INTERNATIONAL.name() + psSell + FvRegistryLetterItem.FieldDefinition.Fare.name());
        this.updateLine(sheet, 18, items, TransportationType.INTERNATIONAL.name() + psSell + FvRegistryLetterItem.FieldDefinition.YqTax.name());
        this.updateLine(sheet, 19, items, TransportationType.INTERNATIONAL.name() + psSell + FvRegistryLetterItem.FieldDefinition.OtherTax.name());
        this.updateLine(sheet, 21, items, TransportationType.DOMESTIC.name() + psSell + FvRegistryLetterItem.FieldDefinition.Fare.name());
        this.updateLine(sheet, 22, items, TransportationType.DOMESTIC.name() + psSell + FvRegistryLetterItem.FieldDefinition.YqTax.name());
        this.updateLine(sheet, 23, items, TransportationType.DOMESTIC.name() + psSell + FvRegistryLetterItem.FieldDefinition.OtherTax.name());
        this.updateLine(sheet, 27, items, TransportationType.DOMESTIC.name() + psSell + FvRegistryLetterItem.FieldDefinition.Penalty.name());
    }

    private void updateGlobalDataFv(HSSFSheet sheet, Map<String, Object> data) {
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)((String)data.get("CONTRACT_NO")));
        Date contractDate = (Date)data.get("CONTRACT_ISSUE_DATE");
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_ISSUE_DATE", contractDate != null ? this.df.format(contractDate) : null);
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)((String)data.get("REPORT_PERIOD")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_EMAIL", (String)((String)data.get("AGENCY_EMAIL")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DIRECTOR", (String)((String)data.get("DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"ACCOUNTANT", (String)((String)data.get("ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_PHONE", (String)((String)data.get("AGENCY_PHONE")));
    }

    private void updateLine(HSSFSheet sheet, int lineNo, Map<String, FvRegistryLetterItem> items, String key) throws Exception {
        if (items == null) {
            return;
        }
        FvRegistryLetterItem item = items.get(key);
        if (item == null) {
            return;
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNo, (int)1, (int)1, (int)3, (BigDecimal)BigDecimal.valueOf(item.sum));
    }
}

