/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.hy;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.BaseHyReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HySalesReportTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class HyExcessBagageSalesRegistryReportWorksheetHandler
extends BaseHyReportWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<HySalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        if (data.getTickets().isEmpty()) {
            return;
        }
        int startRow = 11;
        int endRow = 17;
        int rowCounter = 0;
        if (data.getTickets().size() > 1) {
            sheet.shiftRows(startRow - 1, endRow - 1, data.getTickets().size() - 1);
        }
        HSSFCellStyle cellStyle = this.createCellStyle(wb);
        HSSFCellStyle dateCellStyle = this.createDateCellStyle(wb);
        int currentRow = startRow;
        for (HySalesReportTicket ticket : data.getTickets()) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)1, (int)(++rowCounter));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (String)ticket.getBlankOwnerCode());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (Date)ticket.getIssueDate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (BigDecimal)ticket.getLuggageWeight());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (String)(ticket.getBaseFare() != null && ticket.getBaseFare().getCurrency() != null ? ticket.getBaseFare().getCurrency() : ""));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (Double)ticket.getRate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)12, (Double)ticket.getLuggageTariff());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)13, (BigDecimal)ticket.getEquivalentFare());
            if (ticket.getCommission() != null) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)15, (Double)ticket.getCommission().getRate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)16, (BigDecimal)ticket.getCommission().getEquivalentAmount());
            }
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)17, (String)String.format("=M%1$s-P%1$s", currentRow));
            this.formatRow(sheet, currentRow, cellStyle, dateCellStyle);
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)13, (String)String.format("=SUM(M%s:M%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)16, (String)String.format("=SUM(P%s:P%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)17, (String)String.format("=SUM(Q%s:Q%s)", startRow, endRow));
    }

    private void formatRow(HSSFSheet sheet, int currentRow, HSSFCellStyle cellStyle, HSSFCellStyle dateCellStyle) {
        HSSFRow row = sheet.getRow(currentRow - 1);
        block3: for (int i = 0; i < 17; ++i) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) {
                cell = row.createCell(i);
            }
            switch (i) {
                case 4: {
                    cell.setCellStyle(dateCellStyle);
                    continue block3;
                }
                default: {
                    cell.setCellStyle(cellStyle);
                }
            }
        }
    }
}

