/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.hy;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HyExcessBagageSalesRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HyMcoSalesRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HySalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HySalesSummaryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HyTicketPartiallyRefundRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HyTicketRefundRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HyTicketSalesRegistryReportWorksheetHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HySalesReportRenderHandler
extends BasePoiReportRenderHandler<HySalesReportTicket> {
    @Override
    public String getId() {
        return "hy-sales-report";
    }

    @Override
    protected List<PoiWorksheetData<HySalesReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<HySalesReportTicket>> result = new ArrayList<PoiWorksheetData<HySalesReportTicket>>();
        result.add(new BaseWorksheetData<HySalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "SUMMARY_INFO";
            }

            @Override
            public PoiWorksheetDefinition<HySalesReportTicket> getDefinition() {
                return Definitions.SUMMARY;
            }

            @Override
            public int getProirity() {
                return 0;
            }
        });
        result.add(new BaseWorksheetData<HySalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "SALE";
            }

            @Override
            public PoiWorksheetDefinition<HySalesReportTicket> getDefinition() {
                return Definitions.SELL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<HySalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "REFUND";
            }

            @Override
            public PoiWorksheetDefinition<HySalesReportTicket> getDefinition() {
                return Definitions.REFUND;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        result.add(new BaseWorksheetData<HySalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "PARTIAL_REFUND";
            }

            @Override
            public PoiWorksheetDefinition<HySalesReportTicket> getDefinition() {
                return Definitions.PARTIALLY_REFUND;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<HySalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "EXCESS_BAGAGE";
            }

            @Override
            public PoiWorksheetDefinition<HySalesReportTicket> getDefinition() {
                return Definitions.EXCESS_BAGAGE;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<HySalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MCO_REFUND";
            }

            @Override
            public PoiWorksheetDefinition<HySalesReportTicket> getDefinition() {
                return Definitions.MCO;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        return result;
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(ReportDocument.class);
        ((ReportDocument)result.getEntity()).getFiles().add(file);
        ((ReportDocument)result.getEntity()).setReportType(ReportType.VENDOR);
        List messages = (List)data.get("key-messages");
        ((ReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((ReportDocument)result.getEntity()).setParameters((ReportParameters)data.get("key-report-params"));
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        return IoUtil.getResourceInputStream((URL)BasePoiSalesReportRenderHandler.class.getResource("/salesreports/HySalesReport.xls"));
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.HySalesReportRenderHandler_reportTitle, (Object[])new Object[]{data.get("AGENCY_NAME"), data.get("KEY_REPORT_FILENAME")}).toString();
    }

    public static enum Definitions implements PoiWorksheetDefinition<HySalesReportTicket>
    {
        SUMMARY{

            @Override
            public PoiWorksheetHandler<HySalesReportTicket> getHandler() {
                return new HySalesSummaryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.HySalesReportRenderHandler_summary, (Object[])new Object[0]).toString();
            }
        }
        ,
        SELL{

            @Override
            public PoiWorksheetHandler<HySalesReportTicket> getHandler() {
                return new HyTicketSalesRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.HySalesReportRenderHandler_sell, (Object[])new Object[0]).toString();
            }
        }
        ,
        REFUND{

            @Override
            public PoiWorksheetHandler<HySalesReportTicket> getHandler() {
                return new HyTicketRefundRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.HySalesReportRenderHandler_refund, (Object[])new Object[0]).toString();
            }
        }
        ,
        PARTIALLY_REFUND{

            @Override
            public PoiWorksheetHandler<HySalesReportTicket> getHandler() {
                return new HyTicketPartiallyRefundRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.HySalesReportRenderHandler_partRefund, (Object[])new Object[0]).toString();
            }
        }
        ,
        EXCESS_BAGAGE{

            @Override
            public PoiWorksheetHandler<HySalesReportTicket> getHandler() {
                return new HyExcessBagageSalesRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.HySalesReportRenderHandler_baggage, (Object[])new Object[0]).toString();
            }
        }
        ,
        MCO{

            @Override
            public PoiWorksheetHandler<HySalesReportTicket> getHandler() {
                return new HyMcoSalesRegistryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.HySalesReportRenderHandler_mco, (Object[])new Object[0]).toString();
            }
        };

    }
}

