/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.hy;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class HySalesReportTicket
extends BaseReportTicket {
    private Money baseFare = null;
    private double rate = 0.0;
    private String route = null;
    private Commission commission = null;
    private BigDecimal fees = BigDecimal.ZERO;
    private BigDecimal feesUsed = BigDecimal.ZERO;
    private BigDecimal eqFareUsed = BigDecimal.ZERO;
    private BigDecimal penalty = BigDecimal.ZERO;
    private String penaltyMcoNumber = null;
    private BigDecimal luggageWeight = null;
    private double luggageTariff = 0.0;
    private String blankOwnerCode = null;
    private boolean duplicate = false;
    private ProductStatus status = null;
    private final List<String> fareBasises = new ArrayList<String>();
    private final List<String> classOfSvcCodes = new ArrayList<String>();
    private final Product product;
    private static int ROUNDING_SCALE = 2;
    private static final long serialVersionUID = -3254657649204276389L;

    public HySalesReportTicket(Product aProduct, List<Message> messages) throws Exception {
        super(aProduct, messages);
        this.product = aProduct;
        this.baseFare = AirProductHelper.getBaseFare((Product)aProduct);
        this.rate = AirProductHelper.calculateFareRate((Product)this.product).doubleValue();
        this.route = AirProductHelper.getRouteLine((Product)aProduct);
        this.blankOwnerCode = ((Organization)EntityStorage.get().resolve(this.getBlankOwner()).getEntity()).getCode();
        if (this.product.getStatus() != ProductStatus.VOID) {
            Iterator iterator = AirProductHelper.getUnmodifiableCommissions((Product)this.product, (ContractType)ContractType.VENDOR).iterator();
            while (iterator.hasNext()) {
                Commission aCommission;
                this.commission = aCommission = (Commission)iterator.next();
            }
            for (Object tax : this.product.getTaxes()) {
                if (tax.getEquivalentAmount() == null) continue;
                this.fees = this.fees.add(tax.getEquivalentAmount());
            }
        }
        if (aProduct.getProductCategory() == ProductCategory.AIR && aProduct.getStatus() == ProductStatus.REFUND) {
            this.penalty = this.product.getPenalty();
            if (this.penalty != null && this.penalty.equals(BigDecimal.ZERO)) {
                Collection mcos = AirProductHelper.getMcoByRelatedProduct((Product)this.product);
                for (Product mco : mcos) {
                    if (mco.getMcoCategory() != MCOCategory.PENALTY) continue;
                    this.penalty = AirProductHelper.getBaseFare((Product)mco).getValue();
                    this.penaltyMcoNumber = mco.getSystemNumber();
                }
            }
        }
        if (this.product.getProductCategory() == ProductCategory.EXCESS_BAGAGE) {
            this.luggageWeight = this.product.getLuggageWeight() != null ? new BigDecimal(this.product.getLuggageWeight()) : BigDecimal.ZERO;
            this.luggageTariff = MiscUtil.isZero((BigDecimal)this.luggageWeight, (boolean)true) ? 0.0 : this.baseFare.getValue().divide(this.luggageWeight, ROUNDING_SCALE, 0).doubleValue();
        }
        this.duplicate = this.product.isDuplicate();
        this.status = this.product.getStatus();
        if (this.product.getPreviousProduct() != null && this.product.getStatus() == ProductStatus.REFUND) {
            BigDecimal prevEqFare;
            BigDecimal bigDecimal = prevEqFare = this.product.getPreviousProduct().getStatus() != ProductStatus.VOID ? AirProductHelper.getEquivalentFare((Product)this.product.getPreviousProduct()) : BigDecimal.ZERO;
            if (prevEqFare != null && prevEqFare.compareTo(this.equivalentFare) > 0) {
                this.eqFareUsed = prevEqFare.subtract(this.equivalentFare);
            }
            BigDecimal prevFees = BigDecimal.ZERO;
            for (Tax tax : this.product.getPreviousProduct().getTaxes()) {
                if (tax.getEquivalentAmount() == null) continue;
                prevFees = prevFees.add(tax.getEquivalentAmount());
            }
            if (prevFees != null && this.fees != null && prevFees.compareTo(this.fees) > 0) {
                this.feesUsed = prevFees.subtract(this.fees);
            }
        }
        for (SegmentTariff segmentTariff : this.product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (!TextUtil.isBlank((String)segment.getClassOfSvcCode()) && !this.classOfSvcCodes.contains(segment.getClassOfSvcCode())) {
                    this.classOfSvcCodes.add(segment.getClassOfSvcCode());
                }
                if (TextUtil.isBlank((String)segment.getFareBasis()) || this.fareBasises.contains(segment.getFareBasis())) continue;
                this.fareBasises.add(segment.getFareBasis());
            }
        }
    }

    public List<String> getFareBasises() {
        return this.fareBasises;
    }

    public List<String> getClassOfSvcCodes() {
        return this.classOfSvcCodes;
    }

    public Money getBaseFare() {
        return this.baseFare;
    }

    public boolean isPartiallyRefund() {
        boolean result = false;
        if (this.product.getStatus() == ProductStatus.REFUND) {
            result = this.baseFare.getValue().compareTo(AirProductHelper.getBaseFare((Product)this.product.getPreviousProduct()).getValue()) != 0;
        }
        return result;
    }

    public String getRoute() {
        return this.route;
    }

    public double getRate() {
        return this.rate;
    }

    public Commission getCommission() {
        return this.commission;
    }

    public BigDecimal getFee() {
        return this.fees;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public String getPenaltyMcoNumber() {
        return this.penaltyMcoNumber;
    }

    public BigDecimal getLuggageWeight() {
        return this.luggageWeight;
    }

    public double getLuggageTariff() {
        return this.luggageTariff;
    }

    public String getBlankOwnerCode() {
        return this.blankOwnerCode;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public boolean isVoidTicket() {
        return this.status == ProductStatus.VOID;
    }

    public BigDecimal getEqFareUsed() {
        return this.eqFareUsed;
    }

    public BigDecimal getFeesUsed() {
        return this.feesUsed;
    }
}

