/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.hy;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.BaseHyReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.hy.HySalesReportTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class HyTicketPartiallyRefundRegistryReportWorksheetHandler
extends BaseHyReportWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<HySalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        if (data.getTickets().isEmpty()) {
            return;
        }
        int startRow = 12;
        int endRow = 18;
        int rowCounter = 0;
        if (data.getTickets().size() > 1) {
            sheet.shiftRows(startRow - 1, endRow - 1, data.getTickets().size() - 1);
        }
        HSSFCellStyle cellStyle = this.createCellStyle(wb);
        int currentRow = startRow;
        for (HySalesReportTicket ticket : data.getTickets()) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)1, (int)(++rowCounter));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)ticket.getRoute());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (BigDecimal)ticket.getEqFareUsed());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (BigDecimal)ticket.getEquivalentFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (BigDecimal)ticket.getFeesUsed());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (BigDecimal)ticket.getFee());
            if (TextUtil.isBlank((String)ticket.getPenaltyMcoNumber())) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (BigDecimal)ticket.getPenalty());
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (BigDecimal)ticket.getPenalty());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)12, (String)ticket.getPenaltyMcoNumber());
            }
            if (ticket.getCommission() != null) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (Double)ticket.getCommission().getRate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (BigDecimal)ticket.getCommission().getEquivalentAmount());
            }
            this.formatRow(sheet, currentRow, cellStyle);
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (String)String.format("=SUM(D%s:D%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (String)String.format("=SUM(E%s:E%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (String)String.format("=SUM(F%s:F%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (String)String.format("=SUM(G%s:G%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (String)String.format("=SUM(I%s:I%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)String.format("=SUM(J%s:J%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (String)String.format("=SUM(K%s:K%s)", startRow, endRow));
    }

    private void formatRow(HSSFSheet sheet, int currentRow, HSSFCellStyle cellStyle) {
        HSSFRow row = sheet.getRow(currentRow - 1);
        for (int i = 0; i < 12; ++i) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) {
                cell = row.createCell(i);
            }
            cell.setCellStyle(cellStyle);
        }
    }
}

