/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.kv;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.BaseKVReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.kv.KVSalesReportTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class KVTicketSalesRegistryReportWorksheetHandler
extends BaseKVReportWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<KVSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        if (data.getTickets().isEmpty()) {
            return;
        }
        int startRow = 18;
        int endRow = 27;
        int rowCounter = 0;
        if (data.getTickets().size() > 1) {
            sheet.shiftRows(startRow - 1, endRow - 1, data.getTickets().size() - 1);
        }
        int currentRow = startRow;
        HSSFCellStyle cellStyle = this.createCellStyle(wb);
        HSSFCellStyle dateCellStyle = this.createDateCellStyle(wb);
        for (KVSalesReportTicket ticket : data.getTickets()) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)1, (int)(++rowCounter));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (String)ticket.getBlankOwnerCode());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)ticket.getTicketNumber());
            if (!ticket.isVoidTicket()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (Date)ticket.getIssueDate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (Date)ticket.getFlightDate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (String)ticket.getRoute());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (String)ticket.getValidatorCode());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (BigDecimal)ticket.getEquivalentFare());
                if (ticket.getCommission() != null) {
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (Double)ticket.getCommission().getRate());
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (BigDecimal)ticket.getCommission().getEquivalentAmount());
                }
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (String)String.format("=H%1$s-J%1$s", currentRow));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)12, (BigDecimal)ticket.getAirlineFee());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)13, (BigDecimal)ticket.getFee());
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)14, (String)String.format("=K%1$s+L%1$s+M%1$s", currentRow));
            }
            this.formatRow(sheet, currentRow, cellStyle, dateCellStyle);
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (String)String.format("=SUM(H%s:H%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (String)String.format("=SUM(J%s:J%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)String.format("=SUM(K%s:K%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)String.format("=SUM(L%s:L%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)String.format("=SUM(M%s:M%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)14, (String)String.format("=SUM(N%s:N%s)", startRow, endRow));
    }

    private void formatRow(HSSFSheet sheet, int currentRow, HSSFCellStyle cellStyle, HSSFCellStyle dateCellStyle) {
        HSSFRow row = sheet.getRow(currentRow - 1);
        block3: for (int i = 0; i < 15; ++i) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) {
                cell = row.createCell(i);
            }
            switch (i) {
                case 3: 
                case 4: {
                    cell.setCellStyle(dateCellStyle);
                    continue block3;
                }
                default: {
                    cell.setCellStyle(cellStyle);
                }
            }
        }
    }
}

