/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.na;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.RenderHandlersRegistry;
import com.gridnine.xtrip.common.reports.render.ReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.xml.SuXmlReportRender;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class NaReportRenderHandler
implements ReportRenderHandler {
    @Override
    public String getId() {
        return "na-sales-report";
    }

    public EntityContainer<ReportDocument> renderReport(Map<String, Object> parameters) throws Exception {
        EntityContainer result = new EntityContainer(ReportDocument.class);
        ((ReportDocument)result.getEntity()).setParameters((ReportParameters)parameters.get("key-report-params"));
        parameters.put("KEY_REPORT_FILENAME", this.getReportFileName((ReportParameters)parameters.get("key-report-params")));
        if (parameters.get("key-batch-data-list") != null) {
            EntityContainer<ReportDocument> renderXmlReportDocContainer = new SuXmlReportRender().renderReport(parameters);
            ((ReportDocument)result.getEntity()).getMessages().addAll(((ReportDocument)renderXmlReportDocContainer.getEntity()).getMessages());
            ((ReportDocument)result.getEntity()).getFiles().addAll(((ReportDocument)renderXmlReportDocContainer.getEntity()).getFiles());
        }
        ((ReportDocument)result.getEntity()).getFiles().addAll(((ReportDocument)new NaSalesReportRenderHandler().renderReport(parameters).getEntity()).getFiles());
        Map stockControlData = (Map)parameters.get("key-stock-control-data");
        ((ReportDocument)result.getEntity()).getFiles().addAll(((ReportDocument)((RenderHandlersRegistry)Environment.getPublished(RenderHandlersRegistry.class)).get("na-stock-control-report").renderReport(stockControlData).getEntity()).getFiles());
        ((ReportDocument)result.getEntity()).setCreated(new Date());
        return result;
    }

    private String getReportFileName(ReportParameters reportParams) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("ddMMyyyy", new Locale("ru", "RU"));
        sb.append('_');
        sb.append(df.format(reportParams.getPeriodBegin()));
        sb.append('-');
        sb.append(df.format(reportParams.getPeriodEnd()));
        sb.append('_');
        sb.append("RUB");
        return sb.toString();
    }
}

