/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.na;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;

public abstract class NaSalesReportBaseWorksheetHandler
extends BasePoiWorksheetHandler<BaseSalesReportTicket> {
    protected static final int START_OF_RANGE = 19;
    protected static final int END_OF_RANGE = 22;
    private final Map<String, Integer> validators = new TreeMap<String, Integer>();

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        this.sortTickets(data.getTickets());
        this.createRows(sheet, data.getTickets());
    }

    protected void createRows(HSSFSheet sheet, List<BaseSalesReportTicket> tickets) throws Exception {
        int validatorsCount = this.getSize(tickets);
        for (int i = 0; i < validatorsCount - 1; ++i) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)19, (int)22);
        }
        this.addTotalFormulas(sheet, validatorsCount);
        int itemsCount = 0;
        int offset = 0;
        for (String validatorCode : this.validators.keySet()) {
            itemsCount = this.getItemsCount(validatorCode);
            if (itemsCount < 2) {
                sheet.removeRow((Row)sheet.getRow(22 + offset - 1));
                sheet.shiftRows(22 + offset, sheet.getLastRowNum(), -1, true, false);
                --offset;
            } else if (itemsCount > 2) {
                itemsCount -= 2;
                for (int i = 0; i < itemsCount; ++i) {
                    ExcelUtils.copyRows((HSSFSheet)sheet, (int)(19 + offset + 2), (int)(19 + offset + 2));
                    ++offset;
                }
            }
            offset += 4;
        }
    }

    protected int getItemsCount(String validatorCode) {
        return this.validators.get(validatorCode);
    }

    private void addTotalFormulas(HSSFSheet sheet, int validatorsCount) throws Exception {
        int offset = 0;
        String columnLetter = null;
        for (int columnNumber : this.getColumnsNumber()) {
            columnLetter = ExcelUtils.indexToLetter((int)columnNumber);
            offset = 21;
            for (int i = 0; i < this.validators.size(); ++i) {
                StringBuilder formula = new StringBuilder();
                formula.append(columnLetter);
                formula.append(offset);
                formula.append(':');
                formula.append(columnLetter);
                formula.append(offset + 1);
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)(offset + 2), (int)columnNumber, (String)String.format("=SUM(%s)", formula.toString()));
                offset += 4;
            }
            StringBuilder formula = new StringBuilder();
            for (int i = 0; i < validatorsCount; ++i) {
                offset = (i + 1) * 4;
                if (formula.length() > 0) {
                    formula.append('+');
                }
                formula.append(columnLetter);
                formula.append(19 + offset);
            }
            if (formula.length() <= 0) continue;
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)(19 + offset + 1), (int)columnNumber, (String)String.format("=%s", formula.toString()));
        }
    }

    private void sortTickets(List<BaseSalesReportTicket> tickets) {
        Collections.sort(tickets, new Comparator<BaseSalesReportTicket>(){

            @Override
            public int compare(BaseSalesReportTicket o1, BaseSalesReportTicket o2) {
                return o1.getValidatorCode().compareTo(o2.getValidatorCode());
            }
        });
    }

    private int getSize(List<BaseSalesReportTicket> tickets) {
        String validatorCode = null;
        for (BaseSalesReportTicket ticket : tickets) {
            validatorCode = ticket.getValidatorCode();
            if (this.validators.keySet().contains(validatorCode)) {
                this.validators.put(validatorCode, this.validators.get(validatorCode) + 1);
                continue;
            }
            this.validators.put(validatorCode, 1);
        }
        return this.validators.keySet().size();
    }

    protected abstract int[] getColumnsNumber();
}

