/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.na;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSalesReportBaseWorksheetHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class NaSalesReportExchangeWorksheetHandler
extends NaSalesReportBaseWorksheetHandler {
    static DictionaryReference<Airline> airlineRef = DictHelper.findAirlineByAnyCode((String)"5N").toReference();

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        Iterator<BaseSalesReportTicket> iterator = data.getTickets().iterator();
        while (iterator.hasNext()) {
            BaseSalesReportTicket ticket = iterator.next();
            if (ticket.getStatus() != ProductStatus.EXCHANGE) continue;
            iterator.remove();
        }
        super.fill(wb, sheet, data, globalData);
        String currentValidatorCode = null;
        String previousValidatorCode = null;
        int currentRow = 0;
        int index = 0;
        for (BaseSalesReportTicket ticket : data.getTickets()) {
            currentValidatorCode = ticket.getValidatorCode();
            if (previousValidatorCode == null || !currentValidatorCode.equals(previousValidatorCode)) {
                previousValidatorCode = currentValidatorCode;
                currentRow = currentRow == 0 ? 20 : (currentRow += 2);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)currentValidatorCode);
                index = 0;
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(++currentRow), (int)1, (int)(++index));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (Date)ticket.getIssueDate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)ticket.getTicketNumber());
            Collection<Tax> taxes = ticket.getTaxes();
            BigDecimal penaltyTaxesEquivalentAmount = AirProductTaxHelper.getEquivalentTaxesAmount(taxes, (String[])AirProductTaxHelper.getPenaltyTaxesCodes(airlineRef));
            BigDecimal penalty = ticket.getPenalty() != null ? ticket.getPenalty().add(penaltyTaxesEquivalentAmount) : penaltyTaxesEquivalentAmount;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (BigDecimal)ticket.getEquivalentFare().add(ticket.getRelatedSellProductEquivalentFare()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (String)ticket.getRelatedSellProductNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (BigDecimal)ticket.getRelatedSellProductEquivalentFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (BigDecimal)penalty);
            StringBuilder formula = new StringBuilder();
            formula.append(ExcelUtils.indexToLetter((int)4) + String.valueOf(currentRow));
            formula.append("-");
            formula.append(ExcelUtils.indexToLetter((int)6) + String.valueOf(currentRow));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (String)String.format("=%s", formula.toString()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (Double)ticket.getVendorCommissionRate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (BigDecimal)ticket.getVendorEquivalentCommission());
            formula = new StringBuilder();
            formula.append(ExcelUtils.indexToLetter((int)8) + String.valueOf(currentRow));
            formula.append("+");
            formula.append(ExcelUtils.indexToLetter((int)7) + String.valueOf(currentRow));
            formula.append("-");
            formula.append(ExcelUtils.indexToLetter((int)10) + String.valueOf(currentRow));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (String)String.format("=%s", formula.toString()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)12, (String)ticket.getFopsName());
        }
    }

    @Override
    protected int[] getColumnsNumber() {
        return new int[]{4, 6, 7, 8, 10, 11};
    }
}

