/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.na;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSalesReportExchangeWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSalesReportRefundWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSalesReportSellWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSummaryReportWorksheetHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NaSalesReportRenderHandler<T extends BaseSalesReportTicket>
extends BasePoiSalesReportRenderHandler<BaseSalesReportTicket> {
    @Override
    protected List<PoiWorksheetData<BaseSalesReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<BaseSalesReportTicket>> result = new ArrayList<PoiWorksheetData<BaseSalesReportTicket>>();
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "SUMMARY";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.SUMMARY;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MVL_SELL";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.MVL_SELL;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "VVL_SELL";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.VVL_SELL;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MVL_REFUND";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.MVL_REFUND;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "VVL_REFUND";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.VVL_REFUND;
            }

            @Override
            public int getProirity() {
                return 5;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "MVL_EXCHANGE";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.MVL_EXCHANGE;
            }

            @Override
            public int getProirity() {
                return 6;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "VVL_EXCHANGE";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.VVL_EXCHANGE;
            }

            @Override
            public int getProirity() {
                return 7;
            }
        });
        return result;
    }

    @Override
    protected void initializeDataList(List<PoiWorksheetData<BaseSalesReportTicket>> dataList, Map<String, Object> data) {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList == null) {
            return;
        }
        for (ReportBatchData batchData : batchDataList) {
            for (PoiWorksheetData<BaseSalesReportTicket> wd : dataList) {
                if (wd.getDefinition() == Definitions.SUMMARY) continue;
                for (BaseSalesReportTicket ticket : batchData.getTickets()) {
                    if ((batchData.getBatchId().equals("SALE") || batchData.getBatchId().equals("CANCEL")) && (wd.getDefinition() == Definitions.MVL_SELL || wd.getDefinition() == Definitions.VVL_SELL)) {
                        if (wd.getDefinition() == Definitions.MVL_SELL && ticket.getTransportationType() == TransportationType.INTERNATIONAL) {
                            wd.getTickets().add(ticket);
                            continue;
                        }
                        if (wd.getDefinition() != Definitions.VVL_SELL || ticket.getTransportationType() != TransportationType.DOMESTIC) continue;
                        wd.getTickets().add(ticket);
                        continue;
                    }
                    if (batchData.getBatchId().equals("REFUND")) {
                        if (wd.getDefinition() == Definitions.MVL_REFUND && ticket.getTransportationType() == TransportationType.INTERNATIONAL) {
                            wd.getTickets().add(ticket);
                            continue;
                        }
                        if (wd.getDefinition() != Definitions.VVL_REFUND || ticket.getTransportationType() != TransportationType.DOMESTIC) continue;
                        wd.getTickets().add(ticket);
                        continue;
                    }
                    if (!batchData.getBatchId().equals("EXC")) continue;
                    if (wd.getDefinition() == Definitions.MVL_EXCHANGE && ticket.getTransportationType() == TransportationType.INTERNATIONAL) {
                        wd.getTickets().add(ticket);
                        continue;
                    }
                    if (wd.getDefinition() != Definitions.VVL_EXCHANGE || ticket.getTransportationType() != TransportationType.DOMESTIC) continue;
                    wd.getTickets().add(ticket);
                }
            }
        }
    }

    @Override
    protected String getTemplateFileName() {
        return "NordaviaSalesReport.xls";
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.NaSalesReportRenderHandler_reportTitle, (Object[])new Object[]{data.get("AGENCY_NAME"), data.get("REPORT_PERIOD")}).toString();
    }

    @Override
    public String getId() {
        return null;
    }

    public static enum Definitions implements PoiWorksheetDefinition<BaseSalesReportTicket>
    {
        SUMMARY{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new NaSummaryReportWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.NaSalesReportRenderHandler_summary, (Object[])new Object[0]).toString();
            }
        }
        ,
        MVL_SELL{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new NaSalesReportSellWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.NaSalesReportRenderHandler_mvlSell, (Object[])new Object[0]).toString();
            }
        }
        ,
        VVL_SELL{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new NaSalesReportSellWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.NaSalesReportRenderHandler_vvlSell, (Object[])new Object[0]).toString();
            }
        }
        ,
        MVL_REFUND{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new NaSalesReportRefundWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.NaSalesReportRenderHandler_mlvRefund, (Object[])new Object[0]).toString();
            }
        }
        ,
        VVL_REFUND{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new NaSalesReportRefundWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.NaSalesReportRenderHandler_vvlRefund, (Object[])new Object[0]).toString();
            }
        }
        ,
        MVL_EXCHANGE{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new NaSalesReportExchangeWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.NaSalesReportRenderHandler_mvlExchange, (Object[])new Object[0]).toString();
            }
        }
        ,
        VVL_EXCHANGE{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new NaSalesReportExchangeWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.NaSalesReportRenderHandler_vvlExchange, (Object[])new Object[0]).toString();
            }
        };

    }
}

