/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.na;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.na.NaSalesReportBaseWorksheetHandler;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class NaSalesReportSellWorksheetHandler
extends NaSalesReportBaseWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        String currentValidatorCode = null;
        String previousValidatorCode = null;
        int currentRow = 0;
        int index = 0;
        for (BaseSalesReportTicket ticket : data.getTickets()) {
            currentValidatorCode = ticket.getValidatorCode();
            if (previousValidatorCode == null || !currentValidatorCode.equals(previousValidatorCode)) {
                previousValidatorCode = currentValidatorCode;
                currentRow = currentRow == 0 ? 20 : (currentRow += 2);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)currentValidatorCode);
                index = 0;
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(++currentRow), (int)1, (int)(++index));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (Date)ticket.getIssueDate());
            StringBuilder formula = new StringBuilder();
            formula.append(ExcelUtils.indexToLetter((int)6) + String.valueOf(currentRow));
            formula.append("+");
            formula.append(ExcelUtils.indexToLetter((int)7) + String.valueOf(currentRow));
            formula.append("-");
            formula.append(ExcelUtils.indexToLetter((int)9) + String.valueOf(currentRow));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)String.format("=%s", formula.toString()));
            if (ticket.getStatus() != ProductStatus.SELL) continue;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)ticket.getCouponsList());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (BigDecimal)ticket.getEquivalentFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (BigDecimal)ticket.getTotalEquivalentTaxFee());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (Double)ticket.getVendorCommissionRate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (BigDecimal)ticket.getVendorEquivalentCommission());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (String)ticket.getFopsName());
        }
    }

    @Override
    protected int[] getColumnsNumber() {
        return new int[]{6, 7, 9, 10};
    }
}

