/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.s7;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

public class S7LabelsWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    private HSSFSheet sheet;
    private static final int START_LABEL_SECTION = 0;
    private static final int END_LABEL_SECTION = 16;
    private static final int LABEL_ROW = 10;
    private int currentRow;
    private String agencyCode;
    private String reportPeriod;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.sheet = sheet;
        this.updateSheetName(wb);
        ArrayList<BaseSalesReportTicket> tickets = new ArrayList<BaseSalesReportTicket>(data.getTickets());
        if (tickets.isEmpty()) {
            return;
        }
        BaseReportParameters params = (BaseReportParameters)globalData.get("key-report-params");
        this.agencyCode = (String)globalData.get("AGENCY_IATA_CODE");
        if (params.getPeriodBegin() != null && params.getPeriodEnd() != null) {
            this.reportPeriod = L10nResourcesManager.createL10nMessage((String)Messages.S7Labels_reportPeriod, (Object[])new Object[]{this.dateFormat.format(params.getPeriodBegin()), this.dateFormat.format(params.getPeriodEnd())}).toString();
        }
        for (int i = tickets.size() - 1; i >= 0; --i) {
            this.currentRow = 10;
            SuTicket ticket = (SuTicket)tickets.get(i);
            if (i > 0) {
                this.addLabelSection();
            }
            this.fillSectionData(this.fixBatchType(ticket.getBatchType()), String.valueOf(ticket.getBatchNo()));
        }
    }

    private void addLabelSection() throws Exception {
        ExcelUtils.copyRows((HSSFSheet)this.sheet, (int)0, (int)16);
        this.currentRow += 17;
    }

    private void fillSectionData(String ... args) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)this.sheet, (int)this.currentRow, (int)1, (int)1, (int)2, (String)this.agencyCode);
        ExcelUtils.setCellValue((HSSFSheet)this.sheet, (int)this.currentRow, (int)1, (int)1, (int)4, (String)this.reportPeriod);
        ExcelUtils.setCellValue((HSSFSheet)this.sheet, (int)this.currentRow, (int)1, (int)1, (int)6, (String)args[0]);
        ExcelUtils.setCellValue((HSSFSheet)this.sheet, (int)this.currentRow, (int)1, (int)1, (int)8, (String)args[1]);
    }

    private String fixBatchType(String batchType) {
        if (batchType != null && batchType.equalsIgnoreCase("EXC")) {
            return "EXCHANGE";
        }
        return batchType;
    }

    private void updateSheetName(HSSFWorkbook wb) {
        wb.setSheetName(wb.getSheetIndex((Sheet)this.sheet), L10nResourcesManager.createL10nMessage((String)Messages.S7Labels_batchesName, (Object[])new Object[0]).toString());
    }
}

