/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.s7;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class S7RegistryRegisterWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    private static String[] carrierTaxes = new String[]{"RU", "\u0420\u0423", "XP", "ER", "KS", "SA", "Y1", "P4", "P7", "P8", "P9", "YR", "P1", "PO"};

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        ArrayList tickets = (ArrayList)data.getTickets();
        if (tickets.isEmpty()) {
            return;
        }
        for (int n = 0; n < tickets.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)7, (int)7);
        }
        int lineNumber = 8;
        for (BaseSalesReportTicket tkt : tickets) {
            SuTicket ticket = (SuTicket)tkt;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)1, (int)(lineNumber - 7));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)2, (int)ticket.getBatchNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)3, (String)ticket.getBatchType());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)4, (int)ticket.getTransactionNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)5, (String)(ticket.getTicketSeries() + " " + ticket.getTicketNumber()));
            if (ticket.getConjCount() > 0) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)6, (String)L10nResourcesManager.createL10nMessage((String)Messages.S7Registry_yes, (Object[])new Object[0]).toString());
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)7, (String)ticket.getTransactionCode());
            if (ticket.isVatIncluded()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)8, (String)L10nResourcesManager.createL10nMessage((String)Messages.S7Registry_yes, (Object[])new Object[0]).toString());
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)8, (String)L10nResourcesManager.createL10nMessage((String)Messages.S7Registry_no, (Object[])new Object[0]).toString());
            }
            BigDecimal equivalentFare = BigDecimal.ZERO;
            BigDecimal commRate = BigDecimal.ZERO;
            BigDecimal comm = BigDecimal.ZERO;
            BigDecimal taxEqu = BigDecimal.ZERO;
            BigDecimal taxOther = BigDecimal.ZERO;
            if (ticket.getReportTicketType() == BaseSalesReportTicket.ReportTicketType.PRODUCT) {
                if (ticket.getProductCategory() == ProductCategory.MCO && (MCOCategory.SEAT_RESERVATION.equals((Object)ticket.getMcoCategory()) || MCOCategory.SPECIAL_FOOD.equals((Object)ticket.getMcoCategory()) || MCOCategory.PENALTY.equals((Object)ticket.getMcoCategory()) || MCOCategory.REBOOKING.equals((Object)ticket.getMcoCategory()))) {
                    BigDecimal toTaxesFromFare;
                    BigDecimal bigDecimal = toTaxesFromFare = ticket.getEquivalentFare() != null ? ticket.getEquivalentFare() : BigDecimal.ZERO;
                    if (MCOCategory.REBOOKING.equals((Object)ticket.getMcoCategory())) {
                        toTaxesFromFare = toTaxesFromFare.add(ticket.getPenalty() != null ? ticket.getPenalty() : BigDecimal.ZERO);
                    }
                    double equivalentTax = ticket.getTaxEquivAmountByCodes(carrierTaxes);
                    double taxAmount = ticket.getTaxAmount() - equivalentTax;
                    taxEqu = toTaxesFromFare.add(BigDecimal.valueOf(equivalentTax));
                    taxOther = BigDecimal.valueOf(taxAmount);
                } else if (!MCOCategory.PTA.equals((Object)ticket.getMcoCategory())) {
                    if (!MCOCategory.UNESCORTED_MINOR.equals((Object)ticket.getMcoCategory())) {
                        equivalentFare = ticket.getEquivalentFare();
                    }
                    double equivalentTax = ticket.getTaxEquivAmountByCodes(carrierTaxes);
                    double taxAmount = ticket.getTaxAmount() - equivalentTax;
                    taxEqu = BigDecimal.valueOf(equivalentTax);
                    taxOther = BigDecimal.valueOf(taxAmount);
                }
                if (ticket.getVendorCommissionRate() != null) {
                    commRate = BigDecimal.valueOf(ticket.getVendorCommissionRate());
                }
                comm = ticket.getVendorEquivalentCommission();
            } else if (ticket.getReportTicketType() == BaseSalesReportTicket.ReportTicketType.MEMO) {
                Map<AgencyMemoProductEntryType, BigDecimal> agencyMemoEquivalentFares = ticket.getAgencyMemoProductEquivalentAmounts();
                if (agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TARIFF) != null) {
                    equivalentFare = equivalentFare.add(agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TARIFF));
                }
                if (agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.COMMISSION) != null) {
                    comm = comm.add(MiscUtil.negate((BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.COMMISSION)));
                }
                if (agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_CARRIER) != null) {
                    taxEqu = taxEqu.add(agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_CARRIER));
                }
                if (agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_FUEL) != null) {
                    taxEqu = taxEqu.add(agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_FUEL));
                }
                if (agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.PENALTY) != null) {
                    taxEqu = taxEqu.add(agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.PENALTY));
                }
                if (agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_STATE) != null) {
                    taxOther = taxOther.add(agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_STATE));
                }
                if (agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_OTHERS) != null) {
                    taxOther = taxOther.add(agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_OTHERS));
                }
                if (agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.CONTRACT_PENALTY) != null) {
                    taxOther = taxOther.add(agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.CONTRACT_PENALTY));
                }
                if (ticket.getAgencyMemoProductType() != AgencyMemoProductType.ADM) {
                    equivalentFare = MiscUtil.negate((BigDecimal)equivalentFare);
                    comm = MiscUtil.negate((BigDecimal)comm);
                    taxEqu = MiscUtil.negate((BigDecimal)taxEqu);
                    taxOther = MiscUtil.negate((BigDecimal)taxOther);
                }
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)9, (BigDecimal)equivalentFare);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)10, (BigDecimal)commRate);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)11, (BigDecimal)comm);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)12, (BigDecimal)taxEqu);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)13, (BigDecimal)taxOther);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)14, (String)ticket.getFopCodes());
            if (ticket.isEticket()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)15, (String)"E");
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)15, (String)ticket.getScn());
            }
            ++lineNumber;
        }
        int firstLineIndex = lineNumber - tickets.size();
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)9, (String)String.format("=SUM(I%s:I%s)", Integer.toString(firstLineIndex), Integer.toString(lineNumber - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)11, (String)String.format("=SUM(K%s:K%s)", Integer.toString(firstLineIndex), Integer.toString(lineNumber - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)12, (String)String.format("=SUM(L%s:L%s)", Integer.toString(firstLineIndex), Integer.toString(lineNumber - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)13, (String)String.format("=SUM(M%s:M%s)", Integer.toString(firstLineIndex), Integer.toString(lineNumber - 1)));
        sheet.autoSizeColumn(4);
        sheet.autoSizeColumn(14);
    }
}

