/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.s7;

import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7LabelsWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7RegistryPismoWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7RegistryRegisterWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class S7RegistryRender<T extends BaseSalesReportTicket>
extends BasePoiSalesReportRenderHandler<BaseSalesReportTicket> {
    @Override
    protected List<PoiWorksheetData<BaseSalesReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<BaseSalesReportTicket>> result = new ArrayList<PoiWorksheetData<BaseSalesReportTicket>>();
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "PISMO";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.PISMO;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "REGISTER";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.REGISTER;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        result.add(new BaseWorksheetData<BaseSalesReportTicket>(){

            @Override
            public String getBatchId() {
                return "LABEL";
            }

            @Override
            public PoiWorksheetDefinition<BaseSalesReportTicket> getDefinition() {
                return Definitions.LABELS;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        return result;
    }

    @Override
    protected void initializeDataList(List<PoiWorksheetData<BaseSalesReportTicket>> dataList, Map<String, Object> data) {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList == null) {
            return;
        }
        int lastBatchNo = -1;
        String lastBatchType = null;
        for (ReportBatchData batchData : batchDataList) {
            for (PoiWorksheetData<BaseSalesReportTicket> wd : dataList) {
                if (wd.getDefinition() == Definitions.PISMO) continue;
                if (wd.getDefinition() == Definitions.LABELS && !batchData.getTickets().isEmpty()) {
                    for (BaseSalesReportTicket ticket : batchData.getTickets()) {
                        if (!(ticket instanceof SuTicket)) continue;
                        SuTicket suTicket = (SuTicket)ticket;
                        if (ticket.getBlankCategory() != BlankCategory.PRINTED_NUMBER && ticket.getBlankCategory() != BlankCategory.GENERATED_NUMBER || suTicket.getBatchType().equals(lastBatchType) && suTicket.getBatchNo() == lastBatchNo) continue;
                        lastBatchNo = suTicket.getBatchNo();
                        lastBatchType = suTicket.getBatchType();
                        wd.getTickets().add(suTicket);
                    }
                    continue;
                }
                wd.getTickets().addAll(batchData.getTickets());
            }
        }
    }

    @Override
    protected String getTemplateFileName() {
        return "S7Reg.xls";
    }

    @Override
    public String getId() {
        return null;
    }

    public static enum Definitions implements PoiWorksheetDefinition<BaseSalesReportTicket>
    {
        PISMO{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new S7RegistryPismoWorksheetHandler();
            }
        }
        ,
        REGISTER{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new S7RegistryRegisterWorksheetHandler();
            }
        }
        ,
        LABELS{

            @Override
            public PoiWorksheetHandler<BaseSalesReportTicket> getHandler() {
                return new S7LabelsWorksheetHandler();
            }
        };


        @Override
        public String getWorksheetTemplateName() {
            return this.name();
        }
    }
}

