/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.base;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SuSalesReportBatchData<T extends SuTicket>
extends ReportBatchData<T> {
    private static final long serialVersionUID = -3401007875988481173L;
    private final List<T> tickets = new ArrayList<T>();
    private String subagencyCode;
    private String agencyCode;
    private static final Set<String> acceptedBatchNames = new HashSet<String>(Arrays.asList("CANCEL", "REFUND", "EXC", "SALE", "MEMO"));

    public String getSubagencyCode() {
        return this.subagencyCode;
    }

    public void setSubagencyCode(String subagencyCode) {
        this.subagencyCode = subagencyCode;
    }

    public Integer getSortOrder() {
        if ("CANCEL".equals(this.getBatchId())) {
            return 1;
        }
        if ("REFUND".equals(this.getBatchId())) {
            return 2;
        }
        if ("EXC".equals(this.getBatchId())) {
            return 3;
        }
        if ("SALE".equals(this.getBatchId())) {
            return 4;
        }
        if ("MEMO".equals(this.getBatchId())) {
            return 5;
        }
        return 0;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public void setAgencyCode(String value) {
        this.agencyCode = value;
    }

    @Override
    public List<T> getTickets() {
        return this.tickets;
    }

    public void sortTickets() {
        Collections.sort(this.tickets, new Comparator<SuTicket>(){

            @Override
            public int compare(SuTicket o1, SuTicket o2) {
                String batchId = SuSalesReportBatchData.this.getBatchId();
                if (batchId == null) {
                    return 0;
                }
                if (batchId.indexOf("EXC") >= 0) {
                    return this.compareExchBatchTickets(o1, o2);
                }
                return this.compareByTariffType(o1, o2);
            }

            private int compareExchBatchTickets(SuTicket o1, SuTicket o2) {
                int value = this.compareByTariffType(o1, o2);
                if (value != 0) {
                    return value;
                }
                if (this.hasCommonNumbers(this.getTicketNumbers(o1), this.getTicketNumbers(o2))) {
                    if (o1.getProductCategory() == ProductCategory.MCO && o1.getMcoCategory() != MCOCategory.VOUCHER && o2.getProductCategory() != ProductCategory.MCO) {
                        return 1;
                    }
                    if (o2.getProductCategory() == ProductCategory.MCO && o2.getMcoCategory() != MCOCategory.VOUCHER && o1.getProductCategory() != ProductCategory.MCO) {
                        return -1;
                    }
                    if (o1.getStatus() != ProductStatus.SELL && o2.getStatus() == ProductStatus.SELL) {
                        return 1;
                    }
                    if (o2.getStatus() != ProductStatus.SELL && o1.getStatus() == ProductStatus.SELL) {
                        return -1;
                    }
                }
                if (this.beforeInChain(o1, o2) || this.afterInChain(o2, o1)) {
                    return -1;
                }
                if (this.beforeInChain(o2, o1) || this.afterInChain(o1, o2)) {
                    return 1;
                }
                String number1 = SuSalesReportBatchData.this.getSortTicketNumber(o1);
                String number2 = SuSalesReportBatchData.this.getSortTicketNumber(o2);
                value = TextUtil.nonBlankStr((String)number1).compareTo(TextUtil.nonBlankStr((String)number2));
                return value;
            }

            private boolean beforeInChain(SuTicket o1, SuTicket o2) {
                boolean res = false;
                Product p1 = o1.getProduct();
                Product p2 = o2.getProduct();
                HashSet<Product> visitedProducts = new HashSet<Product>();
                while (p2.getPreviousProduct() != null && !visitedProducts.contains(p2.getPreviousProduct())) {
                    p2 = p2.getPreviousProduct();
                    visitedProducts.add(p2);
                    if (!TextUtil.isSame((String)p2.getSystemNumber(), (String)p1.getSystemNumber())) continue;
                    res = true;
                    break;
                }
                return res;
            }

            private boolean afterInChain(SuTicket o1, SuTicket o2) {
                boolean res = false;
                Product p1 = o1.getProduct();
                Product p2 = o2.getProduct();
                HashSet<Product> visitedProducts = new HashSet<Product>();
                while (p2.getNextProduct() != null && !visitedProducts.contains(p2.getNextProduct())) {
                    p2 = p2.getNextProduct();
                    visitedProducts.add(p2);
                    if (!TextUtil.isSame((String)p2.getSystemNumber(), (String)p1.getSystemNumber())) continue;
                    res = true;
                    break;
                }
                return res;
            }

            private Set<String> getTicketNumbers(SuTicket ticket) {
                HashSet<String> res = new HashSet<String>();
                res.add(ticket.getTicketNumber() + ticket.getStatus().name());
                if (ticket.getPrevTicket() != null && !TextUtil.isBlank((String)ticket.getPrevTicket().getSystemNumber())) {
                    res.add(ticket.getPrevTicket().getSystemNumber() + ticket.getPrevTicket().getStatus().name());
                }
                if (ticket.getNextTicket() != null && !TextUtil.isBlank((String)ticket.getNextTicket().getSystemNumber())) {
                    res.add(ticket.getNextTicket().getSystemNumber() + ticket.getNextTicket().getStatus().name());
                }
                if (!TextUtil.isBlank((String)ticket.getRelatedProductNumber())) {
                    res.add(ticket.getRelatedProductNumber() + ProductStatus.SELL.name());
                }
                for (Product p : ticket.getRelatedProducts()) {
                    if (TextUtil.isBlank((String)p.getSystemNumber())) continue;
                    res.add(p.getSystemNumber() + p.getStatus().name());
                }
                return res;
            }

            private boolean hasCommonNumbers(Set<String> set1, Set<String> set2) {
                boolean res = false;
                for (String s : set1) {
                    if (!set2.contains(s)) continue;
                    return true;
                }
                return res;
            }

            private int compareByTariffType(SuTicket t1, SuTicket s2) {
                return this.getTariffTypeIndex(t1) - this.getTariffTypeIndex(s2);
            }

            private int getTariffTypeIndex(SuTicket t1) {
                if (t1.getTariffType() == TariffType.REGULAR) {
                    return 0;
                }
                if (t1.getTariffType() == TariffType.BLOCKCHARTER) {
                    return 1;
                }
                if (t1.getTariffType() == TariffType.CHARTER) {
                    return 2;
                }
                return 3;
            }
        });
    }

    public int enumerateTickets(int batch, String batchName) {
        if (!acceptedBatchNames.contains(batchName)) {
            return batch - 1;
        }
        int resultBatchNo = batch;
        for (int i = 0; i < this.getTickets().size(); ++i) {
            SuTicket ticket = (SuTicket)this.getTickets().get(i);
            resultBatchNo = batch + i / 50;
            int ticketNo = i % 50 + 1;
            ticket.setBatchNo(resultBatchNo);
            ticket.setBatchType(this.getBatchId());
            ticket.setTransactionNo(ticketNo);
        }
        return resultBatchNo;
    }

    private String getSortTicketNumber(SuTicket ticket) {
        String res;
        block3: {
            HashSet<Product> visitedProducts;
            block2: {
                Product relatedProduct;
                res = ticket.getTicketNumber();
                visitedProducts = new HashSet<Product>();
                if (!ProductCategory.MCO.equals((Object)ticket.getProductCategory())) break block2;
                Product product = relatedProduct = ticket.getRelatedProducts().length > 0 ? ticket.getRelatedProducts()[0] : null;
                if (relatedProduct == null) break block3;
                res = relatedProduct.getSystemNumber();
                while (relatedProduct.getNextProduct() != null && !visitedProducts.contains(relatedProduct.getNextProduct())) {
                    relatedProduct = relatedProduct.getNextProduct();
                    visitedProducts.add(relatedProduct);
                    res = relatedProduct.getSystemNumber();
                }
                break block3;
            }
            Product p = ticket.getProduct();
            while (p.getNextProduct() != null && !visitedProducts.contains(p.getNextProduct())) {
                p = p.getNextProduct();
                visitedProducts.add(p.getNextProduct());
                res = p.getSystemNumber();
            }
        }
        return res;
    }
}

