/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.base;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LuggageUnits;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class SuTicket
extends BaseSalesReportTicket {
    private static final long serialVersionUID = -8133657397135320776L;
    private Product product;
    private String pcc;
    private String scn;
    private String passengerName;
    private String endorsement;
    private String telexNumber;
    private String fareCalculationData;
    private final ArrayList<Segment> segments;
    protected String ticketRouting;
    protected BigDecimal invoiceValue;
    private String pnr;
    private String latinPNR;
    private Product resPass;
    private String tourCode;
    protected Product[] relatedProducts;
    private String blockCharterContractNo;
    private String blockCharterAgenencyId;
    private boolean sticker;
    private String stickerCouponNames;
    protected String batchId;
    private final int conjCount;
    private String agencyCode;
    private Product prevTicket;
    private Product nextTicket;
    private int batchNo;
    private int transactionNo;
    private String batchType;
    private String transactionCode;
    private String fopCodes;
    private int index;
    private String firstFlightNo;
    private Date firstFlightDepartureDate;
    private Date firstFlightArriveDate;
    private String firstDepartureCityCode;
    private String fareType;
    private String localizedTicketRouting;
    private String firstArriveCityCode;
    private String couponNumbers;
    private double luggageAmmount;
    private LuggageUnits luggageUnits;
    private boolean interline;
    private BigDecimal prepayed;
    private String mainTicketSeries;
    private String mainTicketNumber;
    private boolean duplicate;
    private boolean deputy;
    private final Map<AgencyMemoProductEntryType, BigDecimal> agencyMemoProductEquivalentAmounts;

    public SuTicket() {
        this.segments = new ArrayList();
        this.resPass = null;
        this.firstFlightNo = "";
        this.firstDepartureCityCode = "";
        this.fareType = "";
        this.deputy = false;
        this.agencyMemoProductEquivalentAmounts = new HashMap<AgencyMemoProductEntryType, BigDecimal>();
        this.creditCardValue = BigDecimal.ZERO;
        this.cashValue = BigDecimal.ZERO;
        this.relatedProducts = new Product[0];
        this.conjCount = 0;
    }

    public SuTicket(AgencyMemoProduct agencyMemoProduct, List<Message> messages) throws Exception {
        super(agencyMemoProduct, messages);
        this.segments = new ArrayList();
        this.resPass = null;
        this.firstFlightNo = "";
        this.firstDepartureCityCode = "";
        this.fareType = "";
        this.deputy = false;
        this.agencyMemoProductEquivalentAmounts = new HashMap<AgencyMemoProductEntryType, BigDecimal>();
        this.conjCount = 0;
        this.batchId = "MEMO";
        this.agencyCode = agencyMemoProduct.getAgency() != null ? agencyMemoProduct.getAgency().getCaption() : null;
        for (AgencyMemoProductItemGroup vendorItemGroup : agencyMemoProduct.getItemGroups()) {
            AgencyMemoProductEntryType agencyMemoProductEntryType;
            if (vendorItemGroup.getEquivalentAmount() == null) continue;
            BigDecimal agencyMemoProductEquivalentAmount = this.agencyMemoProductEquivalentAmounts.get(agencyMemoProductEntryType = vendorItemGroup.getType());
            this.agencyMemoProductEquivalentAmounts.put(agencyMemoProductEntryType, agencyMemoProductEquivalentAmount != null ? agencyMemoProductEquivalentAmount.add(vendorItemGroup.getEquivalentAmount()) : vendorItemGroup.getEquivalentAmount());
        }
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        this.fops.add(fop);
    }

    public SuTicket(Product product, List<Message> messages) throws Exception {
        SegmentTariff st;
        Iterator mcoFare;
        Object mco2;
        block51: {
            block50: {
                Traveller traveller;
                BigDecimal rate;
                super(product, messages);
                this.segments = new ArrayList();
                this.resPass = null;
                this.firstFlightNo = "";
                this.firstDepartureCityCode = "";
                this.fareType = "";
                this.deputy = false;
                this.agencyMemoProductEquivalentAmounts = new HashMap<AgencyMemoProductEntryType, BigDecimal>();
                super.setEticketFlag(product.isEticket());
                this.telexNumber = product.getTelexNumber();
                if (!TextUtil.isBlank((String)product.getCarrierNumber())) {
                    this.ticketSeries = product.getCarrierNumber();
                }
                this.setFareRate(AirProductHelper.calculateFareRate((Product)product));
                if ((this.getFareRate() == null || this.getFareRate().equals(BigDecimal.ZERO)) && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL && (rate = AirProductHelper.calculateFareRate((Product)product.getPreviousProduct())) != null && rate != BigDecimal.ZERO) {
                    this.setFareRate(rate);
                }
                this.duplicate = product.isDuplicate();
                if (this.duplicate) {
                    this.setupDuplicate(product, messages);
                }
                this.product = product;
                if (product.getLuggageWeight() != null) {
                    this.luggageAmmount = product.getLuggageWeight();
                    this.luggageUnits = product.getLuggageUnits();
                    if (this.luggageUnits == null) {
                        this.luggageUnits = this.luggageAmmount < 10.0 ? LuggageUnits.PIECE : LuggageUnits.WEIGHT_KG;
                    }
                }
                this.prevTicket = product.getPreviousProduct();
                this.nextTicket = product.getNextProduct();
                this.relatedProducts = new Product[0];
                this.resPass = product;
                this.pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation());
                this.latinPNR = CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)product.getReservation(), (GdsName)GdsName.SIRENA, (RecordLocatorType)RecordLocatorType.SIRENA_LATIN);
                this.tourCode = product.getTourCode();
                this.ticketRouting = AirProductHelper.getRouteLine((Product)product);
                this.localizedTicketRouting = AirProductHelper.getLocalizedRouteLine((Product)product);
                this.validatorCode = product.getValidatorCode();
                this.pcc = product.getPcc();
                if (product.getScns() != null && !product.getScns().isEmpty()) {
                    this.scn = (String)product.getScns().get(0);
                }
                if ((traveller = product.getTraveller()) != null) {
                    this.passengerName = !TextUtil.isBlank((String)traveller.getNameInGds()) ? traveller.getNameInGds() : traveller.getName();
                }
                this.endorsement = product.getEndorsement();
                this.fareCalculationData = product.getFareCalculationData();
                this.mainTicketSeries = product.getMainProductCode();
                this.mainTicketNumber = product.getMainProductNumber();
                this.couponNumbers = "";
                for (SegmentTariff st2 : product.getSegmentTariffs()) {
                    for (Object seg : st2.getSegments()) {
                        if (seg.getDepartCityCode() == null && seg.getDepartureLocation() != null) {
                            seg.setDepartCityCode(this.getCityCode(seg.getDepartureLocation().getCode()));
                        }
                        if (seg.getArriveCityCode() == null && seg.getArriveLocation() != null) {
                            seg.setArriveCityCode(this.getCityCode(seg.getArriveLocation().getCode()));
                        }
                        this.segments.add((Segment)seg);
                        this.couponNumbers = this.couponNumbers + seg.getRecordNumber() + " ";
                        if (DictHelper.isSameCarriers((DictionaryReference)seg.getAirline(), (DictionaryReference)product.getCarrier())) continue;
                        this.interline = true;
                    }
                }
                this.couponNumbers = this.couponNumbers.trim();
                this.creditCardValue = BigDecimal.ZERO;
                this.cashValue = BigDecimal.ZERO;
                this.invoiceValue = BigDecimal.ZERO;
                Object notTicketProductFop = null;
                Object ticketProductFop = null;
                Object mcoPrepaymentFop = null;
                for (Object fop : this.fops) {
                    Money money = fop.getAmount();
                    BigDecimal currentFopValueNotTicket = BigDecimal.ZERO;
                    if (fop.getType() != PaymentType.TICKET) {
                        if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                            currentFopValueNotTicket = new BigDecimal(fop.getAmount().getValue().toString());
                        }
                        notTicketProductFop = fop;
                        if (ticketProductFop != null) {
                            if (money == null) {
                                money = new Money();
                                money.setCurrency(DictHelper.getLocalCurrency());
                                money.setValue(BigDecimal.ZERO);
                                fop.setAmount(money);
                            }
                            BigDecimal val1 = money.getValue();
                            BigDecimal val2 = ticketProductFop.getAmount() == null || ticketProductFop.getAmount().getValue() == null ? BigDecimal.ZERO : ticketProductFop.getAmount().getValue();
                            money.setValue(val1.add(val2));
                            ticketProductFop = null;
                        }
                    } else if (!product.isDuplicate()) {
                        ticketProductFop = fop;
                        if (notTicketProductFop != null) {
                            Money amnt = notTicketProductFop.getAmount();
                            if (amnt == null) {
                                amnt = new Money();
                                amnt.setCurrency(DictHelper.getLocalCurrency());
                                amnt.setValue(BigDecimal.ZERO);
                                notTicketProductFop.setAmount(amnt);
                            }
                            BigDecimal val1 = amnt.getValue();
                            BigDecimal val2 = ticketProductFop.getAmount() == null || ticketProductFop.getAmount().getValue() == null ? BigDecimal.ZERO : ticketProductFop.getAmount().getValue();
                            amnt.setValue(val1.add(val2));
                            ticketProductFop = null;
                        }
                    }
                    BigDecimal amount = null;
                    if (money != null) {
                        amount = money.getValue();
                    }
                    if (amount == null) {
                        amount = BigDecimal.ZERO;
                    }
                    if (PaymentType.CREDIT_CARD == fop.getType()) {
                        if (fop.getCard() != null) {
                            this.setCreditCardNo(fop.getCard().getNumber());
                            this.setPaymentCardVendor(fop.getCard().getVendor());
                            this.setPaymentCardSecurityCode(fop.getCard().getSecurityCode());
                        }
                        this.creditCardValue = this.creditCardValue.add(currentFopValueNotTicket);
                        continue;
                    }
                    if (PaymentType.CASH == fop.getType()) {
                        this.cashValue = this.cashValue.add(amount);
                        continue;
                    }
                    if (PaymentType.INVOICE == fop.getType()) {
                        if (this.getTariffType() != TariffType.BLOCKCHARTER && this.getTariffType() != TariffType.CHARTER) {
                            this.cashValue = this.cashValue.add(amount);
                            fop.setType(PaymentType.CASH);
                            continue;
                        }
                        this.invoiceValue = this.invoiceValue.add(amount);
                        continue;
                    }
                    if (PaymentType.MCO == fop.getType()) {
                        mcoPrepaymentFop = fop;
                    }
                    if (PaymentType.MTD != fop.getType() && (PaymentType.CREDIT != fop.getType() || fop.getPassengerStatus() != PassengerStatus.DEP_GD && fop.getPassengerStatus() != PassengerStatus.SOV_FED)) continue;
                    this.deputy = true;
                }
                if (product.getTariffType() == TariffType.GROUP && this.productCategory != ProductCategory.MCO && mcoPrepaymentFop == null) {
                    Collection mcoList = AirProductHelper.getMcoByRelatedProduct((Product)product);
                    for (Object mco2 : mcoList) {
                        BigDecimal v;
                        if (mco2.getMcoCategory() != MCOCategory.GROUP_PREPAYMENT) continue;
                        if (TextUtil.isBlank((String)this.telexNumber)) {
                            this.telexNumber = mco2.getTelexNumber();
                        }
                        int groupTravellerAmount = mco2.getLuggageWeight() == null ? 0 : mco2.getLuggageWeight().intValue();
                        mcoFare = AirProductHelper.getEquivalentFare((Product)mco2);
                        if (groupTravellerAmount == 0 || mcoFare == null) continue;
                        ProductFop fop = new ProductFop();
                        this.fops.add(fop);
                        boolean isLastRelatedProduct = true;
                        for (int n = mco2.getRelatedProducts().size() - 1; n >= 0; --n) {
                            Product relatedProduct = (Product)mco2.getRelatedProducts().get(n);
                            if (relatedProduct.getStatus() != this.status) continue;
                            if (product.equals((Object)relatedProduct)) break;
                            if (relatedProduct.getProductCategory() != ProductCategory.AIR) continue;
                            isLastRelatedProduct = false;
                            break;
                        }
                        BigDecimal prepayedValue = isLastRelatedProduct ? ((BigDecimal)((Object)mcoFare)).subtract(((BigDecimal)((Object)mcoFare)).divide(BigDecimal.valueOf(groupTravellerAmount), 0, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(groupTravellerAmount - 1))) : ((BigDecimal)((Object)mcoFare)).divide(BigDecimal.valueOf(groupTravellerAmount), 0, RoundingMode.HALF_UP);
                        this.prepayed = this.prepayed == null ? prepayedValue : this.prepayed.add(prepayedValue);
                        fop.setType(PaymentType.MCO);
                        fop.setAmount(new Money());
                        fop.getAmount().setValue(prepayedValue);
                        fop.getAmount().setCurrency(DictHelper.getLocalCurrency());
                        fop.setRelatedTicketNumber(mco2.getSystemNumber());
                        if (notTicketProductFop == null || (v = notTicketProductFop.getAmount().getValue()) == null) continue;
                        notTicketProductFop.getAmount().setValue(v.subtract(prepayedValue));
                    }
                    if ("SU".equals(this.getBlankOwnerCode()) && mcoList.size() > 0) {
                        Object fop;
                        fop = new ProductFop();
                        fop.setType(PaymentType.INVOICE);
                        fop.setAmount(new Money());
                        fop.getAmount().setValue(BigDecimal.ZERO);
                        fop.getAmount().setCurrency(DictHelper.getLocalCurrency());
                        this.fops.add(fop);
                    }
                }
                if (this.prepayed != null && (this.status == ProductStatus.EXCHANGE || this.status == ProductStatus.REFUND)) {
                    this.prepayed = this.prepayed.negate();
                }
                if (this.productCategory != ProductCategory.MCO && !this.duplicate) break block50;
                List relProducts = product.getRelatedProducts();
                if (relProducts.isEmpty()) break block51;
                this.relatedProducts = relProducts.toArray(new Product[0]);
                break block51;
            }
            if (this.productCategory == ProductCategory.AIR) {
                for (Product relatedMCO : AirProductHelper.getMcoByRelatedProduct((Product)product)) {
                    if (relatedMCO.getStatus() != ProductStatus.SELL || relatedMCO.getMcoCategory() != MCOCategory.PENALTY && relatedMCO.getMcoCategory() != MCOCategory.REBOOKING) continue;
                    this.relatedProducts = new Product[1];
                    this.relatedProducts[0] = relatedMCO;
                    break;
                }
            }
        }
        this.setBatchId(product);
        this.conjCount = product.getConjCount();
        EntityReference subagencyRef = AirProductHelper.getSubagency((Product)product);
        this.agencyCode = subagencyRef != null ? subagencyRef.getCaption() : null;
        Segment firstSegment = null;
        mco2 = product.getSegmentTariffs().iterator();
        if (mco2.hasNext() && (mcoFare = (st = (SegmentTariff)mco2.next()).getSegments().iterator()).hasNext()) {
            Segment segment;
            firstSegment = segment = (Segment)mcoFare.next();
        }
        if (firstSegment != null) {
            this.firstFlightNo = firstSegment.getFlightNo();
            this.firstFlightDepartureDate = firstSegment.getStartDate();
            this.firstFlightArriveDate = firstSegment.getEndDate();
            Object code = DictHelper.getAirportCode((DictionaryReference)firstSegment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA);
            this.firstDepartureCityCode = code != null ? code : firstSegment.getDepartCityCode();
            code = DictHelper.getAirportCode((DictionaryReference)firstSegment.getArriveLocation(), (CodeSystem)CodeSystem.IATA);
            this.firstArriveCityCode = code != null ? code : firstSegment.getArriveCityCode();
        }
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment seg : segmentTariff.getSegments()) {
                if ("NGV6".equals(seg.getFareBasis())) {
                    this.fareType = "AD";
                    continue;
                }
                if ("NGV6CH25".equals(seg.getFareBasis()) || "NGV6/CH25".equals(seg.getFareBasis())) {
                    this.fareType = "CH";
                    continue;
                }
                if (!"NGV6IN90".equals(seg.getFareBasis())) continue;
                this.fareType = "IN";
            }
        }
        if (ProductCategory.MCO == this.productCategory && MCOCategory.RETURN_TICKET == this.mcoCategory) {
            BlankType blankType = null;
            if (product.getPreviousProduct() != null && product.getPreviousProduct().getBlankType() != null) {
                blankType = (BlankType)DictionaryCache.get().resolveReference(product.getPreviousProduct().getBlankType());
            }
            if (blankType != null) {
                this.couponsCount = blankType.getCouponsCount();
            }
        }
        ArrayList<Double> vendorCommissionRates = new ArrayList<Double>();
        block11: for (Commission commission : AirProductHelper.getUnmodifiableCommissions((Product)product, null)) {
            boolean discount;
            EntityReference prop;
            if (commission.getContractType() == null) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                EntityReference cprop = commission.getCommissionProperties();
                EntityContainer ctr = EntityStorage.get().resolve(cprop);
                if (ctr != null && ((CommissionProperties)ctr.getEntity()).isBspCommission() || ctr != null && ((CommissionProperties)ctr.getEntity()).isBonus()) continue;
            }
            boolean fee = (prop = commission.getCommissionProperties()) != null && (FeeProperties.class.equals((Object)prop.getType()) || PaymentFeeProperties.class.equals((Object)prop.getType()));
            boolean bl = discount = prop != null && DiscountProperties.class.getName().equals(prop.getType().getName());
            if (fee || discount) continue;
            switch (commission.getContractType()) {
                case VENDOR: {
                    this.vendorCommissionRate = this.updateCommissionRate(this.vendorCommissionRate, commission.getRate());
                    vendorCommissionRates.add(commission.getRate());
                    if (commission.getSegmentTariff() == null) break;
                    int freq = Collections.frequency(vendorCommissionRates, commission.getRate());
                    if (vendorCommissionRates.size() == freq) continue block11;
                    this.vendorCommissionRate = 0.0;
                    break;
                }
            }
        }
    }

    protected void setBatchId(Product prod) {
        block1 : switch (prod.getStatus()) {
            case SELL: {
                try {
                    this.batchId = "SALE";
                    if (prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                        this.batchId = "EXC";
                    }
                    if (prod.getProductCategory() != ProductCategory.MCO || prod.getMcoCategory() != MCOCategory.PENALTY && prod.getMcoCategory() != MCOCategory.REBOOKING && prod.getMcoCategory() != MCOCategory.ADDITIONAL_TARIFF && prod.getMcoCategory() != MCOCategory.INFORMATION || prod.getRelatedProducts() == null || prod.getRelatedProducts().isEmpty()) break;
                    ProductStatus relProdStatus = ((Product)prod.getRelatedProducts().iterator().next()).getStatus();
                    switch (relProdStatus) {
                        case EXCHANGE: {
                            this.batchId = "EXC";
                            break block1;
                        }
                        case SELL: {
                            this.batchId = "EXC";
                            break block1;
                        }
                        case REFUND: {
                            this.batchId = "REFUND";
                            break block1;
                        }
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
                }
                break;
            }
            case REFUND: {
                this.batchId = "REFUND";
                if (super.getPenalty() != null || this.relatedProducts == null || this.relatedProducts.length <= 0 || "S7".equals(this.getBlankOwnerCode()) || "SU".equals(this.getBlankOwnerCode())) break;
                super.setPenalty(AirProductHelper.getEquivalentFare((Product)this.relatedProducts[0]));
                break;
            }
            case EXCHANGE: {
                this.batchId = "EXC";
                break;
            }
            case VOID: {
                this.batchId = "CANCEL";
                if (super.getPenalty() != null || this.relatedProducts == null || this.relatedProducts.length <= 0) break;
                super.setPenalty(AirProductHelper.getEquivalentFare((Product)this.relatedProducts[0]));
                break;
            }
        }
    }

    public String getLocalizedTicketRouting() {
        return this.localizedTicketRouting;
    }

    public String getPcc() {
        return this.pcc;
    }

    public String getScn() {
        return this.scn;
    }

    public void setScn(String value) {
        this.scn = value;
    }

    public boolean isVatIncluded() {
        return this.getTransportationType() == TransportationType.DOMESTIC || this.getProductCategory() == ProductCategory.MCO && this.getMcoCategory() == MCOCategory.PENALTY || this.getStatus() == ProductStatus.VOID;
    }

    public String getPassengerName() {
        return this.passengerName;
    }

    public String getEndorsement() {
        return this.endorsement;
    }

    public String getTelexNumber() {
        return this.telexNumber;
    }

    public String getFareCalculationData() {
        return this.fareCalculationData;
    }

    public Collection<Segment> getSegments() {
        return this.segments;
    }

    public String getTicketRouting() {
        return this.ticketRouting;
    }

    public void setTicketRouting(String value) {
        this.ticketRouting = value;
    }

    public BigDecimal getInvoiceValue() {
        return this.invoiceValue;
    }

    public Collection<ProductFop> getFopsCollection() {
        return AirProductHelper.getVendorContractRelation((Product)this.resPass).getFops();
    }

    public String getPnr() {
        return this.pnr;
    }

    public String getLatinPnr() {
        return this.latinPNR;
    }

    public String getTourCode() {
        return this.tourCode;
    }

    public Product[] getRelatedProducts() {
        return this.relatedProducts;
    }

    public Collection<String> getTaxCodes() {
        HashSet<String> taxCodes = new HashSet<String>();
        for (Tax tax : this.taxes) {
            taxCodes.add(tax.getCode());
        }
        return taxCodes;
    }

    public double getTaxEquivAmountByCode(String code) {
        BigDecimal result = BigDecimal.ZERO;
        for (Tax tax : this.taxes) {
            if (tax.getEquivalentAmount() == null || code == null || !code.equals(tax.getCode())) continue;
            result = result.add(tax.getEquivalentAmount());
        }
        return result.doubleValue();
    }

    public double getTaxEquivAmountByCodes(String[] codes) {
        BigDecimal result = BigDecimal.ZERO;
        if (codes != null) {
            List<String> codesList = Arrays.asList(codes);
            for (Tax tax : this.taxes) {
                if (tax.getEquivalentAmount() == null || !codesList.contains(tax.getCode())) continue;
                result = result.add(tax.getEquivalentAmount());
            }
        }
        return result.doubleValue();
    }

    public void setTaxEquivAmountByCode(String code, double value) {
        for (Tax tax : this.taxes) {
            if (code == null || !code.equals(tax.getCode())) continue;
            tax.setEquivalentAmount(new BigDecimal(value));
        }
    }

    public double getOtherTaxAmount() {
        double result = this.getTaxAmount();
        result -= this.getTaxEquivAmountByCode("RU");
        result -= this.getTaxEquivAmountByCode("YQ");
        result -= this.getTaxEquivAmountByCode("YR");
        result -= this.getTaxEquivAmountByCode("CP");
        result -= this.getTaxEquivAmountByCode("P1");
        return result -= this.getTaxEquivAmountByCode("P2");
    }

    public double getOtherTaxAmountWithMCO() {
        double result = this.getTaxAmount();
        result -= this.getTaxEquivAmountByCode("RU");
        result -= this.getTaxEquivAmountByCode("YQ");
        return result -= this.getTaxEquivAmountByCode("YR");
    }

    public String getRelatedTicketNumber() {
        if (this.relatedProducts == null || this.relatedProducts.length == 0) {
            return "";
        }
        return this.relatedProducts[0].getSystemNumber();
    }

    public String getBlockCharterContractNo() {
        return this.blockCharterContractNo;
    }

    public void setBlockCharterContractNo(String value) {
        this.blockCharterContractNo = value;
    }

    public String getBlockCharterAgenencyId() {
        return this.blockCharterAgenencyId;
    }

    public void setBlockCharterAgenencyId(String value) {
        this.blockCharterAgenencyId = value;
    }

    public boolean isSticker() {
        return this.sticker;
    }

    public void setSticker(boolean value) {
        this.sticker = value;
    }

    public String getStickerCouponNames() {
        return this.stickerCouponNames;
    }

    public void setStickerCouponNames(String value) {
        this.stickerCouponNames = value;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public int getConjCount() {
        return this.conjCount;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public Product getNextTicket() {
        return this.nextTicket;
    }

    public Product getPrevTicket() {
        return this.prevTicket;
    }

    public int getBatchNo() {
        return this.batchNo;
    }

    public void setBatchNo(int value) {
        this.batchNo = value;
    }

    public int getTransactionNo() {
        return this.transactionNo;
    }

    public void setTransactionNo(int value) {
        this.transactionNo = value;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int value) {
        this.index = value;
    }

    public String getBatchType() {
        return this.batchType;
    }

    public void setBatchType(String value) {
        this.batchType = value;
    }

    public String getTransactionCode() {
        return this.transactionCode;
    }

    public void setTransactionCode(String value) {
        this.transactionCode = value;
    }

    public String getFirstArriveCityCode() {
        return this.firstArriveCityCode;
    }

    public void setFirstArriveCityCode(String value) {
        this.firstArriveCityCode = value;
    }

    public double getTaxAmount() {
        BigDecimal result = BigDecimal.ZERO;
        for (Tax tax : this.taxes) {
            if (tax.getEquivalentAmount() == null) continue;
            result = result.add(tax.getEquivalentAmount());
        }
        return result.doubleValue();
    }

    public void setFopCodes(String value) {
        this.fopCodes = value;
    }

    public String getFopCodes() {
        if (this.fops == null) {
            return null;
        }
        if (this.fopCodes == null) {
            StringBuilder result = new StringBuilder();
            for (ProductFop fop : this.fops) {
                String fopType;
                if (fop == null || fop.getType() == null) continue;
                String string = fopType = fop.getType() == PaymentType.MTD ? "AI" : fop.getType().name().substring(0, 2);
                if (result.toString().contains(fopType)) continue;
                result.append(fopType).append(";");
            }
            if (this.mcoCategory == MCOCategory.VOUCHER && this.status == ProductStatus.SELL && !result.toString().contains("LS")) {
                result.append("LS;");
            }
            this.fopCodes = result.toString();
            if (this.fopCodes.endsWith(";")) {
                this.fopCodes = this.fopCodes.substring(0, this.fopCodes.length() - 1);
            }
        }
        return this.fopCodes;
    }

    public String getFirstFlightNo() {
        return this.firstFlightNo;
    }

    public Date getFirstFlightDepartureDate() {
        return this.firstFlightDepartureDate;
    }

    public String getFirstDepartureCityCode() {
        return this.firstDepartureCityCode;
    }

    public void setFirstFlightNo(String value) {
        this.firstFlightNo = value;
    }

    public void setFirstFlightDepartureDate(Date value) {
        this.firstFlightDepartureDate = value;
    }

    public Date getFirstFlightArriveDate() {
        return this.firstFlightArriveDate;
    }

    public void setFirstFlightArriveDate(Date value) {
        this.firstFlightArriveDate = value;
    }

    public String getFareType() {
        return this.fareType;
    }

    protected List<ProductFop> collectFops(Product product) {
        ArrayList<ProductFop> result = new ArrayList<ProductFop>();
        if (product == null) {
            return result;
        }
        result.addAll(AirProductHelper.getVendorContractRelation((Product)product).getFops());
        return result;
    }

    private String getCityCode(String airportCode) {
        GeoLocation city = DictHelper.findCityByAirport((String)airportCode);
        return city != null ? city.getCode() : null;
    }

    public void setBatchId(String value) {
        this.batchId = value;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public String getCouponNumbers() {
        return this.couponNumbers;
    }

    public double getLuggageWeight() {
        return this.luggageAmmount;
    }

    public LuggageUnits getLuggageUnits() {
        return this.luggageUnits;
    }

    public boolean isInterline() {
        return this.interline;
    }

    @Override
    public void setEquivalentFare(BigDecimal value) {
        this.equivalentFare = value;
    }

    public BigDecimal getPrepayed() {
        return this.prepayed;
    }

    public String getMainTicketSeries() {
        return this.mainTicketSeries;
    }

    public void setMainTicketSeries(String aValue) {
        this.mainTicketSeries = aValue;
    }

    public String getMainTicketNumber() {
        return this.mainTicketNumber;
    }

    public void setMainTicketNumber(String mainTicketNumber) {
        this.mainTicketNumber = mainTicketNumber;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public boolean isDeputy() {
        return this.deputy;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    protected void setupDuplicate(Product product, List<Message> messages) throws Exception {
        if (product.getPenalty() != null && !product.getPenalty().equals(BigDecimal.ZERO)) {
            Tax tax = new Tax();
            tax.setAmount(new Money());
            tax.setEquivalentAmount(product.getPenalty());
            tax.getAmount().setValue(tax.getEquivalentAmount());
            tax.getAmount().setCurrency(DictHelper.getLocalCurrency());
            tax.setCode("DL");
            this.taxes.add(tax);
        }
    }

    public Map<AgencyMemoProductEntryType, BigDecimal> getAgencyMemoProductEquivalentAmounts() {
        return this.agencyMemoProductEquivalentAmounts;
    }
}

