/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCFlightData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCQuotaData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SUBCDateData
implements Serializable {
    private static final long serialVersionUID = -6763643299356192625L;
    private final SUBCAppendixData appendix;
    private Date date;
    private final List<SUBCFlightData> flights = new ArrayList<SUBCFlightData>();
    private final List<SUBCTicket> directTickets = new ArrayList<SUBCTicket>();
    private final List<SUBCTicket> regionTickets = new ArrayList<SUBCTicket>();

    public SUBCDateData(SUBCAppendixData appendixData) {
        this.appendix = appendixData;
        this.appendix.getDates().add(this);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date value) {
        this.date = value;
    }

    public List<SUBCFlightData> getFlights() {
        return this.flights;
    }

    public int getTotalRTSingleClassAdult() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalRTSingleClassAdult();
            }
        });
    }

    public int getTotalRTMixedClassAdult() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalRTMixedClassAdult();
            }
        });
    }

    public int getTotalRTSingleClassInfant() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalRTSingleClassInfant();
            }
        });
    }

    public int getTotalRTMixedClassInfant() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalRTMixedClassInfant();
            }
        });
    }

    public int getTotalOWAdult() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalOWAdult();
            }
        });
    }

    public int getTotalOWInfantAdult() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalOWAdult();
            }
        });
    }

    private int calculateValue(IntValueCalculator valueCalculator) {
        int n = 0;
        for (SUBCFlightData flight : this.flights) {
            for (SUBCQuotaData quota : flight.getQuotas()) {
                n += valueCalculator.calculateValue(quota);
            }
        }
        return n;
    }

    private BigDecimal calculateValue(BigDecimalValueCalculator valueCalculator) {
        BigDecimal result = BigDecimal.ZERO;
        for (SUBCFlightData flight : this.flights) {
            for (SUBCQuotaData quota : flight.getQuotas()) {
                result = result.add(valueCalculator.calculateValue(quota));
            }
        }
        return result;
    }

    public SUBCAppendixData getAppendix() {
        return this.appendix;
    }

    public List<SUBCTicket> getDirectTickets() {
        return this.directTickets;
    }

    public List<SUBCTicket> getRegionTickets() {
        return this.regionTickets;
    }

    public BigDecimal getTotalUnsoldTariff() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCQuotaData data) {
                return data.getTotalUnsoldAmount();
            }
        });
    }

    public BigDecimal getTotalUnsoldEquivalentTariff() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCQuotaData data) {
                return data.getTotalUnsoldEquivalentAmount();
            }
        });
    }

    public int getTotalUnsoldCount() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalUnsoldCount();
            }
        });
    }

    private static interface IntValueCalculator {
        public int calculateValue(SUBCQuotaData var1);
    }

    private static interface BigDecimalValueCalculator {
        public BigDecimal calculateValue(SUBCQuotaData var1);
    }
}

