/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCFlightData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

public class SUBCF3WorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        wb.setSheetName(wb.getSheetIndex((Sheet)sheet), "\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 2");
        SUBCData bcdata = (SUBCData)globalData.get("KEY_BLOCK_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)bcdata.getReportPeriod());
        ArrayList<SUBCFlightData> euroData = new ArrayList<SUBCFlightData>();
        ArrayList<SUBCFlightData> usdData = new ArrayList<SUBCFlightData>();
        for (SUBCAppendixData app : bcdata.getAppendices()) {
            for (SUBCDateData date : app.getDates()) {
                for (SUBCFlightData flight : date.getFlights()) {
                    if ("EUR".equals(app.getCurrencyCode())) {
                        euroData.add(flight);
                        continue;
                    }
                    usdData.add(flight);
                }
            }
        }
        Comparator<SUBCFlightData> comparator = new Comparator<SUBCFlightData>(){

            @Override
            public int compare(SUBCFlightData o1, SUBCFlightData o2) {
                int res = TextUtil.compare((String)o1.getDateData().getAppendix().getAppendixNumber(), (String)o2.getDateData().getAppendix().getAppendixNumber(), (boolean)false, (boolean)true);
                if (res != 0) {
                    return res;
                }
                res = TextUtil.compare((String)o1.getDateData().getAppendix().getRoute(), (String)o2.getDateData().getAppendix().getRoute(), (boolean)false, (boolean)true);
                if (res != 0) {
                    return res;
                }
                res = MiscUtil.compare((Date)o1.getDateData().getDate(), (Date)o2.getDateData().getDate(), (boolean)false);
                if (res != 0) {
                    return res;
                }
                return TextUtil.compare((String)o1.getFlightNumber(), (String)o2.getFlightNumber(), (boolean)false, (boolean)true);
            }
        };
        Collections.sort(euroData, comparator);
        Collections.sort(usdData, comparator);
        this.fillSection(euroData, "EUR", sheet, 10);
        int delta = euroData.isEmpty() ? 0 : euroData.size() - 1;
        int eurOverallRow = 12 + delta;
        this.fillSection(usdData, "USD", sheet, 16 + delta);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(19 + delta), (int)5, (int)1, (int)1, (String)String.format("=E%s+E%s", Integer.toString(eurOverallRow), Integer.toString(18 + (delta += usdData.isEmpty() ? 0 : usdData.size() - 1))));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(19 + delta), (int)6, (int)1, (int)1, (String)String.format("=F%s+F%s", Integer.toString(eurOverallRow), Integer.toString(18 + delta)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(19 + delta), (int)8, (int)1, (int)1, (String)String.format("=H%s+H%s", Integer.toString(eurOverallRow), Integer.toString(18 + delta)));
    }

    private void fillSection(List<SUBCFlightData> flightData, String currency, HSSFSheet sheet, int currentRow) throws Exception {
        for (int n = 0; n < flightData.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)currentRow, (int)currentRow);
        }
        int firstRow = currentRow;
        int row = currentRow;
        for (SUBCFlightData flight : flightData) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)1, (String)flight.getDateData().getAppendix().getAppendixNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)2, (String)flight.getDateData().getAppendix().getRoute());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)3, (String)flight.getFlightNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)4, (String)this.dateFormat.format(flight.getDateData().getDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)5, (int)flight.getTotalUnsoldCount());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)6, (BigDecimal)flight.getTotalUnsoldAmount());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)7, (BigDecimal)flight.getDateData().getAppendix().getCurrencyRate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)row, (int)1, (int)1, (int)8, (BigDecimal)flight.getTotalUnsoldEquivalentAmount());
            ++row;
        }
        sheet.getRow(firstRow - 2).setHeight((short)0);
        sheet.getRow(row - 1).setHeight((short)0);
        ++row;
        if (!flightData.isEmpty()) {
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)row, (int)5, (int)1, (int)1, (String)String.format("=SUM(E%s:E%s)", Integer.toString(firstRow), Integer.toString(row - 2)));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)row, (int)6, (int)1, (int)1, (String)String.format("=SUM(F%s:F%s)", Integer.toString(firstRow), Integer.toString(row - 2)));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)row, (int)8, (int)1, (int)1, (String)String.format("=SUM(H%s:H%s)", Integer.toString(firstRow), Integer.toString(row - 2)));
        }
    }
}

