/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCFlightData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCQuotaData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicketsData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class SUBCF4BWorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_BLOCK_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ArrayList<SUBCAppendixData> appendices = new ArrayList<SUBCAppendixData>();
        for (SUBCAppendixData app : bcdata.getAppendices()) {
            if (app.getType() != SUBlockCharterAppendixType.ONE_WAY) continue;
            appendices.add(app);
        }
        Collections.sort(appendices, new Comparator<SUBCAppendixData>(){

            @Override
            public int compare(SUBCAppendixData o1, SUBCAppendixData o2) {
                return TextUtil.compare((String)o1.getAppendixNumber(), (String)o2.getAppendixNumber(), (boolean)false, (boolean)false);
            }
        });
        for (int n = 0; n < appendices.size(); ++n) {
            int m;
            SUBCAppendixData app;
            app = (SUBCAppendixData)appendices.get(n);
            HSSFSheet ws = wb.cloneSheet(wb.getSheetIndex((Sheet)sheet));
            String route = SUBCReportHelper.getRoute(app.getRoute());
            String name = String.format("OW-%s-%s", app.getAppendixNumber(), route);
            for (int m2 = 0; m2 < wb.getNumberOfSheets(); ++m2) {
                if (!name.equals(wb.getSheetName(m2))) continue;
                throw new IllegalArgumentException(String.format("sheet %s is already present in workbook", name));
            }
            wb.setSheetName(wb.getSheetIndex((Sheet)ws), name);
            ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
            ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
            ExcelUtils.replace((HSSFSheet)ws, (String)"APPENDIX_NUMBER", (String)app.getAppendixNumber());
            ExcelUtils.replace((HSSFSheet)ws, (String)"CONTRACT_NO", (String)app.getContractNumber());
            ExcelUtils.replace((HSSFSheet)ws, (String)"ROUTE", (String)app.getRoute());
            ExcelUtils.replace((HSSFSheet)ws, (String)"APPENDIX_CURRENCY", (String)app.getCurrencyCode());
            ExcelUtils.replace((HSSFSheet)ws, (String)"REPORT_PERIOD", (String)app.getReportPeriod());
            ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_ACCOUNTANT", (String)bcdata.getAccountant());
            ExcelUtils.replace((HSSFSheet)ws, (String)"AGENCY_DIRECTOR", (String)bcdata.getDirector());
            Collections.sort(app.getDates(), new Comparator<SUBCDateData>(){

                @Override
                public int compare(SUBCDateData o1, SUBCDateData o2) {
                    return MiscUtil.compare((Date)o1.getDate(), (Date)o2.getDate(), (boolean)false);
                }
            });
            int totalRowCount = 0;
            for (SUBCDateData item : app.getDates()) {
                for (SUBCFlightData flight : item.getFlights()) {
                    for (SUBCQuotaData quota : flight.getQuotas()) {
                        ++totalRowCount;
                        if (quota.getRegionFlightsData() == null) continue;
                        ++totalRowCount;
                    }
                }
            }
            int currentLine = 14;
            for (m = 0; m < totalRowCount - 1; ++m) {
                ExcelUtils.copyRows((HSSFSheet)ws, (int)(currentLine - 1), (int)(currentLine - 1));
            }
            for (m = 0; m < app.getDates().size(); ++m) {
                SUBCDateData dateData = app.getDates().get(m);
                ArrayList<SUBCTicketsData> ticketsDataList = new ArrayList<SUBCTicketsData>();
                for (SUBCFlightData flight : dateData.getFlights()) {
                    for (SUBCQuotaData quota : flight.getQuotas()) {
                        if (quota.getDirectFlightsData() != null) {
                            ticketsDataList.add(quota.getDirectFlightsData());
                        } else {
                            ticketsDataList.add(new SUBCTicketsData(quota, false));
                        }
                        if (quota.getRegionFlightsData() == null) continue;
                        ticketsDataList.add(quota.getRegionFlightsData());
                    }
                }
                Collections.sort(ticketsDataList, new Comparator<SUBCTicketsData>(){

                    @Override
                    public int compare(SUBCTicketsData t1, SUBCTicketsData t2) {
                        SUBCQuotaData quota1 = t1.getQuota();
                        SUBCQuotaData quota2 = t2.getQuota();
                        int res = TextUtil.compare((String)quota1.getFlight().getFlightNumber(), (String)quota2.getFlight().getFlightNumber(), (boolean)false, (boolean)true);
                        if (res != 0) {
                            return res;
                        }
                        res = quota1.getOneWayTariff().compareTo(quota2.getOneWayTariff());
                        if (res != 0) {
                            return res;
                        }
                        res = quota2.getQuota() - quota1.getQuota();
                        if (res != 0) {
                            return res;
                        }
                        return t1.isRegionFlight() ? 1 : -1;
                    }
                });
                ArrayList<Integer> flightMerge = new ArrayList<Integer>();
                SUBCFlightData lastFlight = null;
                ArrayList<Integer> quotatMerge = new ArrayList<Integer>();
                SUBCQuotaData lastQuota = null;
                for (SUBCTicketsData ticketsData : ticketsDataList) {
                    SUBCQuotaData quotaData = ticketsData.getQuota();
                    if (quotaData.getFlight() != lastFlight) {
                        flightMerge.add(1);
                        lastFlight = quotaData.getFlight();
                    } else {
                        flightMerge.set(flightMerge.size() - 1, (Integer)flightMerge.get(flightMerge.size() - 1) + 1);
                    }
                    boolean setQuotaValue = false;
                    if (quotaData != lastQuota) {
                        setQuotaValue = true;
                        quotatMerge.add(1);
                        lastQuota = quotaData;
                    } else {
                        quotatMerge.set(quotatMerge.size() - 1, (Integer)quotatMerge.get(quotatMerge.size() - 1) + 1);
                    }
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)1, (String)this.dateFormat.format(quotaData.getFlight().getDateData().getDate()));
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)2, (String)quotaData.getFlight().getFlightNumber());
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)3, (String)String.format("%s%s", quotaData.getClassOfBooking(), ticketsData.isRegionFlight() ? "R" : ""));
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)4, (BigDecimal)quotaData.getRtTariff());
                    if (!ticketsData.isRegionFlight() && setQuotaValue) {
                        ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)5, (int)quotaData.getQuota());
                    }
                    int shift1 = quotaData.getFlight().isBackwardDirection() ? 6 : 0;
                    int shift2 = quotaData.getFlight().isBackwardDirection() ? 1 : 0;
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(6 + shift1), (int)ticketsData.getTotalRTSingleClassAdult());
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(7 + shift1), (int)ticketsData.getTotalRTSingleClassInfant());
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(8 + shift1), (int)ticketsData.getTotalRTMixedClassAdult());
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(9 + shift1), (int)ticketsData.getTotalRTMixedClassInfant());
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(10 + shift1), (int)ticketsData.getTotalOWAdult());
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(11 + shift1), (int)ticketsData.getTotalOWInfant());
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(18 + shift2), (int)quotaData.getTotalSoldCount());
                    if (!ticketsData.isRegionFlight()) {
                        ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(20 + shift2), (int)quotaData.getTotalUnsoldCount());
                        ExcelUtils.setCellValue((HSSFSheet)ws, (int)currentLine, (int)1, (int)1, (int)(22 + shift2), (BigDecimal)quotaData.getTotalUnsoldAmount());
                    }
                    ++currentLine;
                }
                int mergeIndex = currentLine - ticketsDataList.size() - 1;
                for (Integer val : flightMerge) {
                    if (val > 1) {
                        ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(mergeIndex, mergeIndex + val - 1, 1, 1));
                    }
                    mergeIndex += val.intValue();
                }
                mergeIndex = currentLine - ticketsDataList.size() - 1;
                for (Integer val : quotatMerge) {
                    if (val > 1) {
                        ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(mergeIndex, mergeIndex + val - 1, 4, 4));
                    }
                    mergeIndex += val.intValue();
                }
                if (ticketsDataList.size() <= 1) continue;
                ws.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(currentLine - ticketsDataList.size() - 1, currentLine - 2, 0, 0));
            }
            ++currentLine;
            for (m = 6; m <= 23; ++m) {
                String ltt = ExcelUtils.indexToLetter((int)m);
                ExcelUtils.setCellFormula((HSSFSheet)ws, (int)currentLine, (int)m, (int)1, (int)1, (String)String.format("SUM(%s14:%1$s%s)", ltt, Integer.toString(currentLine - 1)));
            }
            ExcelUtils.setCellFormula((HSSFSheet)ws, (int)currentLine, (int)20, (int)1, (int)1, (String)String.format("T%s+U%1$s", Integer.toString(++currentLine - 1)));
            ExcelUtils.setCellFormula((HSSFSheet)ws, (int)currentLine, (int)22, (int)1, (int)1, (String)String.format("V%s+W%1$s", Integer.toString(currentLine - 1)));
            ws.getRow(12).setHeight((short)0);
            ws.getRow(currentLine - 3).setHeight((short)0);
        }
        wb.removeSheetAt(wb.getSheetIndex((Sheet)sheet));
    }
}

