/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCQuotaData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SUBCFlightData
implements Serializable {
    private static final long serialVersionUID = 186860451274092854L;
    private String flightNumber;
    private final SUBCDateData dateData;
    private final List<SUBCTicket> directTickets = new ArrayList<SUBCTicket>();
    private final List<SUBCTicket> regionTickets = new ArrayList<SUBCTicket>();
    private final List<SUBCQuotaData> quotas = new ArrayList<SUBCQuotaData>();
    private boolean backwardDirection;

    public SUBCFlightData(SUBCDateData aDateData) {
        this.dateData = aDateData;
        this.dateData.getFlights().add(this);
    }

    public String getFlightNumber() {
        return this.flightNumber;
    }

    public void setFlightNumber(String value) {
        this.flightNumber = value;
    }

    public List<SUBCQuotaData> getQuotas() {
        return this.quotas;
    }

    public SUBCDateData getDateData() {
        return this.dateData;
    }

    public int getTotalUnsoldCount() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalUnsoldCount();
            }
        });
    }

    public int getTotalSoldCount() {
        return this.calculateValue(new IntValueCalculator(){

            @Override
            public int calculateValue(SUBCQuotaData data) {
                return data.getTotalSoldCount();
            }
        });
    }

    public BigDecimal getTotalUnsoldAmount() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCQuotaData data) {
                return data.getTotalUnsoldAmount();
            }
        });
    }

    public BigDecimal getTotalUnsoldEquivalentAmount() {
        return this.calculateValue(new BigDecimalValueCalculator(){

            @Override
            public BigDecimal calculateValue(SUBCQuotaData data) {
                return data.getTotalUnsoldEquivalentAmount();
            }
        });
    }

    private int calculateValue(IntValueCalculator valueCalculator) {
        int n = 0;
        for (SUBCQuotaData quota : this.quotas) {
            n += valueCalculator.calculateValue(quota);
        }
        return n;
    }

    private BigDecimal calculateValue(BigDecimalValueCalculator valueCalculator) {
        BigDecimal result = BigDecimal.ZERO;
        for (SUBCQuotaData quota : this.quotas) {
            result = result.add(valueCalculator.calculateValue(quota));
        }
        return result;
    }

    public List<SUBCTicket> getDirectTickets() {
        return this.directTickets;
    }

    public List<SUBCTicket> getRegionTickets() {
        return this.regionTickets;
    }

    public boolean isBackwardDirection() {
        return this.backwardDirection;
    }

    public void setBackwardDirection(boolean value) {
        this.backwardDirection = value;
    }

    private static interface IntValueCalculator {
        public int calculateValue(SUBCQuotaData var1);
    }

    private static interface BigDecimalValueCalculator {
        public BigDecimal calculateValue(SUBCQuotaData var1);
    }
}

