/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCFlightData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicketsData;
import java.io.Serializable;
import java.math.BigDecimal;

public class SUBCQuotaData
implements Serializable {
    private static final long serialVersionUID = 6334987805037010621L;
    private final SUBCFlightData flight;
    private int quota;
    private String classOfBooking;
    private BigDecimal oneWayTariff;
    private BigDecimal rtTariff;
    private SUBCTicketsData directFlightsData;
    private SUBCTicketsData regionFlightsData;

    public SUBCQuotaData(SUBCFlightData aFlight) {
        this.flight = aFlight;
        this.flight.getQuotas().add(this);
    }

    public void setQuota(int value) {
        this.quota = value;
    }

    public int getQuota() {
        return this.quota;
    }

    public void setClassOfBooking(String value) {
        this.classOfBooking = value;
    }

    public String getClassOfBooking() {
        return this.classOfBooking;
    }

    public int getTotalSoldCount() {
        int res = 0;
        if (this.directFlightsData != null) {
            res = res + this.directFlightsData.getTotalRTSingleClassAdult() + this.directFlightsData.getTotalRTMixedClassAdult() + this.directFlightsData.getTotalOWAdult();
        }
        if (this.regionFlightsData != null) {
            res = res + this.regionFlightsData.getTotalRTSingleClassAdult() + this.regionFlightsData.getTotalRTMixedClassAdult() + this.regionFlightsData.getTotalOWAdult();
        }
        return res;
    }

    public int getTotalUnsoldCount() {
        int res = this.quota;
        if (this.directFlightsData != null) {
            res = res - this.directFlightsData.getTotalRTSingleClassAdult() - this.directFlightsData.getTotalRTMixedClassAdult() - this.directFlightsData.getTotalOWAdult();
        }
        if (this.regionFlightsData != null) {
            res = res - this.regionFlightsData.getTotalRTSingleClassAdult() - this.regionFlightsData.getTotalRTMixedClassAdult() - this.regionFlightsData.getTotalOWAdult();
        }
        return res;
    }

    public BigDecimal getTotalUnsoldEquivalentAmount() {
        return this.calculateEquivalentAmount(this.getTotalUnsoldCount());
    }

    public BigDecimal getTotalUnsoldAmount() {
        return this.calculateAmount(this.getTotalUnsoldCount());
    }

    private BigDecimal calculateAmount(int totalUnsoldCount) {
        return (this.flight.getDateData().getAppendix().getType() == SUBlockCharterAppendixType.ROUND_TRIP ? this.rtTariff : this.oneWayTariff).multiply(BigDecimal.valueOf(totalUnsoldCount));
    }

    private BigDecimal calculateEquivalentAmount(int totalUnsoldCount) {
        return this.calculateAmount(totalUnsoldCount).multiply(this.flight.getDateData().getAppendix().getCurrencyRate());
    }

    public SUBCFlightData getFlight() {
        return this.flight;
    }

    public BigDecimal getOneWayTariff() {
        return this.oneWayTariff;
    }

    public BigDecimal getRtTariff() {
        return this.rtTariff;
    }

    public void setOneWayTariff(BigDecimal value) {
        this.oneWayTariff = value;
    }

    public void setRtTariff(BigDecimal value) {
        this.rtTariff = value;
    }

    public SUBCTicketsData getDirectFlightsData() {
        return this.directFlightsData;
    }

    public void setDirectFlightsData(SUBCTicketsData value) {
        this.directFlightsData = value;
    }

    public SUBCTicketsData getRegionFlightsData() {
        return this.regionFlightsData;
    }

    public void setRegionFlightsData(SUBCTicketsData value) {
        this.regionFlightsData = value;
    }

    public int getTotalRTSingleClassAdult() {
        int res = 0;
        if (this.directFlightsData != null) {
            res += this.directFlightsData.getTotalRTSingleClassAdult();
        }
        if (this.regionFlightsData != null) {
            res += this.regionFlightsData.getTotalRTSingleClassAdult();
        }
        return res;
    }

    public int getTotalRTMixedClassAdult() {
        int res = 0;
        if (this.directFlightsData != null) {
            res += this.directFlightsData.getTotalRTMixedClassAdult();
        }
        if (this.regionFlightsData != null) {
            res += this.regionFlightsData.getTotalRTMixedClassAdult();
        }
        return res;
    }

    public int getTotalRTSingleClassInfant() {
        int res = 0;
        if (this.directFlightsData != null) {
            res += this.directFlightsData.getTotalRTSingleClassInfant();
        }
        if (this.regionFlightsData != null) {
            res += this.regionFlightsData.getTotalRTSingleClassInfant();
        }
        return res;
    }

    public int getTotalRTMixedClassInfant() {
        int res = 0;
        if (this.directFlightsData != null) {
            res += this.directFlightsData.getTotalRTMixedClassInfant();
        }
        if (this.regionFlightsData != null) {
            res += this.regionFlightsData.getTotalRTMixedClassInfant();
        }
        return res;
    }

    public int getTotalOWAdult() {
        int res = 0;
        if (this.directFlightsData != null) {
            res += this.directFlightsData.getTotalOWAdult();
        }
        if (this.regionFlightsData != null) {
            res += this.regionFlightsData.getTotalOWAdult();
        }
        return res;
    }

    public int getTotalOWInfant() {
        int res = 0;
        if (this.directFlightsData != null) {
            res += this.directFlightsData.getTotalOWInfant();
        }
        if (this.regionFlightsData != null) {
            res += this.regionFlightsData.getTotalOWInfant();
        }
        return res;
    }
}

