/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SuBcRegistryWorksheetHandler;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SUBCRefundWorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_BLOCK_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)bcdata.getReportPeriod());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)bcdata.getContractNumber());
        ArrayList<SUBCTicket> tickets = new ArrayList<SUBCTicket>();
        for (SUBCTicket ticket : bcdata.getTickets()) {
            if (ticket.getStatus() != ProductStatus.REFUND && ticket.getStatus() != ProductStatus.EXCHANGE) continue;
            tickets.add(ticket);
        }
        Collections.sort(tickets, SuBcRegistryWorksheetHandler.ticketsComparator);
        int lineNo = 10;
        BigDecimal commEuro = BigDecimal.ZERO;
        BigDecimal commUsd = BigDecimal.ZERO;
        boolean hasEuro = false;
        boolean hasUsd = false;
        for (int n = 0; n < tickets.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)9, (int)9);
        }
        for (SUBCTicket ticket : tickets) {
            if (ticket.getBaseFare() != null && "USD".equals(ticket.getBaseFare().getCurrency())) {
                hasUsd = true;
            }
            if (ticket.getBaseFare() != null && "EUR".equals(ticket.getBaseFare().getCurrency())) {
                hasEuro = true;
            }
            if (ticket.getVendorCommissionValue() != null && "USD".equals(ticket.getVendorCommissionValue().getCurrency())) {
                commUsd = commUsd.add(ticket.getVendorCommissionValue().getValue());
            }
            if (ticket.getVendorCommissionValue() != null && "EUR".equals(ticket.getVendorCommissionValue().getCurrency())) {
                commEuro = commEuro.add(ticket.getVendorCommissionValue().getValue());
            }
            this.populateTicket(sheet, lineNo, ticket);
            ++lineNo;
        }
        if (tickets.isEmpty()) {
            ++lineNo;
        }
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)7, (int)1, (int)1, (String)String.format("=SUM(G9:G%s)", Integer.toString(++lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)8, (int)1, (int)1, (String)String.format("=SUM(H9:H%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)10, (int)1, (int)1, (String)String.format("=SUM(J9:J%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)11, (int)1, (int)1, (String)String.format("=SUM(K9:K%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)12, (int)1, (int)1, (String)String.format("=SUM(L9:L%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)13, (int)1, (int)1, (String)String.format("=SUM(M9:M%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)14, (int)1, (int)1, (String)String.format("=SUM(N9:N%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)15, (int)1, (int)1, (String)String.format("=SUM(O9:O%s)", Integer.toString(lineNo - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNo, (int)16, (int)1, (int)1, (String)String.format("=SUM(P9:P%s)", Integer.toString(lineNo - 1)));
        sheet.getRow(8).setHeight((short)0);
        sheet.getRow(lineNo - 2).setHeight((short)0);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNo + 2), (int)4, (int)1, (int)1, (int)tickets.size());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNo + 3), (int)9, (int)1, (int)1, (BigDecimal)commUsd);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNo + 4), (int)9, (int)1, (int)1, (BigDecimal)commEuro);
        if (hasEuro && !hasUsd && commUsd.compareTo(BigDecimal.ZERO) == 0) {
            sheet.getRow(lineNo + 2).setHeight((short)0);
        }
        if (hasUsd && !hasEuro && commEuro.compareTo(BigDecimal.ZERO) == 0) {
            sheet.getRow(lineNo + 3).setHeight((short)0);
        }
    }

    private void populateTicket(HSSFSheet workSheet, int lineNo, SUBCTicket ticket) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)1, (int)(lineNo - 9));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)2, (String)(ticket.isEticket() ? "ETKT" : ticket.getScn()));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)3, (String)ticket.getTicketNumber());
        if (ticket.getSellDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)4, (String)this.dateFormat.format(ticket.getSellDate()));
        }
        if (ticket.getFirstFlightDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)5, (String)this.dateFormat.format(ticket.getFirstFlightDate()));
        }
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)6, (String)ticket.getFlightNumbers());
        boolean usd = ticket.getBaseFare().getCurrency().equals("USD");
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)(usd ? 7 : 8), ticket.getBaseFare() != null ? ticket.getBaseFare().getValue().negate() : null);
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)9, (String)Double.toString(ticket.getRate()));
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)10, ticket.getEquivalentFare() != null ? ticket.getEquivalentFare().negate() : null);
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)11, ticket.getAirportTaxes() != null ? ticket.getAirportTaxes().negate() : null);
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)12, ticket.getFuelTax() != null ? ticket.getFuelTax().negate() : null);
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)13, ticket.getAeroflotTaxes() != null ? ticket.getAeroflotTaxes().negate() : null);
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)14, (BigDecimal)(ticket.getPenalty() != null ? ticket.getPenalty().negate() : BigDecimal.ZERO));
        ExcelUtils.setCellFormula((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)15, (String)String.format("=SUM(J%s:N%1$s)", Integer.toString(lineNo)));
        Money commissionValue = ticket.getVendorCommissionValue();
        if (commissionValue != null) {
            if ("USD".equals(commissionValue.getCurrency())) {
                ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)16, (BigDecimal)commissionValue.getValue().negate());
            } else {
                ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)17, (BigDecimal)commissionValue.getValue().negate());
            }
        }
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)18, ticket.getVendorEquivalentCommission() != null ? ticket.getVendorEquivalentCommission().negate() : null);
        if (ticket.getIssueDate() != null) {
            ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)19, (String)this.dateFormat.format(ticket.getIssueDate()));
        }
        ExcelUtils.setCellValue((HSSFSheet)workSheet, (int)lineNo, (int)1, (int)1, (int)20, (String)ticket.getRelatedSellNumber());
    }
}

