/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCF3WorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCRefundWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCVoidWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SuBcLetterWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SuBcRegistryWorksheetHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SUBCSellReportRenderer
extends BasePoiSalesReportRenderHandler<SUBCTicket> {
    @Override
    protected List<PoiWorksheetData<SUBCTicket>> createDataList() {
        ArrayList<PoiWorksheetData<SUBCTicket>> result = new ArrayList<PoiWorksheetData<SUBCTicket>>();
        result.add(new BaseWorksheetData<SUBCTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.Pismo.name();
            }

            public Definitions getDefinition() {
                return Definitions.Pismo;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<SUBCTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.Reg.name();
            }

            public Definitions getDefinition() {
                return Definitions.Reg;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        result.add(new BaseWorksheetData<SUBCTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.Void.name();
            }

            public Definitions getDefinition() {
                return Definitions.Void;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<SUBCTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.Refund.name();
            }

            public Definitions getDefinition() {
                return Definitions.Refund;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        result.add(new BaseWorksheetData<SUBCTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.APP2.name();
            }

            public Definitions getDefinition() {
                return Definitions.APP2;
            }

            @Override
            public int getProirity() {
                return 5;
            }
        });
        return result;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        String contractNumber = ((SUBCData)data.get("KEY_BLOCK_CHARTER_DATA")).getContractNumber();
        return String.format("\u041e\u0442\u0447\u0451\u0442 \u043e \u043f\u0440\u043e\u0434\u0430\u0436\u0435 \u0431\u043b\u043e\u0447\u043d\u044b\u0445 \u0430\u0432\u0438\u0430\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 %s \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 %s", contractNumber, data.get("REPORT_PERIOD"));
    }

    @Override
    protected String getTemplateFileName() {
        return "SUBCSellReport.xls";
    }

    @Override
    protected void initializeDataList(List<PoiWorksheetData<SUBCTicket>> dataList, Map<String, Object> data) {
    }

    @Override
    public String getId() {
        return null;
    }

    public static enum Definitions implements PoiWorksheetDefinition<SUBCTicket>
    {
        Pismo{

            @Override
            public BasePoiWorksheetHandler<SUBCTicket> getHandler() {
                return new SuBcLetterWorksheetHandler();
            }
        }
        ,
        Reg{

            @Override
            public BasePoiWorksheetHandler<SUBCTicket> getHandler() {
                return new SuBcRegistryWorksheetHandler();
            }
        }
        ,
        Void{

            @Override
            public BasePoiWorksheetHandler<SUBCTicket> getHandler() {
                return new SUBCVoidWorksheetHandler();
            }
        }
        ,
        Refund{

            @Override
            public BasePoiWorksheetHandler<SUBCTicket> getHandler() {
                return new SUBCRefundWorksheetHandler();
            }
        }
        ,
        APP2{

            @Override
            public BasePoiWorksheetHandler<SUBCTicket> getHandler() {
                return new SUBCF3WorksheetHandler();
            }
        };


        @Override
        public String getWorksheetTemplateName() {
            return this.name();
        }
    }
}

