/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.bc;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SuBcRegistryWorksheetHandler;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

public class SUCharterF4WorksheetHandler
extends BasePoiWorksheetHandler<SUBCTicket> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
    private final DateFormat df2 = new SimpleDateFormat("dd.MM");

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SUBCTicket> data, Map<String, Object> globalData) throws Exception {
        SUBCData bcdata = (SUBCData)globalData.get("KEY_CHARTER_DATA");
        if (bcdata == null) {
            return;
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)bcdata.getContractNumber());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_DECADA", (String)bcdata.getReportDecada());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)bcdata.getAccountant());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)bcdata.getDirector());
        ArrayList<SUBCDateData> dates = new ArrayList<SUBCDateData>();
        for (SUBCAppendixData app : bcdata.getAppendices()) {
            for (SUBCDateData date : app.getDates()) {
                dates.add(date);
            }
        }
        Collections.sort(dates, new Comparator<SUBCDateData>(){

            @Override
            public int compare(SUBCDateData o1, SUBCDateData o2) {
                int res = MiscUtil.compare((Date)o1.getDate(), (Date)o2.getDate());
                if (res != 0) {
                    return res;
                }
                return this.getIndex(o1) - this.getIndex(o2);
            }

            private int getIndex(SUBCDateData o1) {
                return o1.getAppendix().getType() == SUBlockCharterAppendixType.ROUND_TRIP ? 0 : 1;
            }
        });
        for (int n = 0; n < dates.size(); ++n) {
            SUBCDateData dateData = (SUBCDateData)dates.get(n);
            HSSFSheet ws = wb.cloneSheet(wb.getSheetIndex((Sheet)sheet));
            String route = SUBCReportHelper.getRoute(dateData.getAppendix().getRoute());
            String name = dateData.getAppendix().getAppendixNumber() + "-" + route + "-" + this.df2.format(dateData.getDate());
            wb.setSheetName(wb.getSheetIndex((Sheet)ws), name);
            ExcelUtils.replace((HSSFSheet)ws, (String)"APPENDIX_NUMBER", (String)dateData.getAppendix().getAppendixNumber());
            ExcelUtils.replace((HSSFSheet)ws, (String)"CONTRACT_NO", (String)dateData.getAppendix().getContractNumber());
            ExcelUtils.replace((HSSFSheet)ws, (String)"ROUTE", (String)dateData.getAppendix().getRoute());
            ExcelUtils.replace((HSSFSheet)ws, (String)"FLIGHT_DATE", (String)this.dateFormat.format(dateData.getDate()));
            ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)bcdata.getAgentCode());
            ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)bcdata.getAgentName());
            ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)bcdata.getContractNumber());
            ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_DECADA", (String)bcdata.getReportDecada());
            ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)bcdata.getAccountant());
            ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)bcdata.getDirector());
            List<SUBCTicket> lst = dateData.getDirectTickets();
            Collections.sort(lst, SuBcRegistryWorksheetHandler.ticketsComparator);
            for (int m = 0; m < lst.size() - 1; ++m) {
                ExcelUtils.copyRows((HSSFSheet)ws, (int)13, (int)13);
            }
            int ticketsCount = 0;
            for (int m = 0; m < lst.size(); ++m) {
                SUBCTicket ticket = lst.get(m);
                if (ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE) {
                    --ticketsCount;
                } else if (ticket.getStatus() == ProductStatus.SELL) {
                    ++ticketsCount;
                }
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)14, (int)1, (int)(m + 1), (int)1, (int)(m + 1));
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)14, (int)1, (int)(m + 1), (int)2, (String)ticket.getTicketNumber());
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)14, (int)1, (int)(m + 1), (int)3, (String)(ticket.isEticket() ? "ETKT" : ticket.getScn()));
                if (ticket.getIssueDate() != null) {
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)14, (int)1, (int)(m + 1), (int)4, (String)this.dateFormat.format(ticket.getIssueDate()));
                }
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)14, (int)1, (int)(m + 1), (int)5, (String)ticket.getClassOfService());
                if (ticket.getStatus() == ProductStatus.VOID || ticket.getStatus() == ProductStatus.VOID_BOOKING) {
                    ExcelUtils.setCellValue((HSSFSheet)ws, (int)14, (int)1, (int)(m + 1), (int)6, (String)L10nResourcesManager.createL10nMessage((String)Messages.SUCharter_voided, (Object[])new Object[0]).toString());
                }
                if (ticket.getStatus() != ProductStatus.REFUND) continue;
                ExcelUtils.setCellValue((HSSFSheet)ws, (int)14, (int)1, (int)(m + 1), (int)6, (String)L10nResourcesManager.createL10nMessage((String)Messages.SUCharter_refunded, (Object[])new Object[0]).toString());
            }
            ws.getRow(12).setHeight((short)0);
            int delta = lst.isEmpty() ? 0 : lst.size() - 1;
            ws.getRow(14 + delta).setHeight((short)0);
            ExcelUtils.setCellValue((HSSFSheet)ws, (int)(16 + delta), (int)1, (int)1, (int)3, (int)ticketsCount);
        }
        wb.removeSheetAt(wb.getSheetIndex((Sheet)sheet));
    }
}

