/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.registry;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuRegistryRegisterListWorksheetHandler
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        ArrayList tickets = (ArrayList)data.getTickets();
        Iterator iter = tickets.iterator();
        while (iter.hasNext()) {
            BaseSalesReportTicket ticket = (BaseSalesReportTicket)iter.next();
            if (ticket.getMcoCategory() == null || !ticket.getMcoCategory().equals((Object)MCOCategory.NOT_SOLD_SEATS)) continue;
            iter.remove();
        }
        if (tickets.isEmpty()) {
            return;
        }
        String equivCurrency = SalesReportHelper.getEquivCurrency(null).toString();
        int lineNumber = 2;
        for (int n = 0; n < tickets.size(); ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)(lineNumber - 1), (int)(lineNumber - 1));
        }
        for (BaseSalesReportTicket t : tickets) {
            double RU;
            SuTicket ticket = (SuTicket)t;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)1, (int)(lineNumber - 1));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)2, (int)ticket.getBatchNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)3, (String)ticket.getBatchType());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)4, (int)ticket.getTransactionNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)5, (String)(ticket.getTicketSeries() + " " + ticket.getTicketNumber()));
            if (ticket.getConjCount() > 0) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)6, (String)"\u0414\u0410");
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)7, (String)ticket.getTransactionCode());
            if (ticket.getStatus() != ProductStatus.VOID) {
                if (ticket.isVatIncluded()) {
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)8, (String)"\u0414\u0410");
                } else {
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)8, (String)"\u041d\u0415\u0422");
                }
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)9, (String)equivCurrency);
            }
            BigDecimal equivalentFare = BigDecimal.ZERO;
            BigDecimal taxRu = BigDecimal.ZERO;
            BigDecimal taxYQ = BigDecimal.ZERO;
            BigDecimal taxYR = BigDecimal.ZERO;
            BigDecimal taxOther = BigDecimal.ZERO;
            BigDecimal commRate = BigDecimal.ZERO;
            BigDecimal comm = BigDecimal.ZERO;
            if (!(ticket.isDuplicate() || ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.PENALTY && ticket.getMcoCategory() == MCOCategory.ADDITIONAL_TARIFF && ticket.getMcoCategory() == MCOCategory.REBOOKING)) {
                if (ticket.getTariffType() == TariffType.GROUP && ticket.getPrepayed() != null && ticket.getEquivalentFare() != null) {
                    equivalentFare = ticket.getEquivalentFare().subtract(ticket.getPrepayed());
                } else if (ticket.getMcoCategory() != MCOCategory.STICKER && ticket.getMcoCategory() != MCOCategory.UNESCORTED_MINOR && ticket.getMcoCategory() != MCOCategory.INFORMATION && ticket.getMcoCategory() != MCOCategory.COMFORT_PLUS) {
                    equivalentFare = ticket.getEquivalentFare();
                    if ("REFUND".equals(ticket.getBatchType()) && ProductCategory.MCO == ticket.getProductCategory() && BigDecimal.ZERO.compareTo(ticket.getEquivalentFare()) < 0) {
                        equivalentFare = MiscUtil.negate((BigDecimal)ticket.getEquivalentFare());
                    }
                }
                RU = ticket.getTaxEquivAmountByCode("RU");
                double YQ = ticket.getTaxEquivAmountByCode("YQ");
                double YR = ticket.getTaxEquivAmountByCode("YR");
                taxRu = BigDecimal.valueOf(RU);
                taxYQ = BigDecimal.valueOf(YQ);
                taxYR = BigDecimal.valueOf(YR);
                taxOther = BigDecimal.valueOf(ticket.getTaxAmount() - RU - YQ - YR);
                if (ticket.getVendorCommissionRate() != null) {
                    commRate = BigDecimal.valueOf(ticket.getVendorCommissionRate());
                }
                comm = ticket.getVendorEquivalentCommission();
            }
            if (ticket.isDuplicate()) {
                RU = ticket.getTaxEquivAmountByCode("RU");
                double DL = ticket.getTaxEquivAmountByCode("DL");
                if (ticket.getRelatedProducts().length > 0) {
                    RU = this.updateDuplicateByRuTax(RU, ticket.getRelatedProducts()[0]);
                }
                taxRu = BigDecimal.valueOf(RU);
                taxOther = BigDecimal.valueOf(DL);
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)10, (BigDecimal)equivalentFare);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)11, (BigDecimal)taxOther);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)12, (BigDecimal)taxYQ);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)13, (BigDecimal)taxYR);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)14, (BigDecimal)taxRu);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)15, (BigDecimal)commRate);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)16, (BigDecimal)comm);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)17, (String)String.valueOf(ticket.getFopCodes() == null || ticket.getStatus() == ProductStatus.VOID ? "" : ticket.getFopCodes()));
            if (ticket.isEticket()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)18, (String)"E");
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)18, (String)ticket.getScn());
            }
            ++lineNumber;
        }
        sheet.autoSizeColumn(4);
        sheet.autoSizeColumn(16);
    }

    private double updateDuplicateByRuTax(double value, Product firstProduct) {
        return BigDecimal.valueOf(value).subtract(AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Product)firstProduct, (String[])new String[]{"RU"})).doubleValue();
    }
}

