/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.saleregisters;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuRefundWorksheetHandler
extends BaseRegistryWorksheetHandler {
    protected static final int START_ROW_INDEX = 11;
    protected static final int ROW_SHIFT_AMOUNT = 9;
    protected static final int COLUMN_AMOUNT = 12;
    private final BaseRegistryWorksheetHandler.IColumn[] columns = new BaseRegistryWorksheetHandler.IColumn[]{Column.TICKET_FARE, Column.OTHER_TAXES, Column.FUEL_TAX, Column.YR_TAX, Column.RU_TAX, Column.PENALTY};
    private final BaseRegistryWorksheetHandler.IColumn[] comm = new BaseRegistryWorksheetHandler.IColumn[]{Column.COMMISSION};

    @Override
    protected void setFieldValue(BaseSalesReportTicket argTicket, int itemIndex, BaseRegistryWorksheetHandler.IColumn column) throws Exception {
        SuTicket ticket = (SuTicket)argTicket;
        switch ((Column)column) {
            case ITEM_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (int)(itemIndex + 1));
                break;
            }
            case TICKET_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketNumber());
                break;
            }
            case TICKET_ISSUE_DATE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (Date)ticket.getIssueDate());
                break;
            }
            case TICKET_SCN: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getScn());
                break;
            }
            case TICKET_COUPONS: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getCouponNumbers());
                break;
            }
            case TICKET_FARE: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getEquivalentFare());
                break;
            }
            case OTHER_TAXES: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getOtherTaxAmount()));
                break;
            }
            case FUEL_TAX: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("YQ")));
                break;
            }
            case YR_TAX: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("YR")));
                break;
            }
            case RU_TAX: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)BigDecimal.valueOf(ticket.getTaxEquivAmountByCode("RU")));
                break;
            }
            case COMMISSION: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getVendorEquivalentCommission());
                break;
            }
            case PENALTY: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (BigDecimal)ticket.getPenalty());
                break;
            }
        }
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        this.init(sheet, 11, 9, 12);
        super.fill(wb, sheet, data, globalData);
    }

    @Override
    protected void fillSubtotal(int startRow, int endRow) throws Exception {
        this.setSubtotalForColumn(this.columns, this.currentRow, startRow, endRow);
        this.setSubtotalForColumn(this.comm, this.currentRow + 1, startRow, endRow);
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 1), (int)1, (int)1, (int)Column.TICKET_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.TICKET_FARE.getExcelColumn().getColumnName(), this.currentRow, 9));
    }

    @Override
    public BaseRegistryWorksheetHandler.IColumn[] getColumns() {
        return Column.values();
    }

    @Override
    protected void fillTotal() throws Exception {
        this.setTotalFormulaForColumn(this.columns, this.currentRow + 2);
        this.setTotalFormulaForColumn(this.comm, this.currentRow + 3);
        ExcelUtils.setCellFormula((HSSFSheet)this.currentSheet, (int)(this.currentRow + 3), (int)1, (int)1, (int)Column.TICKET_FARE.getExcelColumn().getColumnIndex(), (String)String.format("%1$s%2$d*%1$s%3$d", Column.TICKET_FARE.getExcelColumn().getColumnName(), this.currentRow + 2, 9));
    }

    private static enum Column implements BaseRegistryWorksheetHandler.IColumn
    {
        ITEM_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.A;
            }
        }
        ,
        TICKET_SCN{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.B;
            }
        }
        ,
        TICKET_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.C;
            }
        }
        ,
        TICKET_ISSUE_DATE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.D;
            }
        }
        ,
        TICKET_COUPONS{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.E;
            }
        }
        ,
        TICKET_FARE{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.F;
            }
        }
        ,
        COMMISSION{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.G;
            }
        }
        ,
        OTHER_TAXES{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.H;
            }
        }
        ,
        FUEL_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.I;
            }
        }
        ,
        YR_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.J;
            }
        }
        ,
        RU_TAX{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.K;
            }
        }
        ,
        PENALTY{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.L;
            }
        };

    }
}

