/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.su.saleregisters;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.ExcelColumn;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuVoidWorksheetHandler
extends BaseRegistryWorksheetHandler {
    protected static final int START_ROW_INDEX = 8;
    protected static final int ROW_SHIFT_AMOUNT = 6;
    protected static final int COLUMN_AMOUNT = 3;

    @Override
    protected void setFieldValue(BaseSalesReportTicket argTicket, int itemIndex, BaseRegistryWorksheetHandler.IColumn column) throws Exception {
        SuTicket ticket = (SuTicket)argTicket;
        switch ((Column)column) {
            case ITEM_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (int)(itemIndex + 1));
                break;
            }
            case TICKET_NUMBER: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getTicketNumber());
                break;
            }
            case TICKET_SCN: {
                ExcelUtils.setCellValue((HSSFSheet)this.currentSheet, (int)this.currentRow, (int)1, (int)1, (int)column.getExcelColumn().getColumnIndex(), (String)ticket.getScn());
                break;
            }
        }
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        List bags;
        this.init(sheet, 8, 6, 3);
        this.updateGlobalData(sheet, globalData);
        ArrayList tickets = (ArrayList)data.getTickets();
        Map ticketsMap = SalesReportHelper.splitTicketsByProductCategory(tickets);
        List list = bags = ticketsMap == null ? null : ticketsMap.get(ProductCategory.EXCESS_BAGAGE.name());
        if (bags != null) {
            tickets.removeAll(bags);
        }
        if (tickets.isEmpty() && (bags == null || bags.isEmpty())) {
            return;
        }
        int count = 0;
        for (BaseSalesReportTicket tkt : tickets) {
            SuTicket ticket = (SuTicket)tkt;
            this.addRow(ticket, Column.values(), count < tickets.size() - 1);
            ++this.currentItemIndex;
        }
        if (bags != null && !bags.isEmpty()) {
            this.addSplitRow(L10nResourcesManager.createL10nMessage((String)Messages.SomeWorksheetHandler_baggageTitle, (Object[])new Object[0]).toString(), Column.values());
            this.currentItemIndex = 0;
            count = 0;
            for (BaseSalesReportTicket bag : bags) {
                if (!(bag instanceof SuTicket)) continue;
                SuTicket bg = (SuTicket)bag;
                if (bag.isEticket() || bg.getScn() == null || bg.getScn().isEmpty()) continue;
                this.addRow(bg, Column.values(), count < bags.size() - 1);
                ++this.currentItemIndex;
                ++count;
            }
        }
    }

    @Override
    protected void fillSubtotal(int startRow, int endRow) throws Exception {
    }

    @Override
    public BaseRegistryWorksheetHandler.IColumn[] getColumns() {
        return Column.values();
    }

    @Override
    protected void fillTotal() throws Exception {
    }

    private static enum Column implements BaseRegistryWorksheetHandler.IColumn
    {
        ITEM_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.A;
            }
        }
        ,
        TICKET_SCN{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.B;
            }
        }
        ,
        TICKET_NUMBER{

            @Override
            public ExcelColumn getExcelColumn() {
                return ExcelColumn.C;
            }
        };

    }
}

