/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch;

import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipSummaryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipTicket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TchVipReportRenderHandler
extends BasePoiSalesReportRenderHandler<TchVipTicket> {
    @Override
    protected List<PoiWorksheetData<TchVipTicket>> createDataList() {
        ArrayList<PoiWorksheetData<TchVipTicket>> dataList = new ArrayList<PoiWorksheetData<TchVipTicket>>();
        for (final Definition item : Definition.values()) {
            dataList.add((PoiWorksheetData<TchVipTicket>)new BaseWorksheetData<TchVipTicket>(){

                @Override
                public String getBatchId() {
                    return item.name();
                }

                @Override
                public PoiWorksheetDefinition<TchVipTicket> getDefinition() {
                    return item;
                }

                @Override
                public int getProirity() {
                    return item.ordinal() + 1;
                }
            });
        }
        return dataList;
    }

    @Override
    protected String getTemplateFileName() {
        return "TchVipReport.xls";
    }

    @Override
    public String getId() {
        return "tch-vip-sales-report";
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return String.format("VIP_TCH%s", data.get("KEY_REPORT_FILENAME"));
    }

    public static enum Definition implements PoiWorksheetDefinition<TchVipTicket>
    {
        SUMMARY_MVL{

            @Override
            public PoiWorksheetHandler<TchVipTicket> getHandler() {
                return new TchVipSummaryWorksheetHandler(true);
            }
        }
        ,
        REGISTRY_MVL{

            @Override
            public PoiWorksheetHandler<TchVipTicket> getHandler() {
                return new TchVipRegistryWorksheetHandler();
            }
        }
        ,
        SUMMARY_VVL{

            @Override
            public PoiWorksheetHandler<TchVipTicket> getHandler() {
                return new TchVipSummaryWorksheetHandler(false);
            }
        }
        ,
        REGISTRY_VVL{

            @Override
            public PoiWorksheetHandler<TchVipTicket> getHandler() {
                return new TchVipRegistryWorksheetHandler();
            }
        };


        @Override
        public String getWorksheetTemplateName() {
            return this.name();
        }
    }
}

