/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class TchVipTicket
extends BaseReportTicket {
    private static final long serialVersionUID = 4353516968235800290L;
    private boolean mvl;
    private BigDecimal penalty;
    private BigDecimal taxForBlankAmount;
    private BigDecimal otherTaxesAmount;
    private BigDecimal supplierCommissionPercent;
    private BigDecimal supplierCommissonAmount;
    private String ticketBlankNumber;

    public TchVipTicket() {
    }

    public TchVipTicket(Product product, List<Message> messages) throws Exception {
        super(product, messages);
        this.setUid(product.getUid());
        if (product.getBlankType() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchVipTicket_noBlank, (Object[])new Object[]{product.getSystemNumber()}));
        }
        this.ticketSeries = AirProductHelper.getTicketSeries((Product)product);
        if (TextUtil.isBlank((String)this.ticketSeries)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchVip_noSeries, (Object[])new Object[]{product.getSystemNumber()}));
        }
        if (TextUtil.isBlank((String)this.ticketNumber) || this.ticketNumber.length() < 3) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchVip_noTicketNumber, (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation())}));
        }
        this.mvl = this.isMvl(product);
        if (product.getProductCategory() == ProductCategory.MCO && product.getMcoCategory() != MCOCategory.PTA) {
            Product rp = AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
            if (rp != null) {
                this.mvl = this.isMvl(rp);
            } else {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchVipTicket_noConnectedTicket, (Object[])new Object[]{product.getSystemNumber()}));
            }
        }
        if (this.ticketNumber != null && this.ticketNumber.length() > 3) {
            this.ticketBlankNumber = this.ticketNumber.substring(3);
        }
        this.equivalentFare = this.getNotNullValue(this.equivalentFare);
        this.taxForBlankAmount = AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)product);
        this.otherTaxesAmount = AirProductTaxHelper.getEquivalentTaxesAmount((Product)product).subtract(this.taxForBlankAmount);
        this.supplierCommissionPercent = this.getNotNullValue(AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
        this.supplierCommissonAmount = this.getNotNullValue(AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)));
        this.penalty = this.getNotNullValue(product.getPenalty());
        if (BigDecimal.ZERO.compareTo(this.penalty) != 0) {
            BigDecimal total = BigDecimal.ZERO;
            for (Product item : AirProductHelper.getMcoByRelatedProduct((Product)product)) {
                BigDecimal ef;
                if (item.getMcoCategory() != MCOCategory.PENALTY || (ef = AirProductHelper.getEquivalentFare((Product)item)) == null) continue;
                total = total.add(ef);
            }
            if (total.compareTo(BigDecimal.ZERO) != 0) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.TchVipTicket_penaltyToIngore, (Object[])new Object[]{product.getSystemNumber()}));
            }
        }
        if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            TchVipTicket et = new TchVipTicket(product.getPreviousProduct(), messages);
            this.taxForBlankAmount = this.taxForBlankAmount.subtract(et.taxForBlankAmount);
            this.otherTaxesAmount = this.otherTaxesAmount.subtract(et.otherTaxesAmount);
            this.supplierCommissonAmount = this.supplierCommissonAmount.subtract(et.supplierCommissonAmount);
            this.equivalentFare = this.equivalentFare.subtract(et.equivalentFare);
            this.status = ProductStatus.EXCHANGE;
        }
        if (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING) {
            this.status = ProductStatus.VOID;
            this.taxForBlankAmount = BigDecimal.ZERO;
            this.otherTaxesAmount = BigDecimal.ZERO;
            this.supplierCommissonAmount = BigDecimal.ZERO;
            this.supplierCommissionPercent = BigDecimal.ZERO;
            this.equivalentFare = BigDecimal.ZERO;
        }
    }

    private boolean isMvl(Product product) {
        return AirProductHelper.getTransportationType((Product)product) != TransportationType.DOMESTIC;
    }

    private BigDecimal getNotNullValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public boolean isMvl() {
        return this.mvl;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public BigDecimal getTaxForBlankAmount() {
        return this.taxForBlankAmount;
    }

    public BigDecimal getOtherTaxesAmount() {
        return this.otherTaxesAmount;
    }

    public BigDecimal getSupplierCommissionPercent() {
        return this.supplierCommissionPercent;
    }

    public BigDecimal getSupplierCommissonAmount() {
        return this.supplierCommissonAmount;
    }

    public String getTicketBlankNumber() {
        return this.ticketBlankNumber;
    }
}

