/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;

abstract class BaseTchWorksheetHandler<T extends TchTicket>
extends BasePoiWorksheetHandler<TchTicket> {
    BaseTchWorksheetHandler() {
    }

    @Override
    protected void updateGlobalData(HSSFSheet sheet, Map<String, Object> data) {
        super.updateGlobalData(sheet, data);
        SimpleDateFormat df1 = new SimpleDateFormat("MMMM yyyy", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CURRENT_DATE", (String)df1.format(new Date()));
        df1 = new SimpleDateFormat("dd", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CURRENT_DAY", (String)df1.format(new Date()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"TCH_AGENCY_CODE", (String)((String)data.get("key-tch-agency-code")));
    }

    protected BigDecimal getBigDecimal(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    protected BigDecimal getNonZeroBigDecimal(BigDecimal ... values) {
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            if (value == null) continue;
            sum = sum.add(value);
        }
        return BigDecimal.ZERO.compareTo(sum) == 0 ? null : sum;
    }

    protected void updateField(HSSFSheet sheet, int originX, int originY, int i, int j, StringBuilder summFare) throws Exception {
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)i, (int)j, (String)(summFare.length() == 0 ? null : summFare.toString()));
    }

    protected void addSummItem(StringBuilder summFare, BigDecimal fare, String column, int row) {
        if (fare == null || fare.doubleValue() == 0.0) {
            return;
        }
        if (summFare.length() == 0) {
            summFare.append("=").append(column).append(row);
            return;
        }
        summFare.append("+").append(column).append(row);
    }
}

