/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchRegistryItem;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Comparator;

final class BatchComparator
implements Comparator<TchRegistryItem>,
Serializable {
    private static final long serialVersionUID = -2275498425145299893L;
    private static BatchComparator instance;

    private BatchComparator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static BatchComparator get() {
        if (instance != null) return instance;
        Class<BatchComparator> clazz = BatchComparator.class;
        synchronized (BatchComparator.class) {
            if (instance != null) return instance;
            instance = new BatchComparator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public int compare(TchRegistryItem o1, TchRegistryItem o2) {
        int batch2;
        int batch1 = o1.getBatch();
        if (batch1 > (batch2 = o2.getBatch())) {
            return -1;
        }
        if (batch1 < batch2) {
            return 1;
        }
        String ticketNo2 = o2.getSortTicketNumber();
        String ticketNo1 = o1.getSortTicketNumber();
        int tnComp = TextUtil.compare((String)ticketNo1, (String)ticketNo2, (boolean)false, (boolean)true);
        if (tnComp != 0) {
            return tnComp;
        }
        int mcoCategory2 = o2.getMcoCategory();
        int mcoCategory1 = o1.getMcoCategory();
        if (mcoCategory1 < mcoCategory2) {
            return 1;
        }
        if (mcoCategory1 > mcoCategory2) {
            return -1;
        }
        boolean exchange2 = o2.isExchange();
        boolean exchange1 = o1.isExchange();
        if (exchange1 && !exchange2) {
            return 1;
        }
        if (!exchange1 && exchange2) {
            return -1;
        }
        boolean segment1 = o1.isSegment();
        boolean segment2 = o2.isSegment();
        if (segment1 && !segment2) {
            return 1;
        }
        if (!segment1 && segment2) {
            return -1;
        }
        return 0;
    }
}

