/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BaseTchWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BatchComparator;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BatchTotalInfo;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.CashierInfo;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.LotInfo;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.SplitTicketsHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchRegistryItem;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TicketBatches;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TicketsComparator;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TicketsGroup;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

public class TchRegistryListWorksheetHandler
extends BaseTchWorksheetHandler<TchTicket> {
    private static final String PACK_NUMBER = "PACK_NUMBER";
    static final int TICKET_STATUS_REFUND = 1;
    static final int TICKET_STATUS_SELL = 2;
    static final int TICKET_STATUS_EXCHANGE = 3;
    static final int TICKET_STATUS_VOID = 4;
    public static final String KEY_SUMMARY_DATA = "key-summary-data";
    private final SplitTicketsHelper.TchReportRegistriesSetType registriesType;

    public TchRegistryListWorksheetHandler(SplitTicketsHelper.TchReportRegistriesSetType type) {
        this.registriesType = type;
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<TchTicket> data, Map<String, Object> globalData) throws Exception {
        int n;
        super.fill(wb, sheet, data, globalData);
        globalData.remove(KEY_SUMMARY_DATA);
        ArrayList<String> sheetNames = new ArrayList<String>();
        List<TicketBatches> prepareData = this.prepareData(data, globalData);
        for (TicketBatches ticketBatches : prepareData) {
            String groupCode = ticketBatches.getGroupCode();
            for (Map.Entry<String, List<List<TchRegistryItem>>> entry : ticketBatches.getTickets().entrySet()) {
                String batchCode = entry.getKey();
                for (int n2 = 0; n2 < entry.getValue().size(); ++n2) {
                    String sheetName = TchRegistryListWorksheetHandler.buildWorksheetName(groupCode, batchCode, n2 + 1);
                    if (sheetName.length() > 31) {
                        throw Xeption.forEndUser((String)"\u0434\u043b\u0438\u043d\u0430 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \"{0}\" \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 31 \u0441\u0438\u043c\u0432\u043e\u043b", (Object[])new Object[]{sheetName});
                    }
                    sheetNames.add(sheetName);
                }
            }
        }
        int sheetsCount = sheetNames.size();
        int sheetIndex = wb.getSheetIndex((Sheet)sheet);
        if (sheetsCount == 0) {
            wb.removeSheetAt(sheetIndex);
            return;
        }
        wb.setSheetName(sheetIndex, (String)sheetNames.get(sheetsCount - 1));
        for (n = sheetsCount - 2; n >= 0; --n) {
            HSSFSheet sheet2 = wb.cloneSheet(sheetIndex);
            wb.setSheetName(wb.getSheetIndex((Sheet)sheet2), (String)sheetNames.get(n));
            super.fill(wb, sheet2, data, globalData);
        }
        for (n = sheetsCount - 1; n >= 0; --n) {
            wb.setSheetOrder((String)sheetNames.get(n), sheetIndex);
        }
        ArrayList<BatchTotalInfo> totalInfos = new ArrayList<BatchTotalInfo>();
        HashSet<String> mtdNumbers = new HashSet<String>();
        for (TicketBatches ticketBatches : prepareData) {
            String groupCode = ticketBatches.getGroupCode();
            BatchTotalInfo batchTotalInfo = new BatchTotalInfo();
            batchTotalInfo.setGroupCode(groupCode);
            totalInfos.add(batchTotalInfo);
            batchTotalInfo.setAgencyCode((String)globalData.get("key-tch-agency-code"));
            batchTotalInfo.setCurrencyCode("RUB");
            batchTotalInfo.setBeginDate(((ReportParameters)globalData.get("key-report-params")).getPeriodBegin());
            batchTotalInfo.setEndDate(((ReportParameters)globalData.get("key-report-params")).getPeriodEnd());
            int totalTicketNo = 0;
            int totalCouponNo = 0;
            int totalMTD = 0;
            int batchNo = 0;
            BigDecimal totalCash = BigDecimal.ZERO;
            BigDecimal totalCard = BigDecimal.ZERO;
            BigDecimal totalVZ = BigDecimal.ZERO;
            BigDecimal totalKR = BigDecimal.ZERO;
            BigDecimal totalPTA = BigDecimal.ZERO;
            for (Map.Entry<String, List<List<TchRegistryItem>>> entry : ticketBatches.getTickets().entrySet()) {
                String batchCode = entry.getKey();
                List<List<TchRegistryItem>> batches = entry.getValue();
                for (int n3 = 0; n3 < batches.size(); ++n3) {
                    String worksheetName = TchRegistryListWorksheetHandler.buildWorksheetName(groupCode, batchCode, n3 + 1);
                    HSSFSheet vSheet = wb.getSheet(worksheetName);
                    List<TchRegistryItem> batch = batches.get(n3);
                    ExcelUtils.replace((HSSFSheet)vSheet, (String)PACK_NUMBER, (String)String.valueOf(++batchNo));
                    int ticketNo = 0;
                    int couponNo = 0;
                    int pageTotalMtd = 0;
                    BigDecimal pageTotalCash = BigDecimal.ZERO;
                    BigDecimal pageTotalCard = BigDecimal.ZERO;
                    BigDecimal pageTotalVZ = BigDecimal.ZERO;
                    BigDecimal pageTotalKR = BigDecimal.ZERO;
                    BigDecimal pageTotalPTA = BigDecimal.ZERO;
                    int batchSize = batch.size();
                    for (int m = 0; m < batchSize; ++m) {
                        BigDecimal ptaValue;
                        BigDecimal interlineValue;
                        BigDecimal creditValue;
                        BigDecimal cardValue;
                        TchRegistryItem item = batch.get(m);
                        if (m != 0) {
                            ExcelUtils.copyRows((HSSFSheet)vSheet, (int)(1 + m), (int)(1 + m));
                        }
                        int originX = 3 + m;
                        int originY = 1;
                        boolean exchange = item.isExchange();
                        int batchIndex = item.getBatch();
                        if (!TextUtil.isBlank((String)item.getMtdNumber()) && !mtdNumbers.contains(item.getMtdNumber())) {
                            ++pageTotalMtd;
                            ++totalMTD;
                            mtdNumbers.add(item.getMtdNumber());
                        }
                        if (batchIndex == 1 && item.getMcoCategory() == 0 || batchIndex == 3 && exchange) {
                            ++totalCouponNo;
                            this.updateCashierInfo(batchTotalInfo, batchNo, item.getValidator(), item.getCashier(), false, true);
                            ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)2, (int)(++couponNo));
                            ExcelUtils.clearCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)1);
                        } else {
                            ++totalTicketNo;
                            this.updateCashierInfo(batchTotalInfo, batchNo, item.getValidator(), item.getCashier(), true, false);
                            ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)1, (int)(++ticketNo));
                            ExcelUtils.clearCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)2);
                        }
                        ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)4, (BigDecimal)item.getCashValue());
                        ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)5, (BigDecimal)item.getCreditValue());
                        ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)6, (BigDecimal)item.getInterlineValue());
                        ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)7, (BigDecimal)item.getCardValue());
                        ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)8, (BigDecimal)item.getPtaValue());
                        ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)3, (String)item.getTicketNumber());
                        BigDecimal cashValue = item.getCashValue();
                        if (cashValue != null) {
                            pageTotalCash = pageTotalCash.add(cashValue);
                        }
                        if ((cardValue = item.getCardValue()) != null) {
                            pageTotalCard = pageTotalCard.add(cardValue);
                        }
                        if ((creditValue = item.getCreditValue()) != null) {
                            pageTotalKR = pageTotalKR.add(creditValue);
                        }
                        if ((interlineValue = item.getInterlineValue()) != null) {
                            pageTotalVZ = pageTotalVZ.add(interlineValue);
                        }
                        if ((ptaValue = item.getPtaValue()) == null) continue;
                        pageTotalPTA = pageTotalPTA.add(ptaValue);
                    }
                    totalCash = totalCash.add(pageTotalCash);
                    totalCard = totalCard.add(pageTotalCard);
                    totalKR = totalKR.add(pageTotalKR);
                    totalVZ = totalVZ.add(pageTotalVZ);
                    totalPTA = totalPTA.add(pageTotalPTA);
                    int originX = batchSize + 3;
                    int originY = 4;
                    ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)1, (BigDecimal)this.getNonZeroBigDecimal(pageTotalCash));
                    ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)4, (BigDecimal)this.getNonZeroBigDecimal(pageTotalCard));
                    ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)2, (BigDecimal)this.getNonZeroBigDecimal(pageTotalKR));
                    ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)3, (BigDecimal)this.getNonZeroBigDecimal(pageTotalVZ));
                    ExcelUtils.setCellValue((HSSFSheet)vSheet, (int)originX, (int)originY, (int)1, (int)5, (BigDecimal)this.getNonZeroBigDecimal(pageTotalPTA));
                    LotInfo lotInfo = new LotInfo();
                    batchTotalInfo.getLotsInfo().add(lotInfo);
                    lotInfo.setCouponsCount(couponNo);
                    lotInfo.setTicketsCount(ticketNo);
                    lotInfo.setTotalCA("='" + worksheetName + "'!D" + originX);
                    lotInfo.setTotalKR("='" + worksheetName + "'!E" + originX);
                    lotInfo.setTotalVZ("='" + worksheetName + "'!F" + originX);
                    lotInfo.setTotalCC("='" + worksheetName + "'!G" + originX);
                    lotInfo.setTotalPTA("='" + worksheetName + "'!H" + originX);
                    lotInfo.setMtdCount(pageTotalMtd);
                }
            }
            batchTotalInfo.setTotalCard(totalCard);
            batchTotalInfo.setTotalCash(totalCash);
            batchTotalInfo.setTotalKR(totalKR);
            batchTotalInfo.setTotalVZ(totalVZ);
            batchTotalInfo.setTotalPTA(totalPTA);
            batchTotalInfo.setTotalCouponNo(totalCouponNo);
            batchTotalInfo.setTotalTicketNo(totalTicketNo);
            batchTotalInfo.setMtdCount(totalMTD);
        }
        globalData.put(KEY_SUMMARY_DATA, totalInfos);
    }

    private void updateCashierInfo(BatchTotalInfo batchTotalInfo, int batchNo, String validator, String cashier, boolean addTicket, boolean addCoupon) {
        CashierInfo cashierInfo = null;
        for (CashierInfo info : batchTotalInfo.getCashierInfos()) {
            if (batchNo != info.getBatchNo() || !TextUtil.isSame((String)validator, (String)info.getValidator()) || !TextUtil.isSame((String)cashier, (String)info.getCashier())) continue;
            cashierInfo = info;
            break;
        }
        if (cashierInfo == null) {
            cashierInfo = new CashierInfo();
            batchTotalInfo.getCashierInfos().add(cashierInfo);
            cashierInfo.setBatchNo(batchNo);
            cashierInfo.setCashier(cashier);
            cashierInfo.setValidator(validator);
        }
        if (addTicket) {
            cashierInfo.setTicketsCount(cashierInfo.getTicketsCount() + 1);
        }
        if (addCoupon) {
            cashierInfo.setCouponsCount(cashierInfo.getCouponsCount() + 1);
        }
    }

    private static String buildWorksheetName(String groupCode, String batchCode, int i) {
        return groupCode + " " + batchCode + " " + i;
    }

    /*
     * Could not resolve type clashes
     */
    private List<TicketBatches> prepareData(PoiWorksheetData<TchTicket> data, Map<String, Object> globalData) throws Exception {
        ArrayList<TicketBatches> result = new ArrayList<TicketBatches>();
        ReportParameters params = (ReportParameters)globalData.get("key-report-params");
        Calendar cal = Calendar.getInstance();
        cal.setTime(params.getPeriodBegin());
        for (TicketsGroup ticketGroup : SplitTicketsHelper.splitTickets(data.getTickets(), cal.get(1) >= 2015, this.registriesType)) {
            TicketBatches batches = new TicketBatches();
            batches.setGroupCode(ticketGroup.getGroupCode());
            for (Map.Entry<String, List<TchTicket>> entry : ticketGroup.getTickets().entrySet()) {
                List<TchTicket> tickets = entry.getValue();
                if (tickets.isEmpty()) continue;
                ArrayList<TchRegistryItem> itemList = new ArrayList<TchRegistryItem>();
                for (TchTicket ticket : tickets) {
                    MCOCategory mcoCategory;
                    TchRegistryItem item = new TchRegistryItem();
                    BigDecimal cashValue = this.getBigDecimal(ticket.getCashValue());
                    Object krValue = this.getBigDecimal(ticket.getKrValue());
                    BigDecimal vzValue = this.getBigDecimal(ticket.getVzValue());
                    BigDecimal ccValue = this.getBigDecimal(ticket.getCreditCardValue());
                    BigDecimal ptaValue = this.getBigDecimal(ticket.getPtaValue());
                    String mtdNumber = ticket.getFops().stream().filter(pf -> pf.getType() == PaymentType.CREDIT && !TextUtil.isBlank((String)pf.getRelatedTicketNumber())).map(pf -> pf.getRelatedTicketNumber()).findFirst().orElse(null);
                    if (mtdNumber != null) {
                        item.setMtdNumber(mtdNumber);
                    }
                    if (this.isZeroSumRegistryValues(ticket)) {
                        cashValue = BigDecimal.ZERO;
                        krValue = BigDecimal.ZERO;
                        vzValue = BigDecimal.ZERO;
                        ccValue = BigDecimal.ZERO;
                        ptaValue = BigDecimal.ZERO;
                    }
                    ProductCategory productCategory = ticket.getProductCategory();
                    if (ticket.getStatus() == ProductStatus.REFUND) {
                        item.setBatch(1);
                        item.setCardValue(this.getNonZeroBigDecimal(ccValue.negate()));
                        item.setCashValue(this.getNonZeroBigDecimal(cashValue.negate()));
                        item.setCreditValue(this.getNonZeroBigDecimal(((BigDecimal)krValue).negate()));
                        item.setInterlineValue(this.getNonZeroBigDecimal(vzValue.negate()));
                        item.setPtaValue(this.getNonZeroBigDecimal(ptaValue.negate()));
                    } else if (ticket.getStatus() == ProductStatus.SELL) {
                        item.setBatch(2);
                        if ((productCategory == ProductCategory.AIR || productCategory == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.PTA) && !TextUtil.isBlank((String)ticket.getRelatedTicketNo())) {
                            item.setBatch(3);
                        }
                        if ((mcoCategory = ticket.getMcoCategory()) == MCOCategory.PENALTY || mcoCategory == MCOCategory.INFORMATION || ticket.getMcoCategory() == MCOCategory.REBOOKING) {
                            item.setBatch(ticket.isExchangePenaltyMCO() ? 3 : 1);
                            if (mcoCategory == MCOCategory.INFORMATION) {
                                cashValue = BigDecimal.ZERO;
                                krValue = BigDecimal.ZERO;
                                vzValue = BigDecimal.ZERO;
                                ccValue = BigDecimal.ZERO;
                                ptaValue = BigDecimal.ZERO;
                            }
                        }
                        item.setCardValue(this.getNonZeroBigDecimal(ccValue));
                        item.setCashValue(this.getNonZeroBigDecimal(cashValue));
                        item.setCreditValue(this.getNonZeroBigDecimal(new BigDecimal[]{krValue}));
                        item.setInterlineValue(this.getNonZeroBigDecimal(vzValue));
                        item.setPtaValue(this.getNonZeroBigDecimal(ptaValue));
                    } else if (ticket.getStatus() == ProductStatus.EXCHANGE) {
                        item.setBatch(3);
                        item.setCardValue(this.getNonZeroBigDecimal(ccValue.negate()));
                        item.setCashValue(this.getNonZeroBigDecimal(cashValue.negate()));
                        item.setCreditValue(this.getNonZeroBigDecimal(((BigDecimal)krValue).negate()));
                        item.setInterlineValue(this.getNonZeroBigDecimal(vzValue.negate()));
                        item.setPtaValue(this.getNonZeroBigDecimal(ptaValue.negate()));
                        item.setExchange(true);
                    } else if (ticket.getStatus() == ProductStatus.VOID) {
                        item.setBatch(4);
                        item.setCardValue(null);
                        item.setCashValue(null);
                        item.setCreditValue(null);
                        item.setInterlineValue(null);
                        item.setPtaValue(null);
                    }
                    mcoCategory = ticket.getMcoCategory();
                    if (productCategory == ProductCategory.AIR || productCategory == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.PTA || productCategory == ProductCategory.EXCESS_BAGAGE) {
                        item.setMcoCategory(0);
                    } else if (mcoCategory == MCOCategory.PENALTY) {
                        item.setMcoCategory(1);
                    } else if (mcoCategory == MCOCategory.INFORMATION) {
                        item.setMcoCategory(2);
                    } else {
                        item.setMcoCategory(3);
                    }
                    item.setValidator(ticket.getValidator());
                    item.setCashier(ticket.getCashier());
                    item.setTicketNumber(ticket.getTicketNumber());
                    item.setSortTicketNumber(ticket.getTicketNumber());
                    if (ticket.getStatus() == ProductStatus.SELL && (productCategory == ProductCategory.AIR || productCategory == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.PTA) && !TextUtil.isBlank((String)ticket.getRelatedTicketNo())) {
                        item.setSortTicketNumber(ticket.getRelatedTicketNo());
                    }
                    if (ticket.getStatus() == ProductStatus.SELL && productCategory == ProductCategory.MCO && (mcoCategory == MCOCategory.PENALTY || mcoCategory == MCOCategory.INFORMATION)) {
                        item.setSortTicketNumber(ticket.getRelatedTicketNo());
                    }
                    if (ticket.getStatus() == ProductStatus.VOID && !ticket.isEticket()) {
                        item.setTicketNumber(ticket.getScn());
                        item.setSortTicketNumber(ticket.getScn());
                    }
                    item.setSegment(ticket.isAdditionalSegment());
                    itemList.add(item);
                }
                Collections.sort(itemList, TicketsComparator.get());
                ArrayList cashierBatches = new ArrayList();
                ArrayList cashierBatch = new ArrayList();
                for (int n = 0; n < itemList.size(); ++n) {
                    if (!cashierBatch.isEmpty() && TextUtil.compare((String)((TchRegistryItem)itemList.get(n)).getCashier(), (String)((TchRegistryItem)cashierBatch.get(0)).getCashier(), (boolean)false, (boolean)true) != 0) {
                        cashierBatches.add(cashierBatch);
                        cashierBatch = new ArrayList();
                    }
                    cashierBatch.add(itemList.get(n));
                }
                if (!cashierBatch.isEmpty()) {
                    cashierBatches.add(cashierBatch);
                }
                ArrayList batchList = new ArrayList();
                while (true) {
                    List bigBatch = null;
                    for (List list : cashierBatches) {
                        if (list.size() < 100) continue;
                        bigBatch = list;
                        break;
                    }
                    if (bigBatch == null) break;
                    int curIndex = 0;
                    int size = bigBatch.size();
                    ArrayList delete = new ArrayList();
                    for (int n = 150; n < size; n += 150) {
                        curIndex = n;
                        ArrayList batch = new ArrayList(bigBatch.subList(n - 150, n));
                        Collections.sort(batch, BatchComparator.get());
                        batchList.add(batch);
                        delete.addAll(batch);
                    }
                    if (size - curIndex >= 100) {
                        ArrayList batch = new ArrayList(bigBatch.subList(curIndex, size));
                        Collections.sort(batch, BatchComparator.get());
                        batchList.add(batch);
                        delete.addAll(batch);
                    }
                    bigBatch.removeAll(delete);
                }
                ArrayList curBatch = new ArrayList();
                for (List batch : cashierBatches) {
                    if (curBatch.size() + batch.size() > 150) {
                        Collections.sort(curBatch, BatchComparator.get());
                        batchList.add(curBatch);
                        curBatch = new ArrayList();
                    }
                    curBatch.addAll(batch);
                }
                if (!curBatch.isEmpty()) {
                    Collections.sort(curBatch, BatchComparator.get());
                    batchList.add(curBatch);
                }
                batches.getTickets().put(entry.getKey(), batchList);
            }
            result.add(batches);
        }
        return result;
    }

    private boolean isZeroSumRegistryValues(TchTicket ticket) {
        if (ticket.isAdditionalSegment() || ticket.isConjunctedTicket()) {
            return true;
        }
        if (ticket.getBlankCategory() == BlankCategory.PRINTED_NUMBER) {
            return false;
        }
        return !ticket.isReturnFareDifference();
    }
}

